/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.utils.AssertionError;

public final class ClassUtils {
    private static byte[] byteArray = new byte[1];

    public static List getFinderMethodList(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("find")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    public static Iterator getFinderMethods(Class clazz) {
        return ClassUtils.getFinderMethodList(clazz).iterator();
    }

    public static String classToJavaSourceType(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        for (Class<?> clazz2 = clazz.getDeclaringClass(); clazz2 != null; clazz2 = clazz2.getDeclaringClass()) {
            stringBuffer.setCharAt(clazz2.getName().length(), '.');
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public static String[] classesToJavaSourceTypes(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = ClassUtils.classToJavaSourceType(classArray[i]);
        }
        return stringArray;
    }

    public static Class nameToClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (classLoader != null) {
            return classLoader.loadClass(string);
        }
        return Class.forName(string);
    }

    public static boolean isPrimitiveOrImmutable(Class clazz) {
        if (ClassUtils.isObjectPrimitive(clazz)) {
            return true;
        }
        if (clazz.isPrimitive() && !clazz.equals(Void.TYPE)) {
            return true;
        }
        if (clazz.equals(String.class)) {
            return true;
        }
        if (clazz.equals(BigInteger.class)) {
            return true;
        }
        return clazz.equals(BigDecimal.class);
    }

    public static Class getPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (!ClassUtils.isObjectPrimitive(clazz)) {
            return null;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        return null;
    }

    public static boolean isObjectPrimitive(Class clazz) {
        if (clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Long.class)) {
            return true;
        }
        if (clazz.equals(Float.class)) {
            return true;
        }
        if (clazz.equals(Double.class)) {
            return true;
        }
        if (clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Short.class)) {
            return true;
        }
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        return clazz.equals(Character.class);
    }

    public static String getDefaultValue(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "false";
            }
            if (clazz == Byte.TYPE) {
                return "(byte)0";
            }
            if (clazz == Character.TYPE) {
                return "'\\u0000'";
            }
            if (clazz == Double.TYPE) {
                return "0.0d";
            }
            if (clazz == Float.TYPE) {
                return "0.0f";
            }
            if (clazz == Integer.TYPE) {
                return "0";
            }
            if (clazz == Long.TYPE) {
                return "0L";
            }
            if (clazz == Short.TYPE) {
                return "(short)0";
            }
        } else {
            return "null";
        }
        return "";
    }

    public static String makeLegalName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (i == 0 && Character.isDigit(c)) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("_");
        }
        return stringBuffer.toString();
    }

    public static String getSQLTypeForClass(Class clazz) throws EJBCException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "java.sql.Types.BINARY";
            }
            if (clazz == Byte.TYPE) {
                return "java.sql.Types.INTEGER";
            }
            if (clazz == Character.TYPE) {
                return "java.sql.Types.CHAR";
            }
            if (clazz == Double.TYPE) {
                return "java.sql.Types.DOUBLE";
            }
            if (clazz == Float.TYPE) {
                return "java.sql.Types.FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "java.sql.Types.INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "java.sql.Types.INTEGER";
            }
            if (clazz == Short.TYPE) {
                return "java.sql.Types.INTEGER";
            }
        } else {
            if (clazz == String.class) {
                return "java.sql.Types.VARCHAR";
            }
            if (clazz == BigDecimal.class) {
                return "java.sql.Types.NUMERIC";
            }
            if (clazz == Boolean.class) {
                return "java.sql.Types.BINARY";
            }
            if (clazz == Byte.class) {
                return "java.sql.Types.INTEGER";
            }
            if (clazz == Character.class) {
                return "java.sql.Types.CHAR";
            }
            if (clazz == Double.class) {
                return "java.sql.Types.DOUBLE";
            }
            if (clazz == Float.class) {
                return "java.sql.Types.FLOAT";
            }
            if (clazz == Integer.class) {
                return "java.sql.Types.INTEGER";
            }
            if (clazz == Long.class) {
                return "java.sql.Types.INTEGER";
            }
            if (clazz == Short.class) {
                return "java.sql.Types.INTEGER";
            }
            if (clazz == java.util.Date.class) {
                return "java.sql.Types.DATE";
            }
            if (clazz == Date.class) {
                return "java.sql.Types.DATE";
            }
            if (clazz == Time.class) {
                return "java.sql.Types.TIME";
            }
            if (clazz == Timestamp.class) {
                return "java.sql.Types.TIMESTAMP";
            }
            if (clazz == byteArray.getClass()) {
                return "java.sql.Types.VARBINARY";
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return "java.sql.Types.VARBINARY";
            }
        }
        throw new EJBCException("CMP20 Could not handle a SQL type in TypeUtils.getSQLTypeForClass:  type = " + clazz);
    }

    public static boolean isValidSQLType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return true;
            }
            if (clazz == Byte.TYPE) {
                return true;
            }
            if (clazz == Character.TYPE) {
                return true;
            }
            if (clazz == Double.TYPE) {
                return true;
            }
            if (clazz == Float.TYPE) {
                return true;
            }
            if (clazz == Integer.TYPE) {
                return true;
            }
            if (clazz == Long.TYPE) {
                return true;
            }
            if (clazz == Short.TYPE) {
                return true;
            }
        } else {
            if (clazz == String.class) {
                return true;
            }
            if (clazz == Boolean.class) {
                return true;
            }
            if (clazz == Byte.class) {
                return true;
            }
            if (clazz == Character.class) {
                return true;
            }
            if (clazz == Double.class) {
                return true;
            }
            if (clazz == Float.class) {
                return true;
            }
            if (clazz == Integer.class) {
                return true;
            }
            if (clazz == Long.class) {
                return true;
            }
            if (clazz == Short.class) {
                return true;
            }
            if (clazz == java.util.Date.class) {
                return true;
            }
            if (clazz == Date.class) {
                return true;
            }
            if (clazz == Time.class) {
                return true;
            }
            if (clazz == Timestamp.class) {
                return true;
            }
            if (clazz == BigDecimal.class) {
                return true;
            }
            if (clazz == byteArray.getClass()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isByteArray(Class clazz) {
        return clazz.isArray() && clazz.getComponentType() == Byte.TYPE;
    }

    public static String setClassName(CMPBeanDescriptor cMPBeanDescriptor, String string) {
        return MethodUtils.tail(cMPBeanDescriptor.getGeneratedBeanClassName()) + "_" + string + "_Set";
    }

    public static String iteratorClassName(CMPBeanDescriptor cMPBeanDescriptor, String string) {
        return MethodUtils.tail(cMPBeanDescriptor.getGeneratedBeanClassName()) + "_" + string + "_Iterator";
    }

    public static Class getObjectClass(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            throw new AssertionError("Missing primitive in ClassUtils.getObjectClass");
        }
        return clazz;
    }

    public static Class getPrimitiveClass(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Class clazz2 = clazz;
        while (true) {
            try {
                return clazz2.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((clazz2 = clazz2.getSuperclass()) != null) continue;
                throw new NoSuchMethodException("Method " + string + " not found in the " + clazz);
            }
            break;
        }
    }

    public static String fileNameToClass(String string) {
        String string2 = "";
        string2 = string.replace(File.separator.charAt(0), '.');
        string2 = string2.substring(0, string.indexOf(".class"));
        return string2;
    }

    public static String getCanonicalName(Class clazz) {
        if (clazz.getDeclaringClass() != null) {
            String string = ClassUtils.getCanonicalName(clazz.getDeclaringClass());
            return string + "." + clazz.getName().substring(string.length() + 1);
        }
        return clazz.getName();
    }

    public static Method getMethodForNameAndParams(String string, String[] stringArray, List list) {
        if (list == null) {
            return null;
        }
        for (Method method : list) {
            String string2 = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (!string2.equals(string) || stringArray.length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getName().equals(stringArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return method;
        }
        return null;
    }

    public static List getMethodNamesForNameAndParams(String string, Class[] classArray, Method[] methodArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (methodArray == null) {
            return arrayList;
        }
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string2 = method.getName();
            Class<?>[] classArray2 = method.getParameterTypes();
            if (!string2.startsWith(string) || classArray.length != classArray2.length) continue;
            boolean bl = true;
            for (int j = 0; j < classArray2.length; ++j) {
                if (classArray2[j].getName().equals(classArray[j].getName())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(method.getName());
        }
        return arrayList;
    }
}

