/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import weblogic.ejb.container.utils.ddconverter.ConvertLog;
import weblogic.ejb.container.utils.ddconverter.DDConvertToLatest;
import weblogic.ejb.container.utils.ddconverter.DDConverterBase;
import weblogic.ejb.container.utils.ddconverter.DDConverterException;
import weblogic.ejb.container.utils.ddconverter.DDConverterFactory;
import weblogic.ejb.container.utils.ddconverter.EJBddcTextFormatter;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.utils.Getopt2;
import weblogic.utils.StackTraceUtils;

public final class DDConverter {
    private static final boolean debug = true;
    private static final EJBddcTextFormatter fmt = new EJBddcTextFormatter();

    public static void main(String[] stringArray) throws DDConverterException {
        int n;
        System.out.println("\nDEPRECATED: The weblogic.ejb.container.utils.DDConverter tool is deprecated and will be removed in a future version of WebLogic Server.  Please use weblogic.DDConverter instead.\n");
        Getopt2 getopt2 = new Getopt2();
        getopt2.setFailOnUnrecognizedOpts(true);
        getopt2.setUsageHeader("\n\nDDConverter Utility.  Convert EJB 1.0, 1.1, 2.0 deployment descriptors to the latest supported version.\n  Input:\n    DD text (not .ser) from WLS 4.5 and earlier\n    EJB 1.1 jar(s) from WLS 5.1\n    EJB 2.0 jar(s) from WLS 6.x\n  Output:\n    EJB  jar(s) for WLS 9.0");
        getopt2.setUsageArgs("-d <destDir> file1 [file2] ...");
        getopt2.addOption("d", "destDir", "The destination directory for the output jar(s).  This is a required option.");
        getopt2.addOption("c", "jarName", "A jar file into which to combine all beans in the source files");
        getopt2.addOption("EJBVer", "2.1/1.1", "The output EJB version.  For CMP beans only.  It has to be either 2.1 or 1.1.  Default is 2.1.");
        getopt2.addOption("log", "logFile", "File into which to dump log information instead of \"ddconverter.log\".");
        getopt2.addFlag("verboseLog", "Include lots of extra information in the log file.");
        getopt2.addFlag("help", "Print out this message.");
        String[] stringArray2 = getopt2.grok(stringArray).args();
        if (stringArray2.length < 1) {
            getopt2.usageAndExit("weblogic.ejb.container.utils.DDConverter");
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].endsWith(".xml")) continue;
            System.err.println("\nERROR: The input file has to be a WLS 4.5 deployment descriptor text file or WLS 5.1 jar file.");
            getopt2.usageAndExit("weblogic.ejb.container.utils.DDConverter");
        }
        if (!getopt2.hasOption("d")) {
            System.err.println("\nERROR: The -d option must be specified.");
            getopt2.usageAndExit("weblogic.ejb.container.utils.DDConverter");
        }
        String string = getopt2.getOption("d");
        String string2 = null;
        if (getopt2.hasOption("c")) {
            string2 = getopt2.getOption("c");
        }
        String string3 = "2.1";
        if (getopt2.hasOption("EJBVer")) {
            string3 = getopt2.getOption("EJBVer");
        }
        if (!string3.equals("2.1") && !string3.equals("1.1")) {
            System.err.println("\nERROR: The -EJBVer option must be 2.1 or 1.1!");
            getopt2.usageAndExit("weblogic.ejb.container.utils.DDConverter");
        }
        ConvertLog convertLog = null;
        try {
            convertLog = getopt2.hasOption("log") ? new ConvertLog(new File(getopt2.getOption("log"))) : new ConvertLog();
        }
        catch (IOException iOException) {
            System.err.println(fmt.ddconverterException(StackTraceUtils.throwable2StackTrace((Throwable)iOException)));
            System.exit(1);
        }
        if (getopt2.hasOption("verboseLog")) {
            convertLog.setVerbose(true);
        }
        if (getopt2.hasOption("help")) {
            getopt2.usageAndExit("weblogic.ejb.container.utils.DDConverter");
        }
        convertLog.logInfo(fmt.startup(DateFormat.getDateTimeInstance().format(new Date())));
        convertLog.logInfo(fmt.startupSources());
        for (n = 0; n < stringArray2.length; ++n) {
            convertLog.logInfo("\t" + stringArray2[n]);
        }
        convertLog.logInfo(fmt.startupTargetDir(string));
        if (string2 != null) {
            convertLog.logInfo(fmt.startupCombine(string2));
        }
        n = 0;
        try {
            DDConverterBase dDConverterBase = DDConverterFactory.getDDConverter(stringArray2, string, string3, convertLog);
            n = string2 != null ? (int)(dDConverterBase.convert(string2) ? 1 : 0) : (int)(dDConverterBase.convert() ? 1 : 0);
        }
        catch (Exception exception) {
            System.err.println(fmt.ddconverterException(StackTraceUtils.throwable2StackTrace((Throwable)exception)));
        }
        if (n == 0) {
            System.err.println(fmt.ddconverterFailure(convertLog.getLogFileName()));
            System.exit(1);
        }
    }

    public static void convert(EjbDescriptorBean ejbDescriptorBean) throws DDConverterException {
        new DDConvertToLatest().convert(ejbDescriptorBean);
    }

    public static void convertTo11Latest(EjbDescriptorBean ejbDescriptorBean) throws DDConverterException {
        new DDConvertToLatest(false).convert(ejbDescriptorBean);
    }
}

