/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.ContainerTransactionBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EjbRelationBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.MethodPermissionBean;
import weblogic.j2ee.descriptor.RelationshipsBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.PersistenceUseBean;
import weblogic.j2ee.descriptor.wl.SecurityRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.TransactionIsolationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsRelationBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.utils.Debug;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public final class MergeJars {
    private static final boolean verbose = true;
    private static final boolean debug = true;
    private static final String EJB_JAR = "META-INF/ejb-jar.xml";
    private static final String WEBLOGIC_EJB_JAR = "META-INF/weblogic-ejb-jar.xml";
    private static final String CMP_JAR = "META-INF/weblogic-cmp-rdbms-jar.xml";
    private String m_targetJarFileName;
    private Collection m_jars = new LinkedList();
    private Collection m_ejbDescriptors = new LinkedList();

    public void mergeJars(String[] stringArray) {
        EjbDescriptorBean ejbDescriptorBean;
        WeblogicEjbJarBean weblogicEjbJarBean;
        EjbDescriptorBean ejbDescriptorBean2 = new EjbDescriptorBean();
        this.m_targetJarFileName = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                System.out.println("Reading " + stringArray[i]);
                weblogicEjbJarBean = VirtualJarFactory.createVirtualJar((File)new File(stringArray[i]));
                this.m_jars.add(weblogicEjbJarBean);
                ejbDescriptorBean = EJBDescriptorMBeanUtils.createDescriptorFromJarFile((VirtualJarFile)weblogicEjbJarBean);
                this.m_ejbDescriptors.add(ejbDescriptorBean);
                continue;
            }
            catch (IOException iOException) {
                EJBLogger.logStackTrace((Throwable)iOException);
                continue;
            }
            catch (XMLParsingException xMLParsingException) {
                EJBLogger.logStackTrace((Throwable)((Object)xMLParsingException));
                continue;
            }
            catch (XMLProcessingException xMLProcessingException) {
                EJBLogger.logStackTrace((Throwable)((Object)xMLProcessingException));
                continue;
            }
            catch (Exception exception) {
                EJBLogger.logStackTrace((Throwable)exception);
            }
        }
        EjbJarBean ejbJarBean = ejbDescriptorBean2.createEjbJarBean();
        ejbJarBean.addDescription("Merged EJB Jar");
        ejbJarBean.addDisplayName("Merged EJB Jar");
        ejbJarBean.createEnterpriseBeans();
        weblogicEjbJarBean = ejbDescriptorBean2.createWeblogicEjbJarBean();
        weblogicEjbJarBean.setDescription("Merged Weblogic EJB Jar");
        ejbDescriptorBean = null;
        weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean = null;
        for (EjbDescriptorBean ejbDescriptorBean3 : this.m_ejbDescriptors) {
            MergeJars.addEJBJar20(ejbJarBean, ejbDescriptorBean3.getEjbJarBean());
            MergeJars.addWlEJBJar(weblogicEjbJarBean, ejbDescriptorBean3.getWeblogicEjbJarBean());
            if (null != ejbDescriptorBean3.getWeblogicRdbms11JarBeans() && ejbDescriptorBean3.getWeblogicRdbms11JarBeans().length > 0) {
                Debug.say((String)("@@@ FOUND 1.1 CMP: " + ejbDescriptorBean3.getWeblogicRdbms11JarBeans().length));
                ejbDescriptorBean = ejbDescriptorBean2.createWeblogicRdbms11JarBean();
                MergeJars.addCmpJar((WeblogicRdbmsJarBean)ejbDescriptorBean, ejbDescriptorBean3.getWeblogicRdbms11JarBeans());
                MergeJars.adjustPersistenceTypeStorage(weblogicEjbJarBean);
            }
            if (null == ejbDescriptorBean3.getWeblogicRdbmsJarBeans() || ejbDescriptorBean3.getWeblogicRdbmsJarBeans().length <= 0) continue;
            Debug.say((String)("@@@ FOUND 2.0 CMP: " + ejbDescriptorBean3.getWeblogicRdbmsJarBeans().length));
            weblogicRdbmsJarBean = ejbDescriptorBean2.createWeblogicRdbmsJarBean();
            MergeJars.addCmpJar(weblogicRdbmsJarBean, ejbDescriptorBean3.getWeblogicRdbmsJarBeans());
            MergeJars.adjustPersistenceTypeStorage(weblogicEjbJarBean);
        }
        MergeJars.createOutputJar(this.m_targetJarFileName, ejbDescriptorBean2, this.m_jars);
    }

    private static void adjustPersistenceTypeStorage(WeblogicEjbJarBean weblogicEjbJarBean) {
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            PersistenceBean persistenceBean;
            if (null == weblogicEnterpriseBeanBeanArray[i].getEntityDescriptor() || null == (persistenceBean = weblogicEnterpriseBeanBeanArray[i].getEntityDescriptor().getPersistence()) || null == persistenceBean.getPersistenceUse()) continue;
            PersistenceUseBean persistenceUseBean = persistenceBean.getPersistenceUse();
            if (null != persistenceUseBean) {
                persistenceUseBean.setTypeStorage(CMP_JAR);
                continue;
            }
            System.out.println("Warning:  couldn't find a persistence use for EJB:" + weblogicEnterpriseBeanBeanArray[i].getEjbName() + " " + persistenceBean.getPersistenceUse().getTypeIdentifier());
        }
    }

    private static boolean mustSkip(JarEntry jarEntry) {
        String string = jarEntry.getName();
        if ("META-INF/MANIFEST.MF".equals(string)) {
            return false;
        }
        return 0 == string.indexOf("META-INF/") || string.equals("_WL_GENERATED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createOutputJar(String string, EjbDescriptorBean ejbDescriptorBean, Collection collection) {
        Object object;
        System.out.println("Creating " + string);
        HashMap<String, JarEntry> hashMap = new HashMap<String, JarEntry>();
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            zipOutputStream = new JarOutputStream(fileOutputStream);
            object = new HashMap();
            for (VirtualJarFile virtualJarFile : collection) {
                Iterator iterator = virtualJarFile.entries();
                while (iterator.hasNext()) {
                    JarEntry jarEntry;
                    JarEntry jarEntry2 = (JarEntry)iterator.next();
                    if (MergeJars.mustSkip(jarEntry2)) continue;
                    Object v = ((HashMap)object).get(jarEntry2.getName());
                    if (null == v) {
                        int n;
                        ((HashMap)object).put(jarEntry2.getName(), jarEntry2);
                        jarEntry = new JarEntry(jarEntry2.getName());
                        ((JarOutputStream)zipOutputStream).putNextEntry(jarEntry);
                        InputStream inputStream = virtualJarFile.getInputStream((ZipEntry)jarEntry2);
                        byte[] byArray = new byte[1024];
                        while ((n = inputStream.read(byArray)) > 0) {
                            zipOutputStream.write(byArray, 0, n);
                        }
                        zipOutputStream.closeEntry();
                        continue;
                    }
                    jarEntry = (JarEntry)v;
                    if (jarEntry.getSize() == jarEntry2.getSize()) continue;
                    hashMap.put(jarEntry2.getName(), jarEntry2);
                }
            }
            zipOutputStream.close();
            fileOutputStream.close();
            ejbDescriptorBean.usePersistenceDestination(string);
            ejbDescriptorBean.persist();
        }
        catch (IOException iOException) {
            EJBLogger.logStackTrace((Throwable)iOException);
        }
        finally {
            try {
                if (null != zipOutputStream) {
                    zipOutputStream.close();
                }
                if (null != fileOutputStream) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        System.out.println("... done");
        if (hashMap.size() > 0) {
            System.out.println("Warning:  the following files appear in several Jar files and have \ndifferent sizes.  The output JAR file may therefore fail to deploy.");
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                System.out.println("   " + ((JarEntry)object.next()).getName());
            }
        }
    }

    private static void addCmpJar(WeblogicRdbmsJarBean weblogicRdbmsJarBean, WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray) {
        DescriptorBean descriptorBean = (DescriptorBean)weblogicRdbmsJarBean;
        for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
            WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBeanArray[i].getWeblogicRdbmsBeans();
            for (int j = 0; j < weblogicRdbmsBeanBeanArray.length; ++j) {
                descriptorBean.createChildCopy("WeblogicRdbmsBean", (DescriptorBean)weblogicRdbmsBeanBeanArray[j]);
            }
        }
    }

    private static void addCmpJar(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean, weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray) {
        DescriptorBean descriptorBean = (DescriptorBean)weblogicRdbmsJarBean;
        for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
            weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBeanArray[i].getWeblogicRdbmsBeans();
            for (int j = 0; j < weblogicRdbmsBeanBeanArray.length; ++j) {
                descriptorBean.createChildCopy("WeblogicRdbmsBean", (DescriptorBean)weblogicRdbmsBeanBeanArray[j]);
            }
            WeblogicRdbmsRelationBean[] weblogicRdbmsRelationBeanArray = weblogicRdbmsJarBeanArray[i].getWeblogicRdbmsRelations();
            for (int j = 0; j < weblogicRdbmsRelationBeanArray.length; ++j) {
                descriptorBean.createChildCopy("WeblogicRdbmsRelation", (DescriptorBean)weblogicRdbmsRelationBeanArray[j]);
            }
        }
    }

    private static void addWlEJBJar(WeblogicEjbJarBean weblogicEjbJarBean, WeblogicEjbJarBean weblogicEjbJarBean2) {
        DescriptorBean descriptorBean = (DescriptorBean)weblogicEjbJarBean;
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean2.getWeblogicEnterpriseBeans();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            descriptorBean.createChildCopy("WeblogicEnterpriseBean", (DescriptorBean)weblogicEnterpriseBeanBeanArray[i]);
        }
        SecurityRoleAssignmentBean[] securityRoleAssignmentBeanArray = weblogicEjbJarBean2.getSecurityRoleAssignments();
        for (int i = 0; i < securityRoleAssignmentBeanArray.length; ++i) {
            descriptorBean.createChildCopy("SecurityRoleAssignment", (DescriptorBean)securityRoleAssignmentBeanArray[i]);
        }
        TransactionIsolationBean[] transactionIsolationBeanArray = weblogicEjbJarBean2.getTransactionIsolations();
        for (int i = 0; i < transactionIsolationBeanArray.length; ++i) {
            descriptorBean.createChildCopy("TransactionIsolation", (DescriptorBean)transactionIsolationBeanArray[i]);
        }
    }

    private static void addEJBJar20(EjbJarBean ejbJarBean, EjbJarBean ejbJarBean2) {
        MergeJars.addBeans(ejbJarBean, ejbJarBean2.getEnterpriseBeans());
        MergeJars.addRelations(ejbJarBean, ejbJarBean2.getRelationships());
        MergeJars.addAssemblyDescriptor(ejbJarBean, ejbJarBean2.getAssemblyDescriptor());
    }

    private static void addRelations(EjbJarBean ejbJarBean, RelationshipsBean relationshipsBean) {
        if (null != relationshipsBean) {
            RelationshipsBean relationshipsBean2 = ejbJarBean.getRelationships();
            if (null == relationshipsBean2) {
                relationshipsBean2 = ejbJarBean.createRelationships();
            }
            DescriptorBean descriptorBean = (DescriptorBean)relationshipsBean2;
            EjbRelationBean[] ejbRelationBeanArray = relationshipsBean.getEjbRelations();
            for (int i = 0; i < ejbRelationBeanArray.length; ++i) {
                descriptorBean.createChildCopy("EjbRelation", (DescriptorBean)ejbRelationBeanArray[i]);
            }
        }
    }

    private static void addRelations(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean, weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray) {
        DescriptorBean descriptorBean = (DescriptorBean)weblogicRdbmsJarBean;
        for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
            WeblogicRdbmsRelationBean[] weblogicRdbmsRelationBeanArray = weblogicRdbmsJarBeanArray[i].getWeblogicRdbmsRelations();
            for (int j = 0; j < weblogicRdbmsRelationBeanArray.length; ++j) {
                descriptorBean.createChildCopy("WeblogicRdbmsRelation", (DescriptorBean)weblogicRdbmsRelationBeanArray[j]);
            }
        }
    }

    private static void addAssemblyDescriptor(EjbJarBean ejbJarBean, AssemblyDescriptorBean assemblyDescriptorBean) {
        if (null != assemblyDescriptorBean) {
            AssemblyDescriptorBean assemblyDescriptorBean2 = ejbJarBean.getAssemblyDescriptor();
            if (null == assemblyDescriptorBean2) {
                assemblyDescriptorBean2 = ejbJarBean.createAssemblyDescriptor();
            }
            DescriptorBean descriptorBean = (DescriptorBean)assemblyDescriptorBean2;
            SecurityRoleBean[] securityRoleBeanArray = assemblyDescriptorBean.getSecurityRoles();
            for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                descriptorBean.createChildCopy("SecurityRole", (DescriptorBean)securityRoleBeanArray[i]);
            }
            MethodPermissionBean[] methodPermissionBeanArray = assemblyDescriptorBean.getMethodPermissions();
            for (int i = 0; i < methodPermissionBeanArray.length; ++i) {
                descriptorBean.createChildCopy("MethodPermission", (DescriptorBean)methodPermissionBeanArray[i]);
            }
            ContainerTransactionBean[] containerTransactionBeanArray = assemblyDescriptorBean.getContainerTransactions();
            for (int i = 0; i < containerTransactionBeanArray.length; ++i) {
                descriptorBean.createChildCopy("ContainerTransaction", (DescriptorBean)containerTransactionBeanArray[i]);
            }
        }
    }

    private static void addBeans(EjbJarBean ejbJarBean, EnterpriseBeansBean enterpriseBeansBean) {
        EnterpriseBeansBean enterpriseBeansBean2 = ejbJarBean.getEnterpriseBeans();
        DescriptorBean descriptorBean = (DescriptorBean)enterpriseBeansBean2;
        EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
        for (int i = 0; i < entityBeanBeanArray.length; ++i) {
            descriptorBean.createChildCopy("Entity", (DescriptorBean)entityBeanBeanArray[i]);
        }
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            descriptorBean.createChildCopy("Session", (DescriptorBean)sessionBeanBeanArray[i]);
        }
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
        for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
            descriptorBean.createChildCopy("MessageDriven", (DescriptorBean)messageDrivenBeanBeanArray[i]);
        }
    }

    private static void ppp(String string) {
        System.out.println("[MergeJars] " + string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("MergeJars v0.81:  Merge several jar files into one.");
            System.out.println("Usage:  MergeJars outputJar inputJar [inputJar inputJar...]");
        } else {
            new MergeJars().mergeJars(stringArray);
        }
    }
}

