/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.finders.EjbqlFinder;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.utils.Debug;
import weblogic.utils.PlatformConstants;

public class MethodUtils
implements PlatformConstants {
    private static final int MAX_LINE_CHARS = 80;
    private static final int THRESHOLD = 7;

    public static String convertToFinderName(String string) {
        if (string.startsWith("ejbSelect")) {
            return string;
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        return "ejb" + string2.toUpperCase(Locale.ENGLISH) + string3;
    }

    public static String convertToDDFinderName(String string) {
        if (string.startsWith("ejbSelect")) {
            return string;
        }
        return MethodUtils.decapitalize(string.substring(3));
    }

    public static String tail(String string) {
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    public static String getParameterName(int n) {
        return MethodUtils.getParameterName(n, "param");
    }

    public static String getParameterName(int n, String string) {
        return string + n;
    }

    public static String capitalize(String string) {
        assert (string.length() > 0);
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String decapitalize(String string) {
        Debug.assertion((string.length() > 0 ? 1 : 0) != 0);
        return string.substring(0, 1).toLowerCase(Locale.ENGLISH) + string.substring(1);
    }

    public static boolean potentialBridgeCandidate(Method method, Method method2) {
        Class<?>[] classArray;
        if (!method.getName().equals(method2.getName())) {
            return false;
        }
        if (!method.getReturnType().isAssignableFrom(method2.getReturnType())) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i].isAssignableFrom(classArray[i])) continue;
            return false;
        }
        return true;
    }

    public static String getFinderMethodDeclaration(Method method, Class clazz, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = method.getModifiers();
        if (bl && Modifier.isAbstract(n)) {
            n ^= 0x400;
        }
        stringBuffer.append(Modifier.toString(n)).append(" ");
        String string = stringBuffer.toString();
        int n2 = string.indexOf("strict ");
        if (n2 != -1) {
            stringBuffer.insert(n2 + "strict".length(), "fp");
        }
        if (method.getReturnType().getName().equals("java.util.Enumeration") || method.getReturnType().getName().equals("java.util.Collection")) {
            stringBuffer.append("java.util.Collection");
        } else {
            stringBuffer.append("java.lang.Object");
        }
        if (stringBuffer.length() > 73) {
            stringBuffer.append("" + EOL + "    ");
        }
        stringBuffer.append(" ");
        stringBuffer.append(MethodUtils.convertToFinderName(method.getName()));
        if (stringBuffer.length() > 73) {
            stringBuffer.append("" + EOL + "    ");
        }
        stringBuffer.append("(");
        stringBuffer.append(MethodUtils.getParameterList(method));
        stringBuffer.append(")");
        int n3 = 0;
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].getName().equals("java.rmi.RemoteException")) continue;
            if (n3 == 0) {
                stringBuffer.append(" throws ");
            } else {
                stringBuffer.append(", ");
            }
            ++n3;
            stringBuffer.append(ClassUtils.classToJavaSourceType(classArray[i]));
            if (stringBuffer.length() <= 73) continue;
            stringBuffer.append("" + EOL + "    ");
        }
        return stringBuffer.toString();
    }

    public static String[] classesToJavaSourceTypes(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = ClassUtils.classToJavaSourceType(classArray[i]);
        }
        return stringArray;
    }

    public static List getFinderMethodList(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("find")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    public static List getFinderMethodList(Class clazz, Class clazz2) {
        int n;
        Method[] methodArray;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        if (clazz != null) {
            methodArray = clazz.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (!methodArray[n].getName().startsWith("find")) continue;
                arrayList.add(methodArray[n]);
                hashSet.add(DDUtils.getMethodSignature(methodArray[n]));
            }
        }
        if (clazz2 != null) {
            methodArray = clazz2.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (!methodArray[n].getName().startsWith("find")) continue;
                arrayList.add(methodArray[n]);
            }
        }
        return arrayList;
    }

    public static List getSelectMethodList(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("ejbSelect")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    public static Iterator getFinderMethods(Class clazz) {
        return MethodUtils.getFinderMethodList(clazz).iterator();
    }

    public static String getFinderMethodDeclaration(Finder finder, Class clazz) {
        String string = MethodUtils.convertToFinderName(finder.getName());
        List list = finder.getExternalMethodParmList();
        String string2 = MethodUtils.getFinderReturnClass(finder, clazz);
        return MethodUtils.getFinderMethodDeclaration(finder, string2, string, list);
    }

    public static String ejbSelectMDName(Finder finder) {
        Class[] classArray = finder instanceof EjbqlFinder && ((EjbqlFinder)finder).isGeneratedRelationFinder() ? new Class[]{} : finder.getParameterClassTypes();
        String string = null;
        if (finder instanceof EjbqlFinder && !((EjbqlFinder)finder).isGeneratedRelationFinder()) {
            string = MethodUtils.tail(finder.getRDBMSBean().getCMPBeanDescriptor().getGeneratedBeanClassName());
        }
        return MethodUtils.convertToEjbSelectInternalName(finder.getName(), classArray, string);
    }

    public static String getEjbSelectInternalMethodDeclaration(Finder finder, Class clazz) {
        String string = MethodUtils.ejbSelectMDName(finder);
        List list = finder.getExternalMethodAndInEntityParmList();
        String string2 = MethodUtils.getFinderReturnClass(finder, clazz);
        return MethodUtils.getFinderMethodDeclaration(finder, string2, string, list);
    }

    public static String getFinderMethodDeclaration(Finder finder, String string, String string2, List list) {
        Class[] classArray;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(finder.getModifierString());
        stringBuffer.append(string);
        if (stringBuffer.length() > 73) {
            stringBuffer.append("" + EOL + "    ");
        }
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        if (stringBuffer.length() > 73) {
            stringBuffer.append("" + EOL + "    ");
        }
        stringBuffer.append("(");
        if (finder.isKeyFinder() && ((EjbqlFinder)finder).getKeyBean().getCMPBeanDescriptor().hasComplexPrimaryKey()) {
            object = ((EjbqlFinder)finder).getKeyBean();
            classArray = ((RDBMSBean)object).getCMPBeanDescriptor();
            stringBuffer.append(classArray.getPrimaryKeyClass().getName() + " param0");
        } else {
            object = new StringBuffer();
            for (ParamNode paramNode : list) {
                ((StringBuffer)object).append(ClassUtils.classToJavaSourceType(paramNode.getParamClass()));
                ((StringBuffer)object).append(" ").append(paramNode.getParamName());
                ((StringBuffer)object).append(", ");
            }
            if (((StringBuffer)object).length() > 2) {
                ((StringBuffer)object).setLength(((StringBuffer)object).length() - 2);
            }
            stringBuffer.append(((StringBuffer)object).toString());
        }
        if (stringBuffer.length() > 73) {
            stringBuffer.append("" + EOL + "    ");
        }
        stringBuffer.append(")");
        int n = 0;
        classArray = finder.getExceptionClassTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].getName().equals("java.rmi.RemoteException")) continue;
            if (n == 0) {
                stringBuffer.append(" throws ");
            } else {
                stringBuffer.append(", ");
            }
            ++n;
            stringBuffer.append(ClassUtils.classToJavaSourceType(classArray[i]));
            if (stringBuffer.length() <= 73) continue;
            stringBuffer.append("" + EOL + "    ");
        }
        return stringBuffer.toString();
    }

    public static String getFinderReturnClass(Finder finder, Class clazz) {
        Class clazz2 = finder.getReturnClassType();
        boolean bl = Enumeration.class.isAssignableFrom(clazz2);
        if (bl |= Collection.class.isAssignableFrom(clazz2)) {
            return clazz2.getName();
        }
        if (finder.finderLoadsBean() && finder.getQueryType() != 3 && finder.getQueryType() != 5) {
            return Object.class.getName();
        }
        return ClassUtils.classToJavaSourceType(clazz);
    }

    public static String signature2identifier(String string, Class[] classArray) {
        if (string == null) {
            return "";
        }
        if (classArray == null) {
            classArray = new Class[]{};
        }
        String string2 = DDUtils.getMethodSignature(string, classArray);
        string2 = string2.replace('.', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace('[', 'A');
        string2 = string2.replace('(', '_');
        string2 = string2.replace(')', '_');
        return string2;
    }

    public static String convertToEjbSelectInternalName(String string, Class[] classArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = MethodUtils.signature2identifier(string, classArray);
        stringBuffer.append("__WL_").append(string3);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String convertToEjbSelectInternalName(String string, Class[] classArray) {
        return MethodUtils.convertToEjbSelectInternalName(string, classArray, null);
    }

    public static String varPrefix() {
        return "__WL_";
    }

    public static String getMethodName(String string) {
        return "get" + MethodUtils.capitalize(string);
    }

    public static String setMethodName(String string) {
        return "set" + MethodUtils.capitalize(string);
    }

    public static String doSetMethodName(String string) {
        return MethodUtils.varPrefix() + "doSet" + MethodUtils.capitalize(string);
    }

    public static String setRestMethodName(String string) {
        return MethodUtils.varPrefix() + "setRest" + MethodUtils.capitalize(string);
    }

    public static String checkIsRemovedMethodName(String string) {
        return MethodUtils.varPrefix() + "checkIsRemoved" + MethodUtils.capitalize(string);
    }

    public static String setCmrIsLoadedMethodName(String string) {
        return MethodUtils.varPrefix() + "set_" + string + "_isLoaded_";
    }

    public static String setNullMethodName(String string) {
        return MethodUtils.varPrefix() + "setNull" + MethodUtils.capitalize(string);
    }

    public static String postSetMethodName(String string) {
        return MethodUtils.varPrefix() + "postSet" + MethodUtils.capitalize(string);
    }

    public static String getResultSetMethodPostfix(Class clazz) {
        return MethodUtils.getMethodPostfix(clazz);
    }

    public static String getPreparedStatementMethodPostfix(Class clazz) {
        return MethodUtils.getMethodPostfix(clazz);
    }

    public static String getWSOPreInvokeMethodName(Method method) {
        return "__WL_" + method.getName() + "_WS_preInvoke";
    }

    public static String getWSOBusinessMethodName(Method method) {
        return "__WL_" + method.getName() + "_WS";
    }

    public static String getWSOPostInvokeMethodName() {
        return "__WL__WS_postInvoke";
    }

    public static String getWSOPreInvokeMethodDeclaration(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public void ");
        stringBuffer.append(MethodUtils.getWSOPreInvokeMethodName(method));
        stringBuffer.append("(");
        stringBuffer.append("AuthenticatedSubject altRunAs, ");
        stringBuffer.append("ContextHandler wsCtx");
        String string = MethodUtils.getParameterList(method, "arg");
        if (string.length() > 0) {
            stringBuffer.append(", ");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getWSOBusinessMethodDeclaration(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public ");
        Class<?> clazz = method.getReturnType();
        if (clazz != null) {
            stringBuffer.append(ClassUtils.classToJavaSourceType(clazz));
        } else {
            stringBuffer.append(" void");
        }
        stringBuffer.append(" ");
        stringBuffer.append(MethodUtils.getWSOBusinessMethodName(method));
        stringBuffer.append("(");
        stringBuffer.append(MethodUtils.getParameterList(method, "arg"));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getWSOPostInvokeMethodDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public void ");
        stringBuffer.append(MethodUtils.getWSOPostInvokeMethodName());
        stringBuffer.append("(");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getParameterList(Method method) {
        return MethodUtils.getParameterList(method, "param");
    }

    public static String getParameterList(Method method, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ClassUtils.classToJavaSourceType(classArray[i]));
            stringBuffer.append(" " + MethodUtils.getParameterName(i, string));
            if (i < classArray.length - 1) {
                stringBuffer.append(", ");
            }
            if (stringBuffer.length() <= 73) continue;
            stringBuffer.append("" + EOL + "    ");
        }
        return stringBuffer.toString();
    }

    public static String getMethodPostfix(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Boolean";
            }
            if (clazz == Byte.TYPE) {
                return "Byte";
            }
            if (clazz == Character.TYPE) {
                return "String";
            }
            if (clazz == Double.TYPE) {
                return "Double";
            }
            if (clazz == Float.TYPE) {
                return "Float";
            }
            if (clazz == Integer.TYPE) {
                return "Int";
            }
            if (clazz == Long.TYPE) {
                return "Long";
            }
            if (clazz == Short.TYPE) {
                return "Short";
            }
        } else {
            if (clazz == String.class) {
                return "String";
            }
            if (clazz == BigDecimal.class) {
                return "BigDecimal";
            }
            if (clazz == Boolean.class) {
                return "Boolean";
            }
            if (clazz == Byte.class) {
                return "Byte";
            }
            if (clazz == Character.class) {
                return "String";
            }
            if (clazz == Double.class) {
                return "Double";
            }
            if (clazz == Float.class) {
                return "Float";
            }
            if (clazz == Integer.class) {
                return "Int";
            }
            if (clazz == Long.class) {
                return "Long";
            }
            if (clazz == Short.class) {
                return "Short";
            }
            if (clazz == java.util.Date.class) {
                return "Timestamp";
            }
            if (clazz == Date.class) {
                return "Date";
            }
            if (clazz == Time.class) {
                return "Time";
            }
            if (clazz == Timestamp.class) {
                return "Timestamp";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "Bytes";
            }
            return "Bytes";
        }
        throw new AssertionError((Object)("Didn't handle a potential SQL type case in TypeUtils.getMethodPostfix: type = " + clazz));
    }

    public static String convertToPrimitive(Class clazz, String string) {
        if (clazz == Boolean.class) {
            return string + ".booleanValue()";
        }
        if (clazz == Byte.class) {
            return string + ".byteValue()";
        }
        if (clazz == Character.class) {
            return string + ".charValue()";
        }
        if (clazz == Double.class) {
            return string + ".doubleValue()";
        }
        if (clazz == Float.class) {
            return string + ".floatValue()";
        }
        if (clazz == Integer.class) {
            return string + ".intValue()";
        }
        if (clazz == Long.class) {
            return string + ".longValue()";
        }
        if (clazz == Short.class) {
            return string + ".shortValue()";
        }
        return string;
    }

    public static int dbmsType2int(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = (Integer)DDConstants.DBTYPE_MAP.get(string.toUpperCase(Locale.ENGLISH));
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static String getDefaultDBMSColType(Class clazz, int n) throws Exception {
        switch (n) {
            case 6: {
                return MethodUtils.getDefaultDBMSColType_DB_POINTBASE(clazz);
            }
            case 8: {
                return MethodUtils.getDefaultDBMSColType_DB_MYSQL(clazz);
            }
            case 1: {
                return MethodUtils.getDefaultDBMSColType_DB_ORACLE(clazz);
            }
            case 2: 
            case 5: 
            case 7: {
                return MethodUtils.getDefaultDBMSColType_DB_SQLSERVER(clazz);
            }
            case 3: {
                return MethodUtils.getDefaultDBMSColType_DB_INFORMIX(clazz);
            }
            case 4: {
                return MethodUtils.getDefaultDBMSColType_DB_DB2(clazz);
            }
            case 9: {
                return MethodUtils.getDefaultDBMDColType_DB_DERBY(clazz);
            }
        }
        return MethodUtils.getDefaultDBMSColType(clazz);
    }

    public static String getDefaultDBMSColType_DB_POINTBASE(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "BOOLEAN";
            }
            if (clazz == Byte.TYPE) {
                return "SMALLINT";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "DECIMAL";
            }
            if (clazz == Short.TYPE) {
                return "SMALLINT";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(38,19)";
            }
            if (clazz == Boolean.class) {
                return "BOOLEAN";
            }
            if (clazz == Byte.class) {
                return "SMALLINT";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "DECIMAL";
            }
            if (clazz == Short.class) {
                return "SMALLINT";
            }
            if (clazz == java.util.Date.class) {
                return "DATE";
            }
            if (clazz == Date.class) {
                return "DATE";
            }
            if (clazz == Time.class) {
                return "TIME";
            }
            if (clazz == Timestamp.class) {
                return "TIMESTAMP";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "BLOB";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "BLOB";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String getDefaultDBMSColType_DB_MYSQL(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "SMALLINT";
            }
            if (clazz == Byte.TYPE) {
                return "SMALLINT";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "DECIMAL";
            }
            if (clazz == Short.TYPE) {
                return "SMALLINT";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(38,19)";
            }
            if (clazz == Boolean.class) {
                return "TINYINT";
            }
            if (clazz == Byte.class) {
                return "SMALLINT";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "DECIMAL(32,0)";
            }
            if (clazz == Short.class) {
                return "SMALLINT";
            }
            if (clazz == java.util.Date.class) {
                return "DATE";
            }
            if (clazz == Date.class) {
                return "DATE";
            }
            if (clazz == Time.class) {
                return "TIME";
            }
            if (clazz == Timestamp.class) {
                return "TIMESTAMP";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "BLOB";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "BLOB";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String getDefaultDBMSColType_DB_ORACLE(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "INTEGER";
            }
            if (clazz == Byte.TYPE) {
                return "INTEGER";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "INTEGER";
            }
            if (clazz == Short.TYPE) {
                return "INTEGER";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(38,19)";
            }
            if (clazz == Boolean.class) {
                return "INTEGER";
            }
            if (clazz == Byte.class) {
                return "INTEGER";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "INTEGER";
            }
            if (clazz == Short.class) {
                return "INTEGER";
            }
            if (clazz == java.util.Date.class) {
                return "DATE";
            }
            if (clazz == Date.class) {
                return "DATE";
            }
            if (clazz == Time.class) {
                return "DATE";
            }
            if (clazz == Timestamp.class) {
                return "DATE";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "RAW(1000)";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "RAW(1000)";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String getDefaultDBMSColType_DB_SQLSERVER(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "BIT";
            }
            if (clazz == Byte.TYPE) {
                return "TINYINT";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "DECIMAL(38,0)";
            }
            if (clazz == Short.TYPE) {
                return "INTEGER";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(38,19)";
            }
            if (clazz == Boolean.class) {
                return "INTEGER";
            }
            if (clazz == Byte.class) {
                return "TINYINT";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "DECIMAL(38,0)";
            }
            if (clazz == Short.class) {
                return "SMALLINT";
            }
            if (clazz == java.util.Date.class) {
                return "DATETIME";
            }
            if (clazz == Date.class) {
                return "DATETIME";
            }
            if (clazz == Time.class) {
                return "DATETIME";
            }
            if (clazz == Timestamp.class) {
                return "DATETIME";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "IMAGE";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "IMAGE";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String getDefaultDBMSColType_DB_INFORMIX(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "SMALLINT";
            }
            if (clazz == Byte.TYPE) {
                return "SMALLINT";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "DECIMAL(32)";
            }
            if (clazz == Short.TYPE) {
                return "INTEGER";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(32,16)";
            }
            if (clazz == Boolean.class) {
                return "SMALLINT";
            }
            if (clazz == Byte.class) {
                return "SMALLINT";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "DECIMAL(32)";
            }
            if (clazz == Short.class) {
                return "INTEGER";
            }
            if (clazz == java.util.Date.class) {
                return "DATETIME YEAR TO DAY";
            }
            if (clazz == Date.class) {
                return "DATETIME YEAR TO DAY";
            }
            if (clazz == Time.class) {
                return "DATETIME HOUR TO FRACTION";
            }
            if (clazz == Timestamp.class) {
                return "DATETIME YEAR TO FRACTION";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "BYTE";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "BYTE";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String getDefaultDBMDColType_DB_DERBY(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "INTEGER";
            }
            if (clazz == Byte.TYPE) {
                return "INTEGER";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "DECIMAL(31)";
            }
            if (clazz == Short.TYPE) {
                return "INTEGER";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(31,16)";
            }
            if (clazz == Boolean.class) {
                return "INTEGER";
            }
            if (clazz == Byte.class) {
                return "INTEGER";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "DECIMAL(31)";
            }
            if (clazz == Short.class) {
                return "INTEGER";
            }
            if (clazz == java.util.Date.class) {
                return "DATE";
            }
            if (clazz == Date.class) {
                return "DATE";
            }
            if (clazz == Time.class) {
                return "DATE";
            }
            if (clazz == Timestamp.class) {
                return "DATETIME";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "BLOB";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "BLOB";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String getDefaultDBMSColType_DB_DB2(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "INTEGER";
            }
            if (clazz == Byte.TYPE) {
                return "INTEGER";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "DECIMAL(31)";
            }
            if (clazz == Short.TYPE) {
                return "INTEGER";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(31,16)";
            }
            if (clazz == Boolean.class) {
                return "INTEGER";
            }
            if (clazz == Byte.class) {
                return "INTEGER";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "DECIMAL(31)";
            }
            if (clazz == Short.class) {
                return "INTEGER";
            }
            if (clazz == java.util.Date.class) {
                return "DATE";
            }
            if (clazz == Date.class) {
                return "DATE";
            }
            if (clazz == Time.class) {
                return "DATE";
            }
            if (clazz == Timestamp.class) {
                return "DATETIME";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "RAW(1000)";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "RAW(1000)";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String getDefaultDBMSColType(Class clazz) throws Exception {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "INTEGER";
            }
            if (clazz == Byte.TYPE) {
                return "INTEGER";
            }
            if (clazz == Character.TYPE) {
                return "CHAR(1)";
            }
            if (clazz == Double.TYPE) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.TYPE) {
                return "FLOAT";
            }
            if (clazz == Integer.TYPE) {
                return "INTEGER";
            }
            if (clazz == Long.TYPE) {
                return "DECIMAL(32)";
            }
            if (clazz == Short.TYPE) {
                return "INTEGER";
            }
        } else {
            if (clazz == String.class) {
                return "VARCHAR(150)";
            }
            if (clazz == BigDecimal.class) {
                return "DECIMAL(32,16)";
            }
            if (clazz == Boolean.class) {
                return "INTEGER";
            }
            if (clazz == Byte.class) {
                return "INTEGER";
            }
            if (clazz == Character.class) {
                return "CHAR(1)";
            }
            if (clazz == Double.class) {
                return "DOUBLE PRECISION";
            }
            if (clazz == Float.class) {
                return "FLOAT";
            }
            if (clazz == Integer.class) {
                return "INTEGER";
            }
            if (clazz == Long.class) {
                return "DECIMAL(32)";
            }
            if (clazz == Short.class) {
                return "INTEGER";
            }
            if (clazz == java.util.Date.class) {
                return "DATE";
            }
            if (clazz == Date.class) {
                return "DATE";
            }
            if (clazz == Time.class) {
                return "DATE";
            }
            if (clazz == Timestamp.class) {
                return "DATETIME";
            }
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                return "RAW(1000)";
            }
            if (!ClassUtils.isValidSQLType(clazz) && Serializable.class.isAssignableFrom(clazz)) {
                return "RAW(1000)";
            }
        }
        throw new Exception("Could not determine default DBMS Column type from Java type: '" + clazz.toString() + "'");
    }

    public static String decodeArrayTypes(Class clazz) {
        if (clazz.getName().indexOf("[L") != -1) {
            return MethodUtils.decodeObjectTypeArrayMaybe(clazz);
        }
        return MethodUtils.decodePrimitiveTypeArrayMaybe(clazz);
    }

    public static String decodeObjectTypeArrayMaybe(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer("[]");
        int n = clazz.getName().lastIndexOf(91);
        for (int i = 0; i < n; ++i) {
            stringBuffer = stringBuffer.append("[]");
        }
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2.getName() + stringBuffer;
    }

    public static String decodePrimitiveTypeArrayMaybe(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = clazz.getName().length() - 1;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuffer = stringBuffer.append("[]");
            }
        }
        if (clazz.getName().endsWith("[Z")) {
            return "boolean" + stringBuffer;
        }
        if (clazz.getName().endsWith("[C")) {
            return "char" + stringBuffer;
        }
        if (clazz.getName().endsWith("[B")) {
            return "byte" + stringBuffer;
        }
        if (clazz.getName().endsWith("[S")) {
            return "short" + stringBuffer;
        }
        if (clazz.getName().endsWith("[I")) {
            return "int" + stringBuffer;
        }
        if (clazz.getName().endsWith("[J")) {
            return "long" + stringBuffer;
        }
        if (clazz.getName().endsWith("[F")) {
            return "float" + stringBuffer;
        }
        if (clazz.getName().endsWith("[D")) {
            return "double" + stringBuffer;
        }
        return clazz.getName();
    }

    public static String decodePrimitiveTypeArrayMaybe(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() - 1;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuffer = stringBuffer.append("[]");
            }
        }
        if (string.endsWith("[Z")) {
            return "boolean" + stringBuffer;
        }
        if (string.endsWith("[C")) {
            return "char" + stringBuffer;
        }
        if (string.endsWith("[B")) {
            return "byte" + stringBuffer;
        }
        if (string.endsWith("[S")) {
            return "short" + stringBuffer;
        }
        if (string.endsWith("[I")) {
            return "int" + stringBuffer;
        }
        if (string.endsWith("[J")) {
            return "long" + stringBuffer;
        }
        if (string.endsWith("[F")) {
            return "float" + stringBuffer;
        }
        if (string.endsWith("[D")) {
            return "double" + stringBuffer;
        }
        return string;
    }
}

