/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class PartialOrderSet
implements Set {
    public static final int ORDER_BY_TIME = 100;
    public static final int ORDER_BY_VALUE = 101;
    private static final Object PRESENT = new Object();
    private int ordering = 100;
    private boolean initialized = false;
    private boolean isComparable = false;
    private Map contents = null;
    private Node first = null;
    private Node last = null;
    private int size = 0;

    public PartialOrderSet() {
    }

    public PartialOrderSet(int n) {
        if (n != 100 && n != 101) {
            throw new IllegalArgumentException("Illegal ordering specified for " + this.getClass().getName());
        }
        this.ordering = n;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.initialized) {
            this.initialize(object);
        }
        if (this.isComparable || this.ordering == 100) {
            return this.contents.get(object) != null;
        }
        Integer n = new Integer(object.hashCode());
        for (Node node = (Node)this.contents.get(n); node != null; node = node.getNext()) {
            if (!node.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new PartialOrderIterator();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Object[] toArray(Object[] objectArray) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    private void initialize(Object object) {
        if (this.ordering == 101) {
            if (object instanceof Comparable) {
                this.isComparable = true;
            }
            this.contents = new TreeMap();
        } else {
            this.contents = new HashMap();
        }
        this.initialized = true;
    }

    public boolean add(Object object) {
        if (!this.initialized) {
            this.initialize(object);
        }
        if (object == null) {
            throw new IllegalArgumentException("Null not supported.");
        }
        boolean bl = false;
        if (this.ordering == 100) {
            if (this.contents.get(object) == null) {
                Node node = new Node(object);
                node.setPrev(this.last);
                if (this.last == null) {
                    this.first = node;
                } else {
                    this.last.setNext(node);
                }
                this.last = node;
                this.contents.put(object, node);
                bl = true;
            }
        } else if (this.isComparable) {
            bl = this.contents.put(object, PRESENT) == null;
        } else if (!this.contains(object)) {
            Integer n = new Integer(object.hashCode());
            Node node = (Node)this.contents.get(n);
            if (node == null) {
                this.contents.put(n, new Node(object));
            } else {
                Node node2 = new Node(object);
                node2.next = node.next;
                node.next = node2;
            }
            bl = true;
        }
        if (bl) {
            ++this.size;
        }
        return bl;
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    static class Node {
        private Object value = null;
        private Node next = null;
        private Node prev = null;

        public Node(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public void setNext(Node node) {
            this.next = node;
        }

        public Node getNext() {
            return this.next;
        }

        public void setPrev(Node node) {
            this.prev = node;
        }

        public Node getPrev() {
            return this.prev;
        }
    }

    class PartialOrderIterator
    implements Iterator {
        Iterator iterator = null;
        Node curr = null;

        public PartialOrderIterator() {
            if (PartialOrderSet.this.ordering == 100) {
                this.curr = PartialOrderSet.this.first;
            } else if (!PartialOrderSet.this.initialized) {
                this.iterator = new HashMap().keySet().iterator();
            } else {
                this.iterator = PartialOrderSet.this.contents.keySet().iterator();
                if (!PartialOrderSet.this.isComparable && this.iterator.hasNext()) {
                    this.curr = (Node)PartialOrderSet.this.contents.get(this.iterator.next());
                }
            }
        }

        public boolean hasNext() {
            return this.curr != null || this.iterator != null && this.iterator.hasNext();
        }

        public Object next() {
            if (this.curr != null) {
                Object object = this.curr.getValue();
                this.curr = this.curr.next;
                if (this.curr == null && this.iterator != null && this.iterator.hasNext()) {
                    this.curr = (Node)PartialOrderSet.this.contents.get(this.iterator.next());
                }
                return object;
            }
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

