/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;

public final class Serializer {
    private Serializer() {
    }

    public static void writeObject(ObjectOutputStream objectOutputStream, Object object) throws IOException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fieldArray = clazz.getDeclaredFields();
            Arrays.sort(fieldArray, new Comparator<Field>(){

                @Override
                public int compare(Field field, Field field2) {
                    return field.getName().compareTo(field2.getName());
                }
            });
            for (int i = 0; i < fieldArray.length; ++i) {
                fieldArray[i].setAccessible(true);
                if (Modifier.isTransient(fieldArray[i].getModifiers())) continue;
                objectOutputStream.writeObject(fieldArray[i].get(object));
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static void readObject(ObjectInputStream objectInputStream, Object object) throws IOException, ClassNotFoundException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fieldArray = clazz.getDeclaredFields();
            Arrays.sort(fieldArray, new Comparator<Field>(){

                @Override
                public int compare(Field field, Field field2) {
                    return field.getName().compareTo(field2.getName());
                }
            });
            for (int i = 0; i < fieldArray.length; ++i) {
                fieldArray[i].setAccessible(true);
                if (Modifier.isTransient(fieldArray[i].getModifiers())) continue;
                fieldArray[i].set(object, objectInputStream.readObject());
            }
            clazz = clazz.getSuperclass();
        }
    }
}

