/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.interfaces.WLCMPPersistenceManager;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.jdbc.wrapper.JTSConnection;
import weblogic.logging.Loggable;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;

public abstract class TableVerifier {
    protected static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final int TABLE_NOT_EXISTS = 0;
    protected static final int TABLE_EXISTS_AND_OK = 1;
    protected static final int POOL_NOT_EXISTS = 2;
    protected static final int TABLE_MISSING_COLUMNS = 3;
    protected static final int TABLE_CREATED_BY_CONTAINER = 4;
    protected static final int TABLE_CREATED_BY_USER = 5;
    public static final int SEQUENCE_NOT_EXISTS = 10;
    public static final int SEQUENCE_PROD_EXISTS_AND_OK = 11;
    public static final int SEQUENCE_DEV_EXISTS_AND_OK = 12;
    public static final int SEQUENCE_PROD_INCREMENT_LT_DBINCREMENT = 13;
    public static final int SEQUENCE_PROD_INCREMENT_GT_DBINCREMENT = 14;
    public static final int SEQUENCE_DEV_INCREMENT_LT_DBINCREMENT = 15;
    public static final int SEQUENCE_DEV_INCREMENT_GT_DBINCREMENT = 16;
    protected WLDeploymentException wldexception = null;
    protected Set newColumns;
    protected Set removedColumns;
    protected String createDefaultDBMSTable;
    private static Boolean productionModeEnabled;

    public static boolean isProductionModeEnabled() {
        if (productionModeEnabled == null) {
            boolean bl = ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled();
            productionModeEnabled = bl ? Boolean.TRUE : Boolean.FALSE;
        }
        return productionModeEnabled == Boolean.TRUE;
    }

    public void verifyOrCreateOrAlterTable(WLCMPPersistenceManager wLCMPPersistenceManager, Connection connection, String string, List list, boolean bl, List list2, Map map, Map map2, String string2, boolean bl2) throws WLDeploymentException {
        String[] stringArray = list.toArray(new String[0]);
        if (TableVerifier.isProductionModeEnabled() && !string2.equals("Disabled")) {
            EJBLogger.logTableCannotBeCreatedInProductionMode();
            string2 = "Disabled";
        }
        if (bl2 && string2 != null && !string2.equalsIgnoreCase("Disabled")) {
            EJBLogger.logTableUsesTriggerCannotBeDroppedOrCreated((String)string);
            string2 = "Disabled";
        }
        if (string2 != null && (string2.equals("DropAndCreateAlways") || string2.equals("DropAndCreate") || string2.equals("AlterOrCreate"))) {
            int n = this.isTableCreatedByContainer(wLCMPPersistenceManager, connection, string);
            if (n == 0) {
                wLCMPPersistenceManager.createDefaultDBMSTable(string);
                return;
            }
            if (n == 5) {
                EJBLogger.logTableCreatedByUser((String)string);
                string2 = "Disabled";
            }
        }
        this.createDefaultDBMSTable = string2;
        if (string2 == null || string2.equalsIgnoreCase("Disabled")) {
            this.verifyTable(wLCMPPersistenceManager, connection, string, stringArray, bl, list2, map, map2);
        } else if (string2.equalsIgnoreCase("DropAndCreateAlways")) {
            wLCMPPersistenceManager.dropAndCreateDefaultDBMSTable(string);
        } else if (string2.equalsIgnoreCase("DropAndCreate")) {
            this.dropAndCreate(wLCMPPersistenceManager, connection, string, stringArray, bl, list2, map, map2);
        } else if (string2.equalsIgnoreCase("AlterOrCreate")) {
            this.alterOrCreate(wLCMPPersistenceManager, connection, string, stringArray, bl, list2, map, map2);
        } else if (string2.equalsIgnoreCase("CreateOnly")) {
            this.createOnly(wLCMPPersistenceManager, connection, string, stringArray, bl, list2, map, map2);
        }
    }

    private void dropAndCreate(WLCMPPersistenceManager wLCMPPersistenceManager, Connection connection, String string, String[] stringArray, boolean bl, List list, Map map, Map map2) throws WLDeploymentException {
        int n = this.checkTableAndColumns(wLCMPPersistenceManager, connection, string, stringArray, bl, list, map, map2);
        if (n == 1) {
            return;
        }
        wLCMPPersistenceManager.dropAndCreateDefaultDBMSTable(string);
    }

    private void createOnly(WLCMPPersistenceManager wLCMPPersistenceManager, Connection connection, String string, String[] stringArray, boolean bl, List list, Map map, Map map2) throws WLDeploymentException {
        int n = this.checkTableAndColumns(wLCMPPersistenceManager, connection, string, stringArray, bl, list, map, map2);
        if (n == 0) {
            wLCMPPersistenceManager.createDefaultDBMSTable(string);
        } else if (n == 3) {
            if (!this.newColumns.isEmpty()) {
                String[] stringArray2 = new String[this.newColumns.size()];
                stringArray2 = this.newColumns.toArray(stringArray2);
                Loggable loggable = EJBLogger.logCmpTableMissingColumnsLoggable((String)string, (String)this.strArrayToCommaList(stringArray2));
                throw new WLDeploymentException(loggable.getMessage());
            }
            Loggable loggable = EJBLogger.logCmpTableMissingColumnsLoggable((String)string, (String)this.strArrayToCommaList(new String[0]));
            throw new WLDeploymentException(loggable.getMessage());
        }
    }

    private void alterOrCreate(WLCMPPersistenceManager wLCMPPersistenceManager, Connection connection, String string, String[] stringArray, boolean bl, List list, Map map, Map map2) throws WLDeploymentException {
        int n = this.checkTableAndColumns(wLCMPPersistenceManager, connection, string, stringArray, bl, list, map, map2);
        if (n == 0) {
            wLCMPPersistenceManager.createDefaultDBMSTable(string);
        } else {
            wLCMPPersistenceManager.alterDefaultDBMSTable(string, this.newColumns, this.removedColumns);
        }
    }

    private void verifyTable(WLCMPPersistenceManager wLCMPPersistenceManager, Connection connection, String string, String[] stringArray, boolean bl, List list, Map map, Map map2) throws WLDeploymentException {
        int n = this.checkTableAndColumns(wLCMPPersistenceManager, connection, string, stringArray, bl, list, map, map2);
        if (n == 1) {
            return;
        }
        if (n == 0) {
            Loggable loggable = EJBLogger.logDeploymentFailedTableDoesNotExistLoggable((String)wLCMPPersistenceManager.getEjbName(), (String)string);
            loggable.log();
            throw new WLDeploymentException(loggable.getMessage());
        }
        if (n == 3) {
            if (!this.newColumns.isEmpty()) {
                String[] stringArray2 = new String[this.newColumns.size()];
                stringArray2 = this.newColumns.toArray(stringArray2);
                Loggable loggable = EJBLogger.logCmpTableMissingColumnsLoggable((String)string, (String)this.strArrayToCommaList(stringArray2));
                throw new WLDeploymentException(loggable.getMessage());
            }
            throw new AssertionError("The table verification failed for unknown reason.Please try redeploying the bean");
        }
    }

    public abstract int checkTableAndColumns(WLCMPPersistenceManager var1, Connection var2, String var3, String[] var4, boolean var5, List var6, Map var7, Map var8);

    public abstract int isTableCreatedByContainer(WLCMPPersistenceManager var1, Connection var2, String var3);

    protected String strArrayToCommaList(String[] stringArray) {
        assert (stringArray != null);
        assert (stringArray.length > 0);
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public String verifyOrCreateOrAlterSequence(Connection connection, String string, int n, String string2, int n2) throws WLDeploymentException {
        if (TableVerifier.isProductionModeEnabled() && !string2.equals("Disabled")) {
            EJBLogger.logSequenceCannotBeAlteredInProductionMode((String)string);
            string2 = "Disabled";
        }
        int n3 = this.verifySequence(connection, string, n, n2);
        if (n2 == 1 && n3 == 10) {
            String string3 = string;
            string = this.resolveIfOracleSynonym(connection, string3);
            if (debugLogger.isDebugEnabled() && string != string3) {
                TableVerifier.debug(string3 + " resolved to sequence: " + string + ", verifying the validity of the actual Oracle sequence");
            }
            if (((n3 = this.verifySequence(connection, string, n, n2)) == 11 || n3 == 12) && debugLogger.isDebugEnabled()) {
                TableVerifier.debug(string3 + " resolved to a valid oracle sequence: " + string);
                string = string3;
            }
        }
        if (TableVerifier.isProductionModeEnabled()) {
            if (n3 == 11) {
                return string;
            }
            if (n3 == 13) {
                this.logWarningSequenceIncrementLesserThanDBIncrement(string, n);
                return string;
            }
            if (n3 == 14) {
                this.throwSequenceIncrementGreaterThanDBIncrement(string, n);
            }
            this.throwSequenceNotExists(string, n);
        }
        if (n3 == 11) {
            return string;
        }
        if (n3 == 12) {
            return RDBMSUtils.getContainerSequenceName(string);
        }
        if (n3 == 13) {
            this.logWarningSequenceIncrementLesserThanDBIncrement(string, n);
            return string;
        }
        if (string2 == null || string2.equalsIgnoreCase("Disabled")) {
            if (n3 == 10) {
                this.throwSequenceNotExists(string, n);
            } else {
                if (n3 == 15) {
                    this.logWarningSequenceIncrementLesserThanDBIncrement(RDBMSUtils.getContainerSequenceName(string), n);
                    return RDBMSUtils.getContainerSequenceName(string);
                }
                if (n3 == 14) {
                    this.throwSequenceIncrementGreaterThanDBIncrement(string, n);
                } else if (n3 == 16) {
                    this.throwSequenceIncrementGreaterThanDBIncrement(RDBMSUtils.getContainerSequenceName(string), n);
                } else {
                    throw new AssertionError("Sequence: '" + string + "' increment '" + n + "' Unknown SEQUENCE STATUS CODE: " + n3);
                }
            }
        }
        if (n3 == 14) {
            this.throwSequenceIncrementGreaterThanDBIncrement(string, n);
        }
        if (string2.equalsIgnoreCase("CreateOnly")) {
            return this.createOnlySequence(connection, n3, RDBMSUtils.getContainerSequenceName(string), n, n2);
        }
        assert (string2.equalsIgnoreCase("DropAndCreateAlways") || string2.equalsIgnoreCase("DropAndCreate") || string2.equalsIgnoreCase("AlterOrCreate")) : "Unknown table creation option code " + string2;
        return this.alterOrCreateSequence(connection, n3, RDBMSUtils.getContainerSequenceName(string), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String resolveIfOracleSynonym(Connection connection, String string) throws WLDeploymentException {
        String string2;
        block24: {
            ResultSet resultSet;
            Statement statement;
            block22: {
                statement = null;
                resultSet = null;
                String string3 = null;
                int n = 0;
                String string4 = null;
                String string5 = null;
                string2 = null;
                n = string.indexOf(".");
                if (n != -1) {
                    string4 = string.substring(0, n);
                    string5 = string.substring(n + 1);
                    string3 = "SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME= UPPER( ? ) AND OWNER = UPPER( ? )";
                    statement = connection.prepareStatement(string3);
                    statement.setString(1, string5);
                    statement.setString(2, string4);
                } else {
                    string3 = "SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME= UPPER( ? )";
                    statement = connection.prepareStatement(string3);
                    statement.setString(1, string);
                }
                if (debugLogger.isDebugEnabled()) {
                    TableVerifier.debug("Query for resolving the synonym to its sequenceName: " + string3);
                }
                if ((resultSet = statement.executeQuery()).next()) {
                    string2 = resultSet.getString("TABLE_NAME");
                    break block22;
                }
                string2 = string;
            }
            Object var12_10 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block24;
            }
            catch (Exception exception) {}
            break block24;
            {
                catch (Exception exception) {
                    Object var12_11 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block24;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string2;
    }

    /*
     * Loose catch block
     */
    private int verifySequence(Connection connection, String string, int n, int n2) throws WLDeploymentException {
        ResultSet resultSet;
        Statement statement;
        block57: {
            block61: {
                int n3;
                block58: {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    block48: {
                        block52: {
                            block49: {
                                statement = null;
                                resultSet = null;
                                string5 = null;
                                int n4 = 0;
                                string4 = null;
                                string3 = null;
                                string2 = null;
                                n4 = string.indexOf(".");
                                if (n4 != -1) {
                                    string4 = string.substring(0, n4);
                                    string3 = string.substring(n4 + 1);
                                    string5 = this.getSequenceQuery(n2, string3, string4);
                                } else {
                                    string5 = this.getSequenceQuery(n2, string, null);
                                }
                                statement = connection.createStatement();
                                resultSet = statement.executeQuery(string5);
                                if (!resultSet.next()) break block48;
                                n3 = resultSet.getInt(1);
                                if (n >= Math.abs(n3)) break block49;
                                int n5 = 13;
                                Object var15_22 = null;
                                try {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    if (statement != null) {
                                        statement.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return n5;
                            }
                            if (n <= Math.abs(n3)) break block52;
                            int n6 = 14;
                            Object var15_23 = null;
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return n6;
                        }
                        int n7 = 11;
                        Object var15_24 = null;
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return n7;
                    }
                    if (string4 != null) {
                        string2 = RDBMSUtils.getContainerSequenceName(string3);
                        string5 = this.getSequenceQuery(n2, string2, string4);
                    } else {
                        string2 = RDBMSUtils.getContainerSequenceName(string);
                        string5 = this.getSequenceQuery(n2, string2, null);
                    }
                    resultSet = statement.executeQuery(string5);
                    if (!resultSet.next()) break block57;
                    n3 = resultSet.getInt(1);
                    if (n >= Math.abs(n3)) break block58;
                    int n8 = 15;
                    Object var15_25 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n8;
                }
                if (n <= Math.abs(n3)) break block61;
                int n9 = 16;
                Object var15_26 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return n9;
            }
            int n10 = 12;
            Object var15_27 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n10;
        }
        int n11 = 10;
        Object var15_28 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n11;
        catch (Exception exception) {
            try {
                Loggable loggable = EJBLogger.logSequenceSetupFailureLoggable((String)string, (String)Integer.toString(n), (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            catch (Throwable throwable) {
                Object var15_29 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception2) {}
                throw throwable;
            }
        }
    }

    private String getSequenceQuery(int n, String string, String string2) {
        switch (n) {
            case 1: {
                if (string2 != null) {
                    return "SELECT INCREMENT_BY FROM ALL_SEQUENCES WHERE SEQUENCE_NAME = UPPER('" + string + "') " + "AND SEQUENCE_OWNER = UPPER('" + string2 + "')";
                }
                return "SELECT INCREMENT_BY FROM ALL_SEQUENCES WHERE SEQUENCE_NAME = UPPER('" + string + "')";
            }
            case 4: {
                if (string2 != null) {
                    return "SELECT INCREMENT FROM SYSIBM.SYSSEQUENCES WHERE UPPER(SEQNAME)=UPPER('" + string + "') " + "AND UPPER(SEQSCHEMA)=UPPER('" + string2 + "')";
                }
                return "SELECT INCREMENT FROM SYSIBM.SYSSEQUENCES WHERE UPPER(SEQNAME)=UPPER('" + string + "')";
            }
            case 3: {
                if (string2 != null) {
                    return "SELECT SEQ.INC_VAL FROM SYSSEQUENCES SEQ, SYSTABLES TAB WHERE UPPER(TAB.TABNAME)=UPPER('" + string + "') " + "AND UPPER(TAB.OWNER)=UPPER('" + string2 + "') " + "AND SEQ.TABID=TAB.TABID";
                }
                return "SELECT SEQ.INC_VAL FROM SYSSEQUENCES SEQ, SYSTABLES TAB WHERE UPPER(TAB.TABNAME)=UPPER('" + string + "') " + "AND SEQ.TABID=TAB.TABID";
            }
        }
        throw new AssertionError("Unexpected dbType: " + n);
    }

    private String createOnlySequence(Connection connection, int n, String string, int n2, int n3) throws WLDeploymentException {
        Debug.assertion((boolean)RDBMSUtils.isContainerSequenceName(string), (String)("called with a non-development sequence name '" + string + "'"));
        if (n == 16 || n == 15) {
            this.throwIncrementMismatch(string, n2);
        }
        return this.createSequence(connection, string, n2, n3);
    }

    private String alterOrCreateSequence(Connection connection, int n, String string, int n2, int n3) throws WLDeploymentException {
        Debug.assertion((boolean)RDBMSUtils.isContainerSequenceName(string), (String)("called with a non-development sequence name '" + string + "'"));
        if (n == 12) {
            return string;
        }
        if (n == 10) {
            return this.createOnlySequence(connection, n, string, n2, n3);
        }
        if (n == 16 || n == 15) {
            return this.alterSequence(connection, string, n2, n3);
        }
        throw new AssertionError("Unknown SEQUENCE STATUS CODE: " + n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createSequence(Connection connection, String string, int n, int n2) throws WLDeploymentException {
        String string3;
        Debug.assertion((boolean)RDBMSUtils.isContainerSequenceName(string), (String)("called with a non-development sequence name '" + string + "'"));
        Statement statement = null;
        Object var6_6 = null;
        String string2 = this.getSequenceCreateStatement(n2, string, n);
        try {
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate(string2);
                }
                catch (Exception exception) {
                    Loggable loggable = EJBLogger.logFailedToCreateSequenceLoggable((String)string, (String)Integer.toString(n), (String)exception.getMessage());
                    throw new WLDeploymentException(loggable.getMessage(), exception);
                }
                string3 = string;
                Object var11_13 = null;
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logSequenceSetupFailureLoggable((String)string, (String)Integer.toString(n), (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return string3;
        }
        if (statement == null) return string3;
        statement.close();
        return string3;
    }

    private String getSequenceCreateStatement(int n, String string, int n2) {
        switch (n) {
            case 1: 
            case 4: {
                return "CREATE SEQUENCE " + string + " INCREMENT BY " + n2;
            }
            case 3: {
                return "CREATE SEQUENCE " + string + " INCREMENT " + n2;
            }
        }
        throw new AssertionError("Unexpected dbType: " + n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String alterSequence(Connection connection, String string, int n, int n2) throws WLDeploymentException {
        String string3;
        Debug.assertion((boolean)RDBMSUtils.isContainerSequenceName(string), (String)("called with a non-development sequence name '" + string + "'"));
        Statement statement = null;
        String string2 = this.getSequenceAlterStatement(n2, string, n);
        try {
            try {
                statement = connection.createStatement();
                statement.executeUpdate(string2);
                string3 = string;
                Object var10_9 = null;
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logFailedToAlterSequenceLoggable((String)string, (String)Integer.toString(n), (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return string3;
        }
        if (statement == null) return string3;
        statement.close();
        return string3;
    }

    private String getSequenceAlterStatement(int n, String string, int n2) {
        switch (n) {
            case 1: 
            case 4: {
                return "ALTER SEQUENCE " + string + " INCREMENT BY " + n2;
            }
            case 3: {
                return "ALTER SEQUENCE " + string + " INCREMENT " + n2;
            }
        }
        throw new AssertionError("Unexpected dbType: " + n);
    }

    private void throwSequenceNotExists(String string, int n) throws WLDeploymentException {
        Loggable loggable = EJBLogger.logSequenceNotExistLoggable((String)string, (String)Integer.toString(n));
        throw new WLDeploymentException(loggable.getMessage());
    }

    private void throwIncrementMismatch(String string, int n) throws WLDeploymentException {
        Loggable loggable = EJBLogger.logSequenceIncrementMismatchLoggable((String)string, (String)Integer.toString(n));
        throw new WLDeploymentException(loggable.getMessage());
    }

    private void logWarningSequenceIncrementLesserThanDBIncrement(String string, int n) {
        EJBLogger.logWarningSequenceIncrementLesserThanDBIncrement((String)string, (String)Integer.toString(n));
    }

    private void throwSequenceIncrementGreaterThanDBIncrement(String string, int n) throws WLDeploymentException {
        Loggable loggable = EJBLogger.logErrorSequenceIncrementGreaterThanDBIncrementLoggable((String)string, (String)Integer.toString(n));
        throw new WLDeploymentException(loggable.getMessage());
    }

    public int verifyDatabaseType(Connection connection, int n) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            String string2 = databaseMetaData.getDriverName();
            if (debugLogger.isDebugEnabled()) {
                TableVerifier.debug("DB product name is " + string);
                TableVerifier.debug("DB Driver name is " + string2);
            }
            if (string.indexOf("Microsoft") != -1) {
                string = "SQL_SERVER";
            }
            if (string.indexOf("Derby") != -1) {
                string = "DERBY";
            } else if (string.indexOf("DB2") != -1) {
                string = "DB2";
            } else if (string.indexOf("Sybase") != -1 || string.indexOf("Adaptive Server Enterprise") != -1 || string2.startsWith("Sybase") || string2.startsWith("jConnect")) {
                string = "SYBASE";
            } else if (string.indexOf("Informix") != -1) {
                string = "INFORMIX";
            }
            if (n == 0) {
                Integer n2 = (Integer)DDConstants.DBTYPE_MAP.get(string.toUpperCase(Locale.ENGLISH));
                if (n2 != null) {
                    n = n2;
                }
            } else {
                String string3 = DDConstants.getDBNameForType(n);
                if (string3 != null && string3.equalsIgnoreCase("SQLSERVER")) {
                    string3 = "SQL_SERVER";
                }
                if (string3 != null && string3.equalsIgnoreCase("SQLSERVER2000")) {
                    string3 = "SQL_SERVER";
                }
                if (string3 != null && !string.equalsIgnoreCase(string3)) {
                    EJBLogger.logErrorAboutDatabaseType((String)string3, (String)string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private String getPoolName(Connection connection) {
        String string = "";
        if (connection instanceof JTSConnection) {
            JTSConnection jTSConnection = (JTSConnection)connection;
            string = jTSConnection.getPool();
        }
        return string;
    }

    private static void debug(String string) {
        debugLogger.debug("[TableVerifier] " + string);
    }
}

