/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import weblogic.utils.AssertionError;
import weblogic.utils.Debug;

public final class ToStringUtils {
    public static String isoToString(Integer n) {
        return ToStringUtils.isoToString(n == null ? -1 : n);
    }

    public static String isoToString(int n) {
        switch (n) {
            case -1: {
                return "No Isolation Level Set";
            }
            case 0: {
                return "NONE";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 2: {
                return "READ_COMMITED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new AssertionError("Bad iso level: " + n);
    }

    public static String txAttributeToString(int n) {
        switch (n) {
            case 5: {
                return "TX_NEVER";
            }
            case 0: {
                return "TX_NOT_SUPPORTED";
            }
            case 2: {
                return "TX_SUPPORTS";
            }
            case 1: {
                return "TX_REQUIRED";
            }
            case 3: {
                return "TX_REQUIRES_NEW";
            }
            case 4: {
                return "TX_MANDATORY";
            }
        }
        Debug.stackdump((String)("Bad tx attribute: " + n));
        throw new AssertionError("Bad tx attribute: " + n);
    }

    public static String escapedQuotesToString(String string) {
        int n = 0;
        while ((n = string.indexOf("'", n)) != -1) {
            String string2 = n > 0 ? string.substring(0, n) + "''" : "''";
            string = n < string.length() - 1 ? string2 + string.substring(n + 1) : string2;
            n += 2;
        }
        return string;
    }

    public static String escapeBackSlash(String string) {
        int n = 0;
        int n2 = string.indexOf(92, n);
        if (n2 != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = string.length() - 1;
            while (n2 != -1) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append("\\\\");
                n = n2 + 1;
                if (n > n3) break;
                n2 = string.indexOf(92, n);
            }
            if (n <= n3) {
                stringBuffer.append(string.substring(n, n3 + 1));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String chop(String string) {
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.length() - 1;
        while (string.charAt(n) == ' ') {
            string = string.substring(0, n);
            --n;
        }
        return string;
    }

    public static String adjust(String string, String string2) {
        int n = string2.length();
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 < n) {
            for (int i = 0; i < n - n2; ++i) {
                string = string.concat(" ");
            }
        } else {
            string = string.substring(0, n);
        }
        return string;
    }
}

