/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import weblogic.ejb.container.utils.ddconverter.EJBddcTextFormatter;
import weblogic.utils.StackTraceUtils;

public final class ConvertLog {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final String DEFAULT_LOG_NAME = "ddconverter.log";
    private boolean verboseLog = false;
    private boolean hasErrors = false;
    private String logFileName;
    private BufferedWriter logWriter;
    private BufferedWriter stderrWriter = new BufferedWriter(new OutputStreamWriter(System.err));
    private EJBddcTextFormatter fmt = new EJBddcTextFormatter();

    public ConvertLog() throws IOException {
        this(new File(DEFAULT_LOG_NAME));
    }

    public ConvertLog(File file) throws IOException {
        this.logFileName = file.getPath();
        this.logWriter = new BufferedWriter(new FileWriter(file));
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public boolean getVerbose() {
        return this.verboseLog;
    }

    public void setVerbose(boolean bl) {
        this.verboseLog = bl;
    }

    public void logError(String string) {
        this.log(this.fmt.error());
        this.logln(" " + string);
        this.hasErrors = true;
    }

    public void logWarning(String string) {
        this.log(this.fmt.warning());
        this.logln(" " + string);
    }

    public void logInfo(String string) {
        this.logln(string);
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private void logln(String string) {
        this.log(string);
        this.log("\n");
    }

    private void log(String string) {
        try {
            this.logWriter.write(string);
            this.logWriter.flush();
            this.stderrWriter.write(string);
            this.stderrWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println(this.fmt.logWriteError(string, StackTraceUtils.throwable2StackTrace((Throwable)iOException)));
        }
    }
}

