/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLtoEJBQL;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.container.utils.ddconverter.ConvertLog;
import weblogic.ejb.container.utils.ddconverter.DDConverterBase;
import weblogic.ejb.container.utils.ddconverter.DDConverterException;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.ContainerTransactionBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.MethodParamsBean;
import weblogic.j2ee.descriptor.MethodPermissionBean;
import weblogic.j2ee.descriptor.QueryBean;
import weblogic.j2ee.descriptor.QueryMethodBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.FieldMapBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.PersistenceUseBean;
import weblogic.j2ee.descriptor.wl.SecurityRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.TableMapBean;
import weblogic.j2ee.descriptor.wl.TransactionIsolationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl60.BaseWeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.FinderBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class DDConvertToLatest
extends DDConverterBase {
    private final boolean debug = false;
    private VirtualJarFile[] targetVirtualJars;
    private EjbDescriptorBean targetDesc;

    public DDConvertToLatest() {
    }

    public DDConvertToLatest(boolean bl) {
        this.convertTo20 = bl;
    }

    public DDConvertToLatest(String[] stringArray, String string, ConvertLog convertLog, boolean bl) throws DDConverterException {
        super(stringArray, string, convertLog, true);
        this.targetVirtualJars = new VirtualJarFile[stringArray.length];
        this.convertTo20 = bl;
    }

    public boolean convert() throws DDConverterException, IOException {
        for (int i = 0; i < this.sources.length; ++i) {
            String string;
            System.out.println(this.fmt.converting(this.sources[i]));
            JarFile jarFile = new JarFile(this.sources[i]);
            EjbDescriptorBean ejbDescriptorBean = null;
            try {
                ejbDescriptorBean = EJBDescriptorMBeanUtils.createDescriptorFromJarFile(VirtualJarFactory.createVirtualJar((JarFile)jarFile), true);
                string = ejbDescriptorBean.getParsingErrorMessage();
                if (string != null && string.length() > 0) {
                    this.log.logError(this.fmt.readDDError("ejb-jar.xml,weblogic-ejb-jar.xml or weblogic-cmp-rdbms-jar.xml", string));
                }
            }
            catch (Exception exception) {
                this.log.logError(this.fmt.readDDError("ejb-jar.xml, weblogic-ejb-jar.xml", StackTraceUtils.throwable2StackTrace((Throwable)exception)));
                return false;
            }
            this.convert(ejbDescriptorBean);
            string = new File(jarFile.getName()).getName();
            File file = new File(this.targetDirName, string);
            this.normalizeDescriptor(ejbDescriptorBean);
            ejbDescriptorBean.usePersistenceDestination(file.getPath());
            try {
                ejbDescriptorBean.persist();
            }
            catch (Exception exception) {
                EJBLogger.logStackTrace((Throwable)exception);
            }
            this.targetVirtualJars[i] = VirtualJarFactory.createVirtualJar((JarFile)new JarFile(file));
        }
        return !this.log.hasErrors();
    }

    public boolean convert(String string) throws DDConverterException, IOException {
        this.convert();
        this.targetDesc = new EjbDescriptorBean();
        String string2 = this.targetDirName + File.separatorChar + string;
        this.targetDesc.usePersistenceDestination(string2);
        EjbJarBean ejbJarBean = this.targetDesc.getEjbJarBean();
        for (int i = 0; i < this.targetVirtualJars.length; ++i) {
            Object var13_13;
            JarFile jarFile = new JarFile(this.sources[i]);
            this.targetVirtualJars[i] = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
            try {
                block6: {
                    try {
                        EjbDescriptorBean ejbDescriptorBean = EJBDescriptorMBeanUtils.createDescriptorFromJarFile(this.targetVirtualJars[i], true);
                        String string3 = ejbDescriptorBean.getParsingErrorMessage();
                        if (string3 != null && string3.trim().length() > 0) {
                            throw new Exception(string3);
                        }
                        this.updateTargetEJBJarMBean(ejbJarBean, ejbDescriptorBean);
                        WeblogicEjbJarBean weblogicEjbJarBean = this.targetDesc.getWeblogicEjbJarBean();
                        this.updateTargetWeblogicEJBJarMBean(weblogicEjbJarBean, ejbDescriptorBean);
                        weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray = ejbDescriptorBean.getWeblogicRdbmsJarBeans();
                        if (weblogicRdbmsJarBeanArray == null || weblogicRdbmsJarBeanArray.length <= 0) break block6;
                        weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean = this.targetDesc.createWeblogicRdbmsJarBean();
                        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
                        this.combineRDBMSJarBeans(weblogicRdbmsJarBean, weblogicEnterpriseBeanBeanArray, weblogicRdbmsJarBeanArray);
                    }
                    catch (Exception exception) {
                        this.log.logError(this.fmt.readDDError("ejb-jar.xml, weblogic-ejb-jar.xml", StackTraceUtils.throwable2StackTrace((Throwable)exception)));
                        throw new DDConverterException(exception);
                    }
                }
                var13_13 = null;
            }
            catch (Throwable throwable) {
                var13_13 = null;
                this.targetVirtualJars[i].close();
                throw throwable;
            }
            this.targetVirtualJars[i].close();
        }
        this.normalizeDescriptor(this.targetDesc);
        this.targetDesc.persist();
        return true;
    }

    public void convert(EjbDescriptorBean ejbDescriptorBean) throws DDConverterException {
        if (ejbDescriptorBean != null && this.convertTo20) {
            this.convertCMPTo2x(ejbDescriptorBean);
        }
    }

    private void updateTargetEJBJarMBean(EjbJarBean ejbJarBean, EjbDescriptorBean ejbDescriptorBean) {
        int n;
        SessionBeanBean[] sessionBeanBeanArray = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans().getSessions();
        EntityBeanBean[] entityBeanBeanArray = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans().getEntities();
        DescriptorBean descriptorBean = (DescriptorBean)ejbJarBean.getEnterpriseBeans();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            descriptorBean.createChildCopy("Session", (DescriptorBean)sessionBeanBeanArray[n]);
        }
        for (n = 0; n < entityBeanBeanArray.length; ++n) {
            descriptorBean.createChildCopy("Entity", (DescriptorBean)entityBeanBeanArray[n]);
        }
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        if (assemblyDescriptorBean == null) {
            assemblyDescriptorBean = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor();
            descriptorBean = (DescriptorBean)ejbJarBean;
            descriptorBean.createChildCopy("AssemblyDescriptor", (DescriptorBean)assemblyDescriptorBean);
        } else {
            SecurityRoleBean[] securityRoleBeanArray = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor().getSecurityRoles();
            descriptorBean = (DescriptorBean)assemblyDescriptorBean;
            for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                descriptorBean.createChildCopy("SecurityRole", (DescriptorBean)securityRoleBeanArray[i]);
            }
            MethodPermissionBean[] methodPermissionBeanArray = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor().getMethodPermissions();
            for (int i = 0; i < methodPermissionBeanArray.length; ++i) {
                descriptorBean.createChildCopy("MethodPermission", (DescriptorBean)methodPermissionBeanArray[i]);
            }
            ContainerTransactionBean[] containerTransactionBeanArray = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor().getContainerTransactions();
            for (int i = 0; i < containerTransactionBeanArray.length; ++i) {
                descriptorBean.createChildCopy("ContainerTransaction", (DescriptorBean)containerTransactionBeanArray[i]);
            }
        }
    }

    private void updateTargetWeblogicEJBJarMBean(WeblogicEjbJarBean weblogicEjbJarBean, EjbDescriptorBean ejbDescriptorBean) {
        if (weblogicEjbJarBean == null) {
            weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
            this.targetDesc.setWeblogicEjbJarBean(weblogicEjbJarBean);
        } else {
            WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getWeblogicEnterpriseBeans();
            DescriptorBean descriptorBean = (DescriptorBean)weblogicEjbJarBean;
            for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
                descriptorBean.createChildCopy("WeblogicEnterpriseBean", (DescriptorBean)weblogicEnterpriseBeanBeanArray[i]);
            }
            SecurityRoleAssignmentBean[] securityRoleAssignmentBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getSecurityRoleAssignments();
            for (int i = 0; i < securityRoleAssignmentBeanArray.length; ++i) {
                descriptorBean.createChildCopy("SecurityRoleAssignment", (DescriptorBean)securityRoleAssignmentBeanArray[i]);
            }
            TransactionIsolationBean[] transactionIsolationBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getTransactionIsolations();
            for (int i = 0; i < transactionIsolationBeanArray.length; ++i) {
                descriptorBean.createChildCopy("TransactionIsolation", (DescriptorBean)transactionIsolationBeanArray[i]);
            }
        }
    }

    private void combineRDBMSJarBeans(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean, WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray, weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray) {
        DescriptorBean descriptorBean = (DescriptorBean)weblogicRdbmsJarBean;
        for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
            weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBeanArray[i].getWeblogicRdbmsBeans();
            for (int j = 0; j < weblogicRdbmsBeanBeanArray.length; ++j) {
                descriptorBean.createChildCopy("WeblogicRdbmsBean", (DescriptorBean)weblogicRdbmsBeanBeanArray[j]);
            }
        }
    }

    private void convertCMPTo2x(EjbDescriptorBean ejbDescriptorBean) throws DDConverterException {
        this.convertCMPBeansTo2x(ejbDescriptorBean);
        this.convertRDBMSDescriptorsTo2x(ejbDescriptorBean);
    }

    private void convertCMPBeansTo2x(EjbDescriptorBean ejbDescriptorBean) throws DDConverterException {
        EntityBeanBean[] entityBeanBeanArray = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans().getEntities();
        for (int i = 0; i < entityBeanBeanArray.length; ++i) {
            EntityBeanBean entityBeanBean = entityBeanBeanArray[i];
            CompositeMBeanDescriptor compositeMBeanDescriptor = null;
            try {
                compositeMBeanDescriptor = new CompositeMBeanDescriptor((EnterpriseBeanBean)entityBeanBean, ejbDescriptorBean);
            }
            catch (WLDeploymentException wLDeploymentException) {
                throw new DDConverterException(wLDeploymentException);
            }
            if (!entityBeanBean.getPersistenceType().equalsIgnoreCase("Container")) continue;
            if (entityBeanBean.getAbstractSchemaName() == null) {
                entityBeanBean.setAbstractSchemaName(DDConvertToLatest.makeAbstractSchemaName(entityBeanBean.getEjbName()));
                entityBeanBean.setCmpVersion("2.x");
            }
            this.convertWLQLToEJBQL(compositeMBeanDescriptor);
            this.convertWLBean(compositeMBeanDescriptor);
        }
    }

    private void convertWLBean(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        PersistenceUseBean persistenceUseBean;
        PersistenceBean persistenceBean;
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = compositeMBeanDescriptor.getWlBean();
        if (this.convertTo20 && (persistenceBean = weblogicEnterpriseBeanBean.getEntityDescriptor().getPersistence()) != null && (persistenceUseBean = persistenceBean.getPersistenceUse()) != null) {
            persistenceUseBean.setTypeVersion("7.0");
        }
    }

    private void convertWLQLToEJBQL(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
        BaseWeblogicRdbmsBeanBean baseWeblogicRdbmsBeanBean = compositeMBeanDescriptor.getRDBMSBean();
        if (!(baseWeblogicRdbmsBeanBean instanceof WeblogicRdbmsBeanBean)) {
            return;
        }
        WeblogicRdbmsBeanBean weblogicRdbmsBeanBean = (WeblogicRdbmsBeanBean)baseWeblogicRdbmsBeanBean;
        FinderBean[] finderBeanArray = weblogicRdbmsBeanBean.getFinders();
        for (int i = 0; i < finderBeanArray.length; ++i) {
            FinderBean finderBean = finderBeanArray[i];
            QueryBean queryBean = entityBeanBean.createQuery();
            QueryMethodBean queryMethodBean = queryBean.createQueryMethod();
            MethodParamsBean methodParamsBean = queryMethodBean.createMethodParams();
            queryMethodBean.setMethodName(finderBean.getFinderName());
            for (int j = 0; j < finderBean.getFinderParams().length; ++j) {
                methodParamsBean.addMethodParam(finderBean.getFinderParams()[j]);
            }
            String string = finderBean.getFinderQuery();
            try {
                String string2 = WLQLtoEJBQL.doWLQLtoEJBQL(string, entityBeanBean.getAbstractSchemaName());
                Debug.say((String)("@@@ EJB-QL:" + string2));
                queryBean.setEjbQl(string2);
                continue;
            }
            catch (RDBMSException rDBMSException) {
                EJBLogger.logStackTrace((Throwable)rDBMSException);
            }
        }
    }

    private void convertRDBMSDescriptorsTo2x(EjbDescriptorBean ejbDescriptorBean) {
        WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray = ejbDescriptorBean.getWeblogicRdbms11JarBeans();
        for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
            weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean = ejbDescriptorBean.createWeblogicRdbmsJarBean();
            WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBeanArray[i].getWeblogicRdbmsBeans();
            for (int j = 0; j < weblogicRdbmsBeanBeanArray.length; ++j) {
                WeblogicRdbmsBeanBean weblogicRdbmsBeanBean = weblogicRdbmsBeanBeanArray[j];
                weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean weblogicRdbmsBeanBean2 = weblogicRdbmsJarBean.createWeblogicRdbmsBean();
                weblogicRdbmsBeanBean2.setEjbName(weblogicRdbmsBeanBean.getEjbName());
                weblogicRdbmsBeanBean2.setDataSourceJndiName(weblogicRdbmsBeanBean.getPoolName());
                TableMapBean tableMapBean = weblogicRdbmsBeanBean2.createTableMap();
                tableMapBean.setTableName(weblogicRdbmsBeanBean.getTableName());
                weblogic.j2ee.descriptor.wl60.FieldMapBean[] fieldMapBeanArray = weblogicRdbmsBeanBean.getFieldMaps();
                for (int k = 0; k < fieldMapBeanArray.length; ++k) {
                    FieldMapBean fieldMapBean = tableMapBean.createFieldMap();
                    fieldMapBean.setCmpField(fieldMapBeanArray[k].getCmpField());
                    fieldMapBean.setDbmsColumn(fieldMapBeanArray[k].getDbmsColumn());
                }
            }
            ejbDescriptorBean.addWeblogicRdbmsJarBean(weblogicRdbmsJarBean);
            ejbDescriptorBean.removeWeblogicRdbms11JarBean(weblogicRdbmsJarBeanArray[i]);
        }
    }
}

