/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.utils.ddconverter.ConvertLog;
import weblogic.ejb.container.utils.ddconverter.DDConverterException;
import weblogic.ejb.container.utils.ddconverter.EJBddcTextFormatter;
import weblogic.ejb.container.utils.ddconverter.WorkingJar;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;

public abstract class DDConverterBase {
    private static final boolean debug = true;
    protected static String DDCONVERTER_WORKING_DIR;
    protected String[] sources;
    protected boolean combineBeans = false;
    protected String targetDirName = ".";
    protected ConvertLog log;
    protected EJBddcTextFormatter fmt;
    private boolean isCMP20beanFlag = true;
    protected boolean convertTo20 = true;

    public DDConverterBase() {
    }

    public DDConverterBase(String[] stringArray, String string, ConvertLog convertLog, boolean bl) throws DDConverterException {
        this.isCMP20beanFlag = bl;
        this.sources = stringArray;
        if (string != null) {
            this.targetDirName = string;
        }
        this.log = convertLog;
        this.fmt = new EJBddcTextFormatter();
    }

    public boolean isCMP20() {
        return this.isCMP20beanFlag;
    }

    public abstract boolean convert(String var1) throws DDConverterException, IOException;

    public abstract boolean convert() throws DDConverterException, IOException;

    protected void normalizeDescriptor(EjbDescriptorBean ejbDescriptorBean) throws DDConverterException {
        EnterpriseBeanBean[] enterpriseBeanBeanArray = CompositeMBeanDescriptor.getEnterpriseBeans(ejbDescriptorBean.getEjbJarBean());
        for (int i = 0; i < enterpriseBeanBeanArray.length; ++i) {
            CompositeMBeanDescriptor compositeMBeanDescriptor = null;
            try {
                compositeMBeanDescriptor = new CompositeMBeanDescriptor(enterpriseBeanBeanArray[i], ejbDescriptorBean);
            }
            catch (WLDeploymentException wLDeploymentException) {
                throw new DDConverterException(wLDeploymentException);
            }
            WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = compositeMBeanDescriptor.getWlBean();
            if (compositeMBeanDescriptor.isEntity()) {
                PersistenceBean persistenceBean;
                EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
                if (!"bean".equalsIgnoreCase(entityBeanBean.getPersistenceType())) continue;
                PersistenceBean persistenceBean2 = weblogicEnterpriseBeanBean.getEntityDescriptor().getPersistence();
                if (null == weblogicEnterpriseBeanBean.getEntityDescriptor() || (persistenceBean = weblogicEnterpriseBeanBean.getEntityDescriptor().getPersistence()) == null) continue;
                String string = persistenceBean.getIsModifiedMethodName();
                boolean bl = persistenceBean.isDelayUpdatesUntilEndOfTx();
                weblogicEnterpriseBeanBean.getEntityDescriptor().destroyPersistence(persistenceBean);
                PersistenceBean persistenceBean3 = weblogicEnterpriseBeanBean.getEntityDescriptor().createPersistence();
                if (string != null) {
                    persistenceBean3.setIsModifiedMethodName(string);
                }
                persistenceBean3.setDelayUpdatesUntilEndOfTx(bl);
                continue;
            }
            if (!compositeMBeanDescriptor.isStatefulSession() && !compositeMBeanDescriptor.isStatelessSession()) continue;
        }
    }

    protected WeblogicRdbmsJarBean getWeblogicRdbms11JarBean(EjbDescriptorBean ejbDescriptorBean) {
        WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray = ejbDescriptorBean.getWeblogicRdbms11JarBeans();
        WeblogicRdbmsJarBean weblogicRdbmsJarBean = null == weblogicRdbmsJarBeanArray || weblogicRdbmsJarBeanArray.length == 0 ? ejbDescriptorBean.createWeblogicRdbms11JarBean() : weblogicRdbmsJarBeanArray[0];
        return weblogicRdbmsJarBean;
    }

    protected void writeEJBDDsToJar(EjbDescriptorBean ejbDescriptorBean, WorkingJar workingJar) throws DDConverterException, IOException {
        String string = this.targetDirName + File.separatorChar + workingJar.getFile().getName();
        this.normalizeDescriptor(ejbDescriptorBean);
        ejbDescriptorBean.usePersistenceDestination(string);
        ejbDescriptorBean.persist();
    }

    public static String makeAbstractSchemaName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",./");
        return stringTokenizer.nextToken();
    }
}

