/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLtoEJBQL;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.utils.ddconverter.ConvertLog;
import weblogic.ejb.container.utils.ddconverter.DDConverterBase;
import weblogic.ejb.container.utils.ddconverter.DDConverterCollectionException;
import weblogic.ejb.container.utils.ddconverter.DDConverterException;
import weblogic.ejb.container.utils.ddconverter.EJB10DescriptorConstants;
import weblogic.ejb.container.utils.ddconverter.EJB10DescriptorStructure;
import weblogic.ejb.container.utils.ddconverter.EJB10MethodDescriptorStructure;
import weblogic.ejb.container.utils.ddconverter.EJBddcTextFormatter;
import weblogic.ejb.container.utils.ddconverter.FinderParser;
import weblogic.ejb.container.utils.ddconverter.Structure;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.CmpFieldBean;
import weblogic.j2ee.descriptor.ContainerTransactionBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.MethodPermissionBean;
import weblogic.j2ee.descriptor.QueryBean;
import weblogic.j2ee.descriptor.QueryMethodBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.EntityDescriptorBean;
import weblogic.j2ee.descriptor.wl.IdempotentMethodsBean;
import weblogic.j2ee.descriptor.wl.MethodBean;
import weblogic.j2ee.descriptor.wl.MethodParamsBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.SecurityRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.TableMapBean;
import weblogic.j2ee.descriptor.wl.TransactionIsolationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl60.BaseWeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.FinderBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.utils.Debug;

public final class DDConverter_10 {
    protected static boolean verbose = false;
    protected static boolean debug = false;
    private String oldDDFile = null;
    protected EjbDescriptorBean desc = null;
    private String ejbName = null;
    protected EJB10DescriptorStructure oldDDStruct = null;
    private Hashtable oldEnvProps = new Hashtable();
    private Hashtable oldControlDescriptors = new Hashtable();
    private Hashtable oldPStoreProps = new Hashtable();
    private Hashtable oldAccessControlEntries = new Hashtable();
    protected Hashtable oldMethodDescriptors = new Hashtable();
    private String beanType = new String();
    protected EJBddcTextFormatter fmt;
    protected ConvertLog log;
    Collection m_rdbmsBeans = new ArrayList();
    boolean isCMP20beanFlag = true;
    private StreamTokenizer st = null;
    private int nestingLevel = 0;
    private boolean eofOK = false;
    private String currFile = null;

    public DDConverter_10(ConvertLog convertLog, boolean bl) {
        this.log = convertLog;
        this.isCMP20beanFlag = bl;
        this.fmt = new EJBddcTextFormatter();
    }

    public EjbDescriptorBean invokeDDC10(EjbDescriptorBean ejbDescriptorBean, String string) {
        this.desc = ejbDescriptorBean;
        try {
            this.parseOldDD(string);
            this.createNewDD();
        }
        catch (DDConverterCollectionException dDConverterCollectionException) {
            this.log.logInfo(this.fmt.errorMessage());
            System.exit(1);
        }
        return ejbDescriptorBean;
    }

    public void parseOldDD(String string) throws DDConverterCollectionException {
        this.oldDDFile = string;
        if (verbose) {
            System.out.println("----- parseOldDD -----");
        }
        try {
            this.oldDDStruct = new EJB10DescriptorStructure(this.parseFile(string));
            this.oldEnvProps = this.oldDDStruct.getEnvironmentProperties();
            this.oldControlDescriptors = this.oldDDStruct.getControlDescriptors();
            this.oldPStoreProps = this.oldDDStruct.getPersistentStoreProperties();
            this.oldAccessControlEntries = this.oldDDStruct.getAccessControlEntries();
            this.oldMethodDescriptors = this.getAllMethods(this.oldAccessControlEntries, this.oldControlDescriptors);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.logError(this.fmt.fileNotFound(string));
            throw new DDConverterCollectionException((Exception)((Object)new DDConverterException(fileNotFoundException)));
        }
        catch (Exception exception) {
            EJBLogger.logStackTrace((Throwable)exception);
        }
    }

    public void createNewDD() throws DDConverterCollectionException {
        if (verbose) {
            System.out.println("----- createNewDD -----");
        }
        if (this.oldDDStruct.name.equalsIgnoreCase("EntityDescriptor")) {
            this.beanType = "EntityDescriptor";
            EntityBeanBean entityBeanBean = this.desc.getEjbJarBean().getEnterpriseBeans().createEntity();
            entityBeanBean.setEjbName(this.oldDDStruct.getBeanHomeName());
            WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = this.desc.getWeblogicEjbJarBean().createWeblogicEnterpriseBean();
            weblogicEnterpriseBeanBean.setEjbName(this.oldDDStruct.getBeanHomeName());
            CompositeMBeanDescriptor compositeMBeanDescriptor = null;
            try {
                compositeMBeanDescriptor = new CompositeMBeanDescriptor((EnterpriseBeanBean)entityBeanBean, weblogicEnterpriseBeanBean, this.desc);
            }
            catch (WLDeploymentException wLDeploymentException) {
                throw new DDConverterCollectionException((Exception)((Object)new DDConverterException(wLDeploymentException)));
            }
            this.doCommon(compositeMBeanDescriptor);
            this.doEntityProperties(compositeMBeanDescriptor);
        } else if (this.oldDDStruct.name.equalsIgnoreCase("SessionDescriptor")) {
            this.beanType = "SessionDescriptor";
            SessionBeanBean sessionBeanBean = this.desc.getEjbJarBean().getEnterpriseBeans().createSession();
            if ("STATELESS_SESSION".equalsIgnoreCase(this.oldDDStruct.getStateManagementType())) {
                sessionBeanBean.setSessionType("Stateless");
            } else {
                sessionBeanBean.setSessionType("Stateful");
            }
            WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = this.desc.getWeblogicEjbJarBean().createWeblogicEnterpriseBean();
            sessionBeanBean.setEjbName(this.oldDDStruct.getBeanHomeName());
            weblogicEnterpriseBeanBean.setEjbName(this.oldDDStruct.getBeanHomeName());
            CompositeMBeanDescriptor compositeMBeanDescriptor = null;
            try {
                compositeMBeanDescriptor = new CompositeMBeanDescriptor((EnterpriseBeanBean)sessionBeanBean, weblogicEnterpriseBeanBean, this.desc);
            }
            catch (WLDeploymentException wLDeploymentException) {
                EJBLogger.logStackTrace((Throwable)wLDeploymentException);
                throw new DDConverterCollectionException((Exception)((Object)new DDConverterException(wLDeploymentException)));
            }
            this.doCommon(compositeMBeanDescriptor);
            this.doSessionProperties(compositeMBeanDescriptor);
        } else {
            this.log.logWarning(this.fmt.invalidDDFile());
        }
    }

    private void doCommon(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        String string;
        EnterpriseBeanBean enterpriseBeanBean = compositeMBeanDescriptor.getBean();
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = compositeMBeanDescriptor.getWlBean();
        if (verbose) {
            System.out.println("----- doCommon -----");
        }
        this.ejbName = string = this.oldDDStruct.getBeanHomeName();
        compositeMBeanDescriptor.setEJBName(string);
        this.log.logWarning(this.fmt.ejbNameSetToJndi(string));
        compositeMBeanDescriptor.setJNDIName(string);
        enterpriseBeanBean.setEjbClass(this.oldDDStruct.getEnterpriseBeanClassName());
        if (enterpriseBeanBean instanceof EntityBeanBean) {
            ((EntityBeanBean)enterpriseBeanBean).setHome(this.oldDDStruct.getHomeInterfaceClassName());
            ((EntityBeanBean)enterpriseBeanBean).setRemote(this.oldDDStruct.getRemoteInterfaceClassName());
        } else {
            ((SessionBeanBean)enterpriseBeanBean).setHome(this.oldDDStruct.getHomeInterfaceClassName());
            ((SessionBeanBean)enterpriseBeanBean).setRemote(this.oldDDStruct.getRemoteInterfaceClassName());
        }
        this.doCacheProperties(compositeMBeanDescriptor);
        this.doCommonClusterProperties(compositeMBeanDescriptor);
        this.doMethodDescriptors(compositeMBeanDescriptor);
        this.doRoleDescriptors(compositeMBeanDescriptor);
        this.doUserDefinedEnvironmentProperties(compositeMBeanDescriptor);
        if (this.oldDDStruct.getEjbObjectClassName() != null) {
            this.log.logWarning(this.fmt.noCustomEJBObjectClass());
        }
        if (this.oldDDStruct.getHomeClassName() != null) {
            this.log.logWarning(this.fmt.noCustomEJBHomeClass());
        }
    }

    private void doUserDefinedEnvironmentProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (verbose) {
            System.out.println("----- doUserDefinedEnvironmentProperties -----");
        }
        Hashtable hashtable = new Hashtable();
        this.getUserDefinedProps(this.oldEnvProps, hashtable);
        if (!hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                EnvEntryBean envEntryBean = compositeMBeanDescriptor.createEnvironmentEntry();
                envEntryBean.setEnvEntryName(string);
                envEntryBean.setEnvEntryType("java.lang.String");
                envEntryBean.setEnvEntryValue((String)hashtable.get(string));
                this.log.logWarning(this.fmt.userPropsReadInAsString(string));
            }
        }
    }

    private void getUserDefinedProps(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = EJB10DescriptorConstants.getConstantsAsHashtable();
        Enumeration enumeration = hashtable.keys();
        String string = null;
        Object var6_6 = null;
        String string2 = null;
        Hashtable hashtable4 = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            var6_6 = hashtable.get(string);
            if (var6_6 instanceof String) {
                string2 = var6_6;
                if (hashtable3.contains(string)) continue;
                hashtable2.put(string, string2);
                continue;
            }
            if (!(var6_6 instanceof Hashtable)) continue;
            hashtable4 = var6_6;
            if (hashtable3.contains(string)) continue;
            this.getUserDefinedProps(hashtable4, hashtable2);
        }
    }

    private void doCacheProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (verbose) {
            System.out.println("----- doCacheProperties -----");
        }
        if (this.oldDDStruct.getMaxBeansInFreePool() != null) {
            compositeMBeanDescriptor.setMaxBeansInFreePool(new Integer(this.oldDDStruct.getMaxBeansInFreePool()));
        }
        if (this.oldDDStruct.getMaxBeansInCache() != null) {
            compositeMBeanDescriptor.setMaxBeansInCache(new Integer(this.oldDDStruct.getMaxBeansInCache()));
        }
        if (this.oldDDStruct.getIdleTimeoutSeconds() != null) {
            compositeMBeanDescriptor.setIdleTimeoutSecondsCache(new Integer(this.oldDDStruct.getIdleTimeoutSeconds()));
        }
    }

    private void doCommonClusterProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        String string;
        if (verbose) {
            System.out.println("----- doCommonClusterProperties -----");
        }
        if ((string = this.oldDDStruct.getHomeIsClusterable()) != null) {
            compositeMBeanDescriptor.setHomeIsClusterable(new Boolean(string));
        }
    }

    private void doSessionClusterProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (verbose) {
            System.out.println("----- doSessionClusterProperties -----");
        }
        if (compositeMBeanDescriptor.isStatelessSession()) {
            compositeMBeanDescriptor.setStatelessBeanIsClusterable(new Boolean(this.oldDDStruct.getStatelessBeanIsClusterable()));
            if (this.oldDDStruct.getStatelessBeanLoadAlgorithm() != null) {
                compositeMBeanDescriptor.setStatelessBeanLoadAlgorithm(this.oldDDStruct.getStatelessBeanLoadAlgorithm());
            }
            if (this.oldDDStruct.getStatelessBeanCallRouterClassName() != null) {
                compositeMBeanDescriptor.setStatelessBeanCallRouterClassName(this.oldDDStruct.getStatelessBeanCallRouterClassName());
            }
            if (new Boolean(this.oldDDStruct.getStatelessBeanMethodsAreIdempotent()).booleanValue()) {
                EjbDescriptorBean ejbDescriptorBean = compositeMBeanDescriptor.getEJBDescriptor();
                WeblogicEjbJarBean weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
                IdempotentMethodsBean idempotentMethodsBean = weblogicEjbJarBean.getIdempotentMethods();
                if (idempotentMethodsBean == null) {
                    idempotentMethodsBean = weblogicEjbJarBean.createIdempotentMethods();
                }
                MethodBean methodBean = idempotentMethodsBean.createMethod();
                methodBean.setEjbName(compositeMBeanDescriptor.getEJBName());
                methodBean.setMethodName("*");
            }
        } else {
            if (this.oldDDStruct.getHomeLoadAlgorithm() != null) {
                compositeMBeanDescriptor.setHomeLoadAlgorithm(this.oldDDStruct.getHomeLoadAlgorithm());
            }
            if (this.oldDDStruct.getHomeCallRouterClass() != null) {
                compositeMBeanDescriptor.setHomeCallRouterClassName(this.oldDDStruct.getHomeCallRouterClass());
            }
        }
    }

    private boolean beanHasBeanManagedMethod() {
        Enumeration enumeration = this.oldMethodDescriptors.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EJB10MethodDescriptorStructure eJB10MethodDescriptorStructure = (EJB10MethodDescriptorStructure)this.oldMethodDescriptors.get(string);
            String string2 = eJB10MethodDescriptorStructure.getTransactionAttribute();
            if (string2 == null || !string2.equals("TX_BEAN_MANAGED")) continue;
            return true;
        }
        return false;
    }

    private void doMethodDescriptors(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        Object object;
        EjbJarBean ejbJarBean;
        if (verbose) {
            System.out.println("----- doMethodDescriptors -----");
        }
        if (debug) {
            ejbJarBean = this.oldMethodDescriptors.keys();
            while (ejbJarBean.hasMoreElements()) {
                object = (String)ejbJarBean.nextElement();
                System.out.println(this.oldMethodDescriptors.get(object));
            }
        }
        if ((object = (ejbJarBean = compositeMBeanDescriptor.getEJBDescriptor().getEjbJarBean()).getAssemblyDescriptor()) == null) {
            object = ejbJarBean.createAssemblyDescriptor();
        }
        if (this.setContainerManagedTransactions(compositeMBeanDescriptor)) {
            this.setTransactionAttributes((AssemblyDescriptorBean)object);
        }
        this.setMethodPermissions((AssemblyDescriptorBean)object);
        this.setIsolationLevels(compositeMBeanDescriptor.getEJBDescriptor().getWeblogicEjbJarBean());
    }

    private void setTransactionAttributes(AssemblyDescriptorBean assemblyDescriptorBean) {
        Set set = this.oldMethodDescriptors.keySet();
        for (String string : set) {
            EJB10MethodDescriptorStructure eJB10MethodDescriptorStructure = (EJB10MethodDescriptorStructure)this.oldMethodDescriptors.get(string);
            String string2 = eJB10MethodDescriptorStructure.getTransactionAttribute();
            if (string2 == null) continue;
            ContainerTransactionBean containerTransactionBean = assemblyDescriptorBean.createContainerTransaction();
            weblogic.j2ee.descriptor.MethodBean methodBean = containerTransactionBean.createMethod();
            methodBean.setEjbName(this.ejbName);
            String string3 = eJB10MethodDescriptorStructure.getMethodName();
            if (string3.equalsIgnoreCase("DEFAULT")) {
                methodBean.setMethodName("*");
            } else {
                methodBean.setMethodName(string3);
            }
            Vector vector = eJB10MethodDescriptorStructure.getMethodParams();
            if (vector != null && vector.size() > 0) {
                weblogic.j2ee.descriptor.MethodParamsBean methodParamsBean = methodBean.createMethodParams();
                for (int i = 0; i < vector.size(); ++i) {
                    methodParamsBean.addMethodParam((String)vector.elementAt(i));
                    if (!debug) continue;
                    System.out.println("**** " + vector.elementAt(i));
                }
            }
            containerTransactionBean.setTransAttribute(this.mapTxAttribute(string2, eJB10MethodDescriptorStructure.getMethodSig()));
        }
    }

    private void setMethodPermissions(AssemblyDescriptorBean assemblyDescriptorBean) {
        Set set = this.oldMethodDescriptors.keySet();
        for (String string : set) {
            EJB10MethodDescriptorStructure eJB10MethodDescriptorStructure = (EJB10MethodDescriptorStructure)this.oldMethodDescriptors.get(string);
            Vector vector = eJB10MethodDescriptorStructure.getAccessControlEntries();
            if (vector != null) {
                MethodPermissionBean methodPermissionBean = assemblyDescriptorBean.createMethodPermission();
                weblogic.j2ee.descriptor.MethodBean methodBean = methodPermissionBean.createMethod();
                methodBean.setEjbName(this.ejbName);
                String string2 = eJB10MethodDescriptorStructure.getMethodName();
                if (string2.equalsIgnoreCase("DEFAULT")) {
                    methodBean.setMethodName("*");
                } else {
                    methodBean.setMethodName(string2);
                }
                Vector vector2 = eJB10MethodDescriptorStructure.getMethodParams();
                if (vector2 != null && vector2.size() > 0) {
                    weblogic.j2ee.descriptor.MethodParamsBean methodParamsBean = methodBean.createMethodParams();
                    for (int i = 0; i < vector2.size(); ++i) {
                        methodParamsBean.addMethodParam((String)vector2.elementAt(i));
                        if (!debug) continue;
                        System.out.println("**** " + vector2.elementAt(i));
                    }
                }
                for (int i = 0; i < vector.size(); ++i) {
                    String string3 = (String)vector.elementAt(i);
                    methodPermissionBean.addRoleName(string3);
                }
            }
            if (eJB10MethodDescriptorStructure.getRunAsMode() != null) {
                if (this.isCMP20beanFlag) {
                    this.log.logWarning(this.fmt.noRunAsMode20(eJB10MethodDescriptorStructure.getMethodSig()));
                } else {
                    this.log.logWarning(this.fmt.noRunAsMode11(eJB10MethodDescriptorStructure.getMethodSig()));
                }
            }
            if (eJB10MethodDescriptorStructure.getRunAsIdentity() == null) continue;
            if (this.isCMP20beanFlag) {
                this.log.logWarning(this.fmt.noRunAsIdentity20(eJB10MethodDescriptorStructure.getMethodSig()));
                continue;
            }
            this.log.logWarning(this.fmt.noRunAsIdentity11(eJB10MethodDescriptorStructure.getMethodSig()));
        }
    }

    private void setIsolationLevels(WeblogicEjbJarBean weblogicEjbJarBean) {
        Set set = this.oldMethodDescriptors.keySet();
        for (String string : set) {
            EJB10MethodDescriptorStructure eJB10MethodDescriptorStructure = (EJB10MethodDescriptorStructure)this.oldMethodDescriptors.get(string);
            String string2 = eJB10MethodDescriptorStructure.getIsolationLevel();
            if (string2 == null) continue;
            TransactionIsolationBean transactionIsolationBean = weblogicEjbJarBean.createTransactionIsolation();
            MethodBean methodBean = transactionIsolationBean.createMethod();
            methodBean.setEjbName(this.ejbName);
            String string3 = eJB10MethodDescriptorStructure.getMethodName();
            if (string3.equalsIgnoreCase("DEFAULT")) {
                methodBean.setMethodName("*");
            } else {
                methodBean.setMethodName(string3);
            }
            Vector vector = eJB10MethodDescriptorStructure.getMethodParams();
            if (vector != null && vector.size() > 0) {
                MethodParamsBean methodParamsBean = methodBean.createMethodParams();
                for (int i = 0; i < vector.size(); ++i) {
                    methodParamsBean.addMethodParam((String)vector.elementAt(i));
                    if (!debug) continue;
                    System.out.println("**** " + vector.elementAt(i));
                }
            }
            if ("TRANSACTION_SERIALIZABLE".equalsIgnoreCase(string2)) {
                string2 = "TransactionSerializable";
            } else if ("TRANSACTION_READ_COMMITTED".equalsIgnoreCase(string2)) {
                string2 = "TransactionReadCommitted";
            } else if ("TRANSACTION_READ_COMMITTED_FOR_UPDATE".equalsIgnoreCase(string2)) {
                string2 = "TransactionReadCommittedForUpdate";
            } else if ("TRANSACTION_READ_UNCOMMITTED".equalsIgnoreCase(string2)) {
                string2 = "TransactionReadUncommitted";
            } else if ("TRANSACTION_REPEATABLE_READ".equalsIgnoreCase(string2)) {
                string2 = "TransactionRepeatableRead";
            }
            transactionIsolationBean.setIsolationLevel(string2);
        }
    }

    private String mapTxAttribute(String string, String string2) {
        if (verbose) {
            System.out.println("----- mapTxAttribute -----");
        }
        String string3 = null;
        if (string != null) {
            if (string.equalsIgnoreCase("TX_NOT_SUPPORTED")) {
                string3 = "NotSupported";
            } else if (string.equalsIgnoreCase("TX_REQUIRED")) {
                string3 = "Required";
            } else if (string.equalsIgnoreCase("TX_SUPPORTS")) {
                string3 = "Supports";
            } else if (string.equalsIgnoreCase("TX_REQUIRES_NEW")) {
                string3 = "RequiresNew";
            } else if (string.equalsIgnoreCase("TX_MANDATORY")) {
                string3 = "Mandatory";
            } else if (string.equalsIgnoreCase("TX_BEAN_MANAGED")) {
                if (this.beanType.equalsIgnoreCase("EntityDescriptor")) {
                    string3 = "Required";
                    this.log.logWarning(this.fmt.noBeanManagedForEntityBeans(string3, string2));
                } else {
                    string3 = "BeanManaged";
                }
            } else {
                string3 = "NotSet";
                this.log.logWarning(this.fmt.unexpectedErrorTxNotSet(string, string2));
            }
        }
        return string3;
    }

    private boolean setContainerManagedTransactions(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        boolean bl;
        if (this.beanType.equals("EntityDescriptor")) {
            if (verbose) {
                System.out.println("bean is an entity bean with container managed transactions");
            }
            bl = true;
        } else if (this.beanHasBeanManagedMethod()) {
            bl = false;
            if (verbose) {
                System.out.println("bean is a session bean with bean managed transactions");
            }
            ((SessionBeanBean)compositeMBeanDescriptor.getBean()).setTransactionType("Bean");
        } else {
            bl = true;
            if (verbose) {
                System.out.println("bean is a session bean with container managed transactions");
            }
            ((SessionBeanBean)compositeMBeanDescriptor.getBean()).setTransactionType("Container");
        }
        return bl;
    }

    private void doRoleDescriptors(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        Object object;
        EJB10MethodDescriptorStructure eJB10MethodDescriptorStructure = null;
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.oldMethodDescriptors.keys();
        while (enumeration.hasMoreElements()) {
            eJB10MethodDescriptorStructure = (EJB10MethodDescriptorStructure)this.oldMethodDescriptors.get(enumeration.nextElement());
            object = eJB10MethodDescriptorStructure.getAccessControlEntries();
            if (object == null) continue;
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                hashSet.add(((Vector)object).elementAt(i));
            }
        }
        object = compositeMBeanDescriptor.getEJBDescriptor().getEjbJarBean().getAssemblyDescriptor();
        WeblogicEjbJarBean weblogicEjbJarBean = compositeMBeanDescriptor.getEJBDescriptor().getWeblogicEjbJarBean();
        if (!hashSet.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                this.log.logWarning(this.fmt.securityPrincipalArbitrarilySet(string, string2));
                SecurityRoleBean securityRoleBean = object.createSecurityRole();
                securityRoleBean.setRoleName(string);
                SecurityRoleAssignmentBean securityRoleAssignmentBean = weblogicEjbJarBean.createSecurityRoleAssignment();
                securityRoleAssignmentBean.setRoleName(string);
                securityRoleAssignmentBean.addPrincipalName(string2);
            }
        }
    }

    private Hashtable getAllMethods(Hashtable hashtable, Hashtable hashtable2) {
        Cloneable cloneable;
        String string;
        int n;
        if (verbose) {
            System.out.println("----- getAllMethods -----");
        }
        Hashtable<String, EJB10MethodDescriptorStructure> hashtable3 = new Hashtable<String, EJB10MethodDescriptorStructure>();
        Enumeration enumeration = null;
        EJB10MethodDescriptorStructure eJB10MethodDescriptorStructure = null;
        if (hashtable != null) {
            enumeration = hashtable.keys();
            for (n = 0; n < hashtable.size(); ++n) {
                string = (String)enumeration.nextElement();
                cloneable = this.oldDDStruct.getAccessControlEntry(string);
                eJB10MethodDescriptorStructure = new EJB10MethodDescriptorStructure(string, (Vector)cloneable, null);
                if (!hashtable3.containsKey(string)) {
                    hashtable3.put(string, eJB10MethodDescriptorStructure);
                    continue;
                }
                eJB10MethodDescriptorStructure = (EJB10MethodDescriptorStructure)hashtable3.remove(string);
                eJB10MethodDescriptorStructure.setAccessControlEntries((Vector)cloneable);
                hashtable3.put(string, eJB10MethodDescriptorStructure);
            }
        }
        if (hashtable2 != null) {
            enumeration = hashtable2.keys();
            for (n = 0; n < hashtable2.size(); ++n) {
                string = (String)enumeration.nextElement();
                cloneable = (Hashtable)hashtable2.get(string);
                eJB10MethodDescriptorStructure = new EJB10MethodDescriptorStructure(string, null, (Hashtable)cloneable);
                if (!hashtable3.containsKey(string)) {
                    hashtable3.put(string, eJB10MethodDescriptorStructure);
                    continue;
                }
                eJB10MethodDescriptorStructure = (EJB10MethodDescriptorStructure)hashtable3.remove(string);
                eJB10MethodDescriptorStructure.setControlDescriptors((Hashtable)cloneable);
                hashtable3.put(string, eJB10MethodDescriptorStructure);
            }
        }
        if (debug) {
            System.out.println("-----------------------------------------------");
            System.out.println("COMBINED: ");
            Enumeration enumeration2 = hashtable3.keys();
            while (enumeration2.hasMoreElements()) {
                System.out.println(hashtable3.get(enumeration2.nextElement()));
            }
        }
        return hashtable3;
    }

    private void doSessionProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (verbose) {
            System.out.println("----- doSessionProperties -----");
        }
        this.doSessionClusterProperties(compositeMBeanDescriptor);
        if (this.oldDDStruct.getStateManagementType().equalsIgnoreCase("STATEFUL_SESSION")) {
            this.doSFSessionProperties(compositeMBeanDescriptor);
        } else if (this.oldDDStruct.getStateManagementType().equalsIgnoreCase("STATELESS_SESSION")) {
            this.doSLSessionProperties(compositeMBeanDescriptor);
        }
    }

    private void doSFSessionProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (verbose) {
            System.out.println("----- doSFSessionProperties -----");
        }
        SessionBeanBean sessionBeanBean = (SessionBeanBean)compositeMBeanDescriptor.getBean();
        sessionBeanBean.setSessionType("Stateful");
        Hashtable hashtable = this.oldDDStruct.getPersistentStoreProperties();
        String string = this.oldDDStruct.getSessionPersistentDirectoryRoot();
        if (string != null) {
            compositeMBeanDescriptor.getWlBean().getStatefulSessionDescriptor().setPersistentStoreDir(string);
        }
        try {
            int n = new Integer(this.oldDDStruct.getSessionTimeout());
            compositeMBeanDescriptor.getWlBean().getTransactionDescriptor().setTransTimeoutSeconds(n);
        }
        catch (NumberFormatException numberFormatException) {
            EJBLogger.logStackTrace((Throwable)numberFormatException);
        }
    }

    private void doSLSessionProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (verbose) {
            System.out.println("----- doSLSessionProperties -----");
        }
        try {
            int n = new Integer(this.oldDDStruct.getSessionTimeout());
            compositeMBeanDescriptor.getWlBean().getTransactionDescriptor().setTransTimeoutSeconds(n);
        }
        catch (NumberFormatException numberFormatException) {
            EJBLogger.logStackTrace((Throwable)numberFormatException);
        }
        SessionBeanBean sessionBeanBean = (SessionBeanBean)compositeMBeanDescriptor.getBean();
        sessionBeanBean.setSessionType("Stateless");
    }

    private void doEntityProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) throws DDConverterCollectionException {
        if (verbose) {
            System.out.println("----- doEntityProperties -----");
        }
        EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = compositeMBeanDescriptor.getWlBean();
        EntityDescriptorBean entityDescriptorBean = weblogicEnterpriseBeanBean.getEntityDescriptor();
        entityBeanBean.setPrimKeyClass(this.oldDDStruct.getPrimaryKeyClassName());
        entityDescriptorBean.getEntityCache().setCacheBetweenTransactions(new Boolean(this.oldDDStruct.getJdbcDbIsShared()) == false);
        entityBeanBean.setReentrant(new Boolean(this.oldDDStruct.getIsReentrant()).booleanValue());
        entityDescriptorBean.getPersistence().setDelayUpdatesUntilEndOfTx(this.oldDDStruct.getDelayUpdatesUntilEndOfTx().booleanValue());
        Vector vector = this.oldDDStruct.getContainerManagedFields();
        if (vector == null) {
            entityBeanBean.setPersistenceType("Bean");
            this.doBMPEntityProperties(compositeMBeanDescriptor);
        } else {
            if (this.isCMP20beanFlag) {
                entityBeanBean.setAbstractSchemaName(DDConverterBase.makeAbstractSchemaName(entityBeanBean.getEjbName()));
                Debug.say((String)("@@@ SETTING ABSTRACT:" + entityBeanBean.getAbstractSchemaName()));
            }
            entityBeanBean.setPersistenceType("Container");
            weblogicEnterpriseBeanBean.getEntityDescriptor().getEntityCache().setConcurrencyStrategy("Exclusive");
            weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean weblogicRdbmsBeanBean = null;
            if (this.isCMP20beanFlag) {
                weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray = this.desc.getWeblogicRdbmsJarBeans();
                if (weblogicRdbmsJarBeanArray.length == 0) {
                    this.desc.createWeblogicRdbmsJarBean();
                }
                weblogicRdbmsBeanBean = this.desc.getWeblogicRdbmsJarBeans()[0].createWeblogicRdbmsBean();
            } else {
                WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray = this.desc.getWeblogicRdbms11JarBeans();
                if (weblogicRdbmsJarBeanArray.length == 0) {
                    this.desc.createWeblogicRdbms11JarBean();
                }
                weblogicRdbmsBeanBean = this.desc.getWeblogicRdbms11JarBeans()[0].createWeblogicRdbmsBean();
            }
            compositeMBeanDescriptor.setRDBMSBean((BaseWeblogicRdbmsBeanBean)weblogicRdbmsBeanBean);
            this.doCMPEntityProperties(compositeMBeanDescriptor, (BaseWeblogicRdbmsBeanBean)weblogicRdbmsBeanBean);
        }
    }

    private void doBMPEntityProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        EntityDescriptorBean entityDescriptorBean = compositeMBeanDescriptor.getWlBean().getEntityDescriptor();
        if (this.oldDDStruct.getIsModifiedMethodName() != null) {
            entityDescriptorBean.getPersistence().setIsModifiedMethodName(this.oldDDStruct.getIsModifiedMethodName());
        }
    }

    private void doCMPEntityProperties(CompositeMBeanDescriptor compositeMBeanDescriptor, BaseWeblogicRdbmsBeanBean baseWeblogicRdbmsBeanBean) throws DDConverterCollectionException {
        if (verbose) {
            System.out.println("----- doCMPEntityProperties -----");
        }
        Hashtable hashtable = this.oldDDStruct.getJdbc();
        String string = this.oldDDStruct.getPersistentStoreType();
        Vector vector = this.oldDDStruct.getContainerManagedFields();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object object2;
            String string2 = (String)vector.elementAt(i);
            if (string2.equals("*")) {
                this.log.logWarning(this.fmt.starNotSupportedForCmpFields());
                object2 = this.oldDDStruct.getJdbcAttributeMap();
                object = ((Hashtable)object2).keys();
                while (object.hasMoreElements()) {
                    String string3 = (String)object.nextElement();
                    EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
                    CmpFieldBean cmpFieldBean = entityBeanBean.createCmpField();
                    cmpFieldBean.setFieldName(string3);
                }
                continue;
            }
            object2 = (EntityBeanBean)compositeMBeanDescriptor.getBean();
            object = object2.createCmpField();
            object.setFieldName(string2);
        }
        if (string.equalsIgnoreCase("file")) {
            this.doCMPFileProperties(compositeMBeanDescriptor);
        } else if (string.equalsIgnoreCase("jdbc")) {
            if (this.isCMP20beanFlag) {
                this.doCMP20JDBCProperties(compositeMBeanDescriptor, hashtable, (weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean)baseWeblogicRdbmsBeanBean);
            } else {
                this.doCMP11JDBCProperties(compositeMBeanDescriptor, hashtable, (WeblogicRdbmsBeanBean)baseWeblogicRdbmsBeanBean);
            }
        } else {
            this.log.logWarning(this.fmt.invalidPstoreType(string));
        }
        if (this.oldDDStruct.getPersistentStoreClassName() != null) {
            this.log.logWarning(this.fmt.noCustomPstoreClass());
        }
    }

    private void doCMPFileProperties(CompositeMBeanDescriptor compositeMBeanDescriptor) throws DDConverterCollectionException {
        if (verbose) {
            System.out.println("----- doCMPFileEntityProperties -----");
        }
        this.log.logError(this.fmt.noFilePersistence());
        throw new DDConverterCollectionException((Exception)((Object)new DDConverterException("noFilePersistence")));
    }

    protected void doCMP20JDBCProperties(CompositeMBeanDescriptor compositeMBeanDescriptor, Hashtable hashtable, weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean weblogicRdbmsBeanBean) throws DDConverterCollectionException {
        weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean weblogicRdbmsBeanBean2 = weblogicRdbmsBeanBean;
        try {
            String string;
            String string2;
            Object object;
            Object object2;
            Object object3;
            String string3 = compositeMBeanDescriptor.getBean().getEjbName();
            weblogicRdbmsBeanBean2.setEjbName(string3);
            weblogicRdbmsBeanBean2.setDataSourceJndiName(this.oldDDStruct.getJdbcPoolName());
            TableMapBean tableMapBean = weblogicRdbmsBeanBean2.createTableMap();
            tableMapBean.setTableName(this.oldDDStruct.getJdbcTableName());
            Hashtable hashtable2 = this.oldDDStruct.getJdbcAttributeMap();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                object2 = tableMapBean.createFieldMap();
                object2.setCmpField((String)object3);
                object2.setDbmsColumn((String)hashtable2.get(object3));
            }
            object3 = this.oldDDStruct.getFinderDescriptors();
            if (object3 != null) {
                object2 = ((Hashtable)object3).keys();
                object = null;
                string2 = new String();
                string = new String();
                EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
                while (object2.hasMoreElements()) {
                    string2 = (String)object2.nextElement();
                    string = (String)((Hashtable)object3).get(string2);
                    object = new FinderParser(string2, string, this.fmt, this.log);
                    ((FinderParser)object).parseFinder();
                    System.out.println("\n");
                    System.out.println("finder  key: " + string2);
                    System.out.println("finder elem: " + string);
                    String string4 = ((FinderParser)object).getNewMethod();
                    String string5 = null;
                    String string6 = null;
                    try {
                        QueryBean queryBean = entityBeanBean.createQuery();
                        QueryMethodBean queryMethodBean = queryBean.createQueryMethod();
                        weblogic.j2ee.descriptor.MethodParamsBean methodParamsBean = queryMethodBean.createMethodParams();
                        queryMethodBean.setMethodName(string4);
                        Iterator iterator = ((FinderParser)object).getParamTypes().iterator();
                        while (iterator.hasNext()) {
                            methodParamsBean.addMethodParam((String)iterator.next());
                        }
                        string6 = ((FinderParser)object).getNewQuery();
                        string5 = WLQLtoEJBQL.doWLQLtoEJBQL(string6, DDConverterBase.makeAbstractSchemaName(string3));
                        queryBean.setEjbQl(string5);
                    }
                    catch (RDBMSException rDBMSException) {
                        this.log.logWarning(this.fmt.qlConversion(string6, rDBMSException.toString()));
                    }
                }
            }
            if (debug) {
                System.out.println("\n\nrdbmsBean: " + weblogicRdbmsBeanBean2.toString());
            }
            object2 = "META-INF/weblogic-rdbms-jar.xml";
            object = compositeMBeanDescriptor.getWlBean().getEntityDescriptor().getPersistence();
            if (object != null) {
                compositeMBeanDescriptor.getWlBean().getEntityDescriptor().destroyPersistence((PersistenceBean)object);
            }
            object = compositeMBeanDescriptor.getWlBean().getEntityDescriptor().createPersistence();
            string2 = object.createPersistenceUse();
            string2.setTypeIdentifier("WebLogic_CMP_RDBMS");
            string2.setTypeVersion("6.0");
            string2.setTypeStorage((String)object2);
            string = (EntityBeanBean)compositeMBeanDescriptor.getBean();
            string.setCmpVersion("2.x");
        }
        catch (Exception exception) {
            this.log.logError(this.fmt.unexpectedError(exception.toString()));
            EJBLogger.logStackTrace((Throwable)exception);
            throw new DDConverterCollectionException((Exception)((Object)new DDConverterException(exception)));
        }
        this.m_rdbmsBeans.add(weblogicRdbmsBeanBean2);
    }

    protected void doCMP11JDBCProperties(CompositeMBeanDescriptor compositeMBeanDescriptor, Hashtable hashtable, WeblogicRdbmsBeanBean weblogicRdbmsBeanBean) throws DDConverterCollectionException {
        try {
            String string2;
            Object object;
            Object object2;
            EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
            EntityDescriptorBean entityDescriptorBean = compositeMBeanDescriptor.getWlBean().getEntityDescriptor();
            weblogicRdbmsBeanBean.setEjbName(entityBeanBean.getEjbName());
            weblogicRdbmsBeanBean.setTableName(this.oldDDStruct.getJdbcTableName());
            weblogicRdbmsBeanBean.setPoolName(this.oldDDStruct.getJdbcPoolName());
            Hashtable hashtable2 = this.oldDDStruct.getJdbcAttributeMap();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = weblogicRdbmsBeanBean.createFieldMap();
                object.setCmpField((String)object2);
                object.setDbmsColumn((String)hashtable2.get(object2));
            }
            object2 = this.oldDDStruct.getFinderDescriptors();
            if (object2 != null) {
                object = ((Hashtable)object2).keySet();
                for (String string2 : object) {
                    String string3 = (String)((Hashtable)object2).get(string2);
                    FinderParser finderParser = new FinderParser(string2, string3, this.fmt, this.log);
                    finderParser.parseFinder();
                    if (debug) {
                        System.out.println("\n");
                        System.out.println("finder  key: " + string2);
                        System.out.println("finder elem: " + string3);
                    }
                    FinderBean finderBean = weblogicRdbmsBeanBean.createFinder();
                    finderBean.setFinderName(finderParser.getNewMethod());
                    finderBean.setFinderQuery(finderParser.getNewQuery());
                    Vector vector = finderParser.getParamTypes();
                    for (int i = 0; i < vector.size(); ++i) {
                        finderBean.addFinderParam((String)vector.elementAt(i));
                    }
                }
            }
            if (debug) {
                System.out.println("\n\nrdbmsBean: " + weblogicRdbmsBeanBean.toString());
            }
            object = "META-INF/weblogic-rdbms-jar.xml";
            PersistenceBean persistenceBean = entityDescriptorBean.createPersistence();
            if (this.oldDDStruct.getIsModifiedMethodName() != null) {
                persistenceBean.setIsModifiedMethodName(this.oldDDStruct.getIsModifiedMethodName());
            }
            string2 = persistenceBean.createPersistenceUse();
            string2.setTypeIdentifier("WebLogic_CMP_RDBMS");
            string2.setTypeVersion("5.1.0");
            string2.setTypeStorage((String)object);
            entityBeanBean.setCmpVersion("1.x");
        }
        catch (Exception exception) {
            this.log.logError(this.fmt.unexpectedError(exception.toString()));
            EJBLogger.logStackTraceAndMessage((String)this.fmt.unexpectedError(exception.toString()), (Throwable)exception);
            throw new DDConverterCollectionException((Exception)((Object)new DDConverterException(exception)));
        }
    }

    private Structure parseFile(String string) throws Exception {
        this.currFile = string;
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        this.st = new StreamTokenizer(bufferedReader);
        this.st.resetSyntax();
        this.st.whitespaceChars(0, 32);
        this.st.wordChars(33, 126);
        this.st.eolIsSignificant(false);
        this.st.commentChar(59);
        this.st.ordinaryChar(40);
        this.st.ordinaryChar(41);
        this.st.ordinaryChar(91);
        this.st.ordinaryChar(93);
        this.st.ordinaryChar(44);
        this.st.quoteChar(34);
        Structure structure = this.parseStructure();
        fileReader.close();
        return structure;
    }

    private Structure parseStructure() throws Exception {
        if (verbose) {
            System.out.println("Entering parseStructure");
        }
        this.match('(');
        this.eofOK = false;
        ++this.nestingLevel;
        Structure structure = new Structure();
        structure.name = this.nextWord();
        structure.elements = this.parseElements();
        this.match(')');
        --this.nestingLevel;
        if (this.nestingLevel == 0) {
            this.eofOK = true;
        }
        return structure;
    }

    private int nextToken() throws Exception {
        int n = this.st.nextToken();
        if (n == 34) {
            n = -3;
        }
        if (verbose) {
            System.out.println(this.interpret());
        }
        if (n == -1 && !this.eofOK) {
            throw new ParseException(this.currFile, "Unexpected end of file");
        }
        return n;
    }

    private Hashtable parseElements() throws Exception {
        if (verbose) {
            System.out.println("Entering parseElements");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string;
            int n;
            char c;
            if ((c = (char)(n = this.nextToken())) == ')') {
                this.putBack();
                return hashtable;
            }
            if (c == '(') {
                this.putBack();
                Structure structure = this.parseStructure();
                string = structure.name;
                object = structure.elements;
            } else {
                string = this.st.sval;
                if (string == null) {
                    this.fatalError("Expected a word. Got " + this.interpret());
                }
                object = this.parseValue();
            }
            hashtable.put(string, object);
        }
    }

    private Object parseValue() throws Exception {
        int n;
        char c;
        if (verbose) {
            System.out.println("Entering parseValue");
        }
        if ((c = (char)(n = this.nextToken())) == '[') {
            this.putBack();
            return this.parseStringVector();
        }
        if (n == -3) {
            return this.st.sval;
        }
        this.fatalError("Expected word or '[' words ']'. Got " + this.interpret());
        return this.st.sval;
    }

    private Vector parseStringVector() throws Exception {
        if (verbose) {
            System.out.println("Entering parseStringVector");
        }
        Vector<String> vector = new Vector<String>();
        this.match('[');
        int n;
        char c;
        while ((c = (char)(n = this.nextToken())) != ']') {
            if (c == ',') continue;
            if (n == -3) {
                vector.addElement(this.st.sval);
                continue;
            }
            this.fatalError("Expected string or ']'. Got " + this.interpret());
        }
        return vector;
    }

    private void match(char c) throws Exception {
        int n = this.nextToken();
        if ((char)n == c) {
            return;
        }
        this.fatalError("Expected '" + c + "'. Got " + this.interpret());
    }

    private void fatalError(String string) throws ParseException {
        throw new ParseException(this.currFile, this.st.lineno(), string);
    }

    private String nextWord() throws Exception {
        int n = this.nextToken();
        if (n == -3) {
            return this.st.sval;
        }
        this.fatalError("Expected a word. Got " + this.interpret());
        return null;
    }

    private String interpret() {
        switch (this.st.ttype) {
            case -2: {
                return "number (" + this.st.nval + ")";
            }
            case -3: 
            case 34: {
                return "word (" + this.st.sval + ")";
            }
            case 10: {
                return "end of line";
            }
        }
        return "character '" + (char)this.st.ttype + "'";
    }

    private void putBack() throws Exception {
        this.st.pushBack();
    }

    class ParseException
    extends Exception {
        private static final long serialVersionUID = 7989961809471350639L;

        public ParseException(String string, int n, String string2) {
            super(string + ":(" + n + "): " + string2);
        }

        public ParseException(String string, String string2) {
            super(string + ": " + string2);
        }
    }
}

