/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.io.File;
import java.io.IOException;
import weblogic.ejb.container.utils.ddconverter.ConvertLog;
import weblogic.ejb.container.utils.ddconverter.DDConverterBase;
import weblogic.ejb.container.utils.ddconverter.DDConverterException;
import weblogic.ejb.container.utils.ddconverter.DDConverter_10;
import weblogic.ejb.container.utils.ddconverter.WorkingJar;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public final class DDConverter_1020
extends DDConverterBase {
    private static final boolean debug = true;
    private EjbDescriptorBean dd;
    DDConverter_10 ddc10 = null;

    public DDConverter_1020(String[] stringArray, String string, ConvertLog convertLog) throws DDConverterException {
        super(stringArray, string, convertLog, true);
        this.ddc10 = new DDConverter_10(convertLog, true);
    }

    public boolean convert() throws DDConverterException, IOException {
        for (int i = 0; i < this.sources.length; ++i) {
            EjbDescriptorBean ejbDescriptorBean = null;
            System.out.println(this.fmt.converting(this.sources[i]));
            try {
                ejbDescriptorBean = this.loadDD(this.sources[i]);
            }
            catch (Exception exception) {
                this.log.logError(this.fmt.readDDError(this.sources[i], StackTraceUtils.throwable2StackTrace((Throwable)exception)));
            }
            File file = new File(this.targetDirName, ejbDescriptorBean.getJarFileName());
            WorkingJar workingJar = new WorkingJar(file);
            this.writeEJBDDsToJar(ejbDescriptorBean, workingJar);
            workingJar.close();
        }
        return !this.log.hasErrors();
    }

    public boolean convert(String string) throws DDConverterException, IOException {
        Debug.assertion((string != null ? 1 : 0) != 0);
        this.dd = new EjbDescriptorBean();
        for (int i = 0; i < this.sources.length; ++i) {
            try {
                this.dd = this.loadDD(this.dd, this.sources[i]);
                continue;
            }
            catch (Exception exception) {
                this.log.logError(this.fmt.readDDError(this.sources[i], StackTraceUtils.throwable2StackTrace((Throwable)exception)));
            }
        }
        File file = new File(this.targetDirName, string);
        WorkingJar workingJar = new WorkingJar(file);
        this.writeEJBDDsToJar(this.dd, workingJar);
        workingJar.close();
        return !this.log.hasErrors();
    }

    protected EjbDescriptorBean loadDD(EjbDescriptorBean ejbDescriptorBean, String string) throws IOException, XMLProcessingException, XMLParsingException {
        this.dd = this.ddc10.invokeDDC10(ejbDescriptorBean, string);
        String string2 = new File(string).getName();
        String string3 = string2.substring(0, string2.length() - 3) + "jar";
        this.dd.setJarFileName(string3);
        return this.dd;
    }

    protected EjbDescriptorBean loadDD(String string) throws IOException, XMLProcessingException, XMLParsingException {
        EjbDescriptorBean ejbDescriptorBean = new EjbDescriptorBean();
        ejbDescriptorBean.createEjbJarBean();
        ejbDescriptorBean.createWeblogicEjbJarBean();
        ejbDescriptorBean.getEjbJarBean().createEnterpriseBeans();
        return this.loadDD(ejbDescriptorBean, string);
    }
}

