/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.utils.ddconverter.ConvertLog;
import weblogic.ejb.container.utils.ddconverter.EJBddcTextFormatter;

public final class FinderParser {
    private String oldMethodSig;
    private String oldQuery;
    private String newMethodSig;
    private String newQuery;
    private String newMethod;
    private Vector paramNames;
    private Vector paramTypes;
    private EJBddcTextFormatter fmt;
    private ConvertLog log;
    private static final int METHOD_NAME = 1;
    private static final int PARAM_BEGIN = 2;
    private static final int PARAM_TYPE = 3;
    private static final int PARAM_NAME = 4;
    private static final int PARAM_NEXT = 5;
    private static final int ARRAY_PARAM = 6;
    private static final int PARAM_END = 7;

    public FinderParser(String string, String string2) {
        this.oldMethodSig = string;
        this.oldQuery = string2;
        this.newMethodSig = new String();
        this.newQuery = new String();
        this.paramNames = new Vector();
        this.paramTypes = new Vector();
    }

    public FinderParser(String string, String string2, EJBddcTextFormatter eJBddcTextFormatter, ConvertLog convertLog) {
        this.fmt = eJBddcTextFormatter;
        this.log = convertLog;
        this.oldMethodSig = string;
        this.oldQuery = string2;
        this.newMethodSig = new String();
        this.newQuery = new String();
        this.paramNames = new Vector();
        this.paramTypes = new Vector();
    }

    public String getOldMethodSig() {
        return this.oldMethodSig;
    }

    public String getOldQuery() {
        return this.oldQuery;
    }

    public String getNewMethodSig() {
        return this.newMethodSig;
    }

    public String getNewQuery() {
        return this.newQuery;
    }

    public String getNewMethod() {
        return this.newMethod;
    }

    public Vector getParamNames() {
        return this.paramNames;
    }

    public Vector getParamTypes() {
        return this.paramTypes;
    }

    public void parseFinder() {
        this.parseMethodSig();
        this.parseQuery();
        this.checkParams();
    }

    private void checkParams() {
        String string = null;
        Class<?> clazz = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement("int");
        vector.addElement("float");
        vector.addElement("boolean");
        vector.addElement("double");
        vector.addElement("short");
        vector.addElement("byte");
        vector.addElement("char");
        vector.addElement("long");
        for (int i = 0; i < this.paramTypes.size(); ++i) {
            clazz = null;
            string = (String)this.paramTypes.elementAt(i);
            if (vector.contains(string)) continue;
            try {
                clazz = Class.forName(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.logWarning(this.fmt.typesNotFullyQualified(string, this.oldMethodSig));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseQuery() {
        String string = new String();
        int n = 0;
        boolean bl = false;
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this.oldQuery));
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.ordinaryChar(39);
        streamTokenizer.ordinaryChar(32);
        streamTokenizer.ordinaryChar(95);
        streamTokenizer.ordinaryChars(45, 46);
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.ordinaryChars(95, 95);
        streamTokenizer.wordChars(45, 46);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(95, 95);
        try {
            while (true) {
                if (n == -1) {
                    this.newQuery = string;
                    return;
                }
                n = streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3) {
                    if (bl) {
                        int n2 = this.paramNames.indexOf(streamTokenizer.sval);
                        if (n2 <= -1) {
                            String string2 = "Invalid parameter name. " + streamTokenizer.sval + ". Check to make sure query params match signature params";
                            throw new FinderParserException(string2);
                        }
                        string = string + n2;
                        bl = false;
                        continue;
                    }
                    string = string + streamTokenizer.sval;
                    continue;
                }
                if (streamTokenizer.ttype == -2) {
                    string = string + streamTokenizer.nval;
                    continue;
                }
                if (streamTokenizer.ttype == -1) continue;
                if (n == 36) {
                    bl = true;
                }
                string = string + (char)n;
            }
        }
        catch (IOException iOException) {
            EJBLogger.logStackTrace((Throwable)iOException);
            return;
        }
        catch (FinderParserException finderParserException) {
            EJBLogger.logStackTrace((Throwable)finderParserException);
        }
    }

    private void parseMethodSig() {
        String string = new String();
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this.oldMethodSig));
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.wordChars(95, 95);
            while (true) {
                if (n2 == -1) break;
                n2 = streamTokenizer.nextToken();
                switch (n) {
                    case 1: {
                        if (streamTokenizer.sval != null) {
                            string = string + streamTokenizer.sval;
                            n = 2;
                            this.newMethod = streamTokenizer.sval;
                            break;
                        }
                        throw new FinderParserException();
                    }
                    case 2: {
                        if (n2 == 40) {
                            string = string + (char)n2;
                            n = 3;
                            break;
                        }
                        throw new FinderParserException();
                    }
                    case 3: {
                        if (n2 == 41) {
                            string = string + (char)n2;
                            n = 7;
                            break;
                        }
                        if (streamTokenizer.sval != null) {
                            string = string + streamTokenizer.sval;
                            this.paramTypes.addElement(streamTokenizer.sval);
                            n = 4;
                            break;
                        }
                        throw new FinderParserException();
                    }
                    case 4: {
                        if (n2 == 91) {
                            n = 6;
                            string = string + (char)n2;
                            break;
                        }
                        if (streamTokenizer.sval != null) {
                            this.paramNames.addElement(streamTokenizer.sval);
                            string = string + " $" + n3++;
                            n = 5;
                            break;
                        }
                        throw new FinderParserException();
                    }
                    case 5: {
                        if (n2 == 44) {
                            string = string + (char)n2 + " ";
                            n = 3;
                            break;
                        }
                        if (n2 == 41) {
                            string = string + (char)n2;
                            n = 7;
                            break;
                        }
                        if (n2 == 91) {
                            String string2 = "This parser can't deal with arrays declared in ths format: type name[]. Use format: type[] name";
                            throw new FinderParserException(string2);
                        }
                        throw new FinderParserException();
                    }
                    case 6: {
                        if (n2 == 93) {
                            string = string + (char)n2;
                            n = 4;
                            break;
                        }
                        throw new FinderParserException();
                    }
                }
            }
            this.newMethodSig = string;
        }
        catch (IOException iOException) {
            EJBLogger.logStackTrace((Throwable)iOException);
        }
        catch (FinderParserException finderParserException) {
            EJBLogger.logStackTrace((Throwable)finderParserException);
        }
    }

    public static void main(String[] stringArray) {
        EJBddcTextFormatter eJBddcTextFormatter = new EJBddcTextFormatter();
        ConvertLog convertLog = null;
        try {
            convertLog = new ConvertLog();
        }
        catch (IOException iOException) {
            System.err.println("Error create ddconverter.log");
            System.exit(1);
        }
        String string = new String();
        String string2 = new String();
        FinderParser finderParser = null;
        System.out.println("\n");
        string = "findString(String foo, int bar, java.lang.String baz)";
        string2 = "(= foo $foo)";
        finderParser = new FinderParser(string, string2);
        finderParser.parseFinder();
        System.out.println(" old method sig: " + finderParser.getOldMethodSig());
        System.out.println(" new method sig: " + finderParser.getNewMethodSig());
        System.out.println("     new method: " + finderParser.getNewMethod());
        System.out.println("new param types: " + finderParser.getParamTypes());
        System.out.println("      old query: " + finderParser.getOldQuery());
        System.out.println("      new query: " + finderParser.getNewQuery());
        System.out.println("\n");
    }

    public final class FinderParserException
    extends Exception {
        private static final long serialVersionUID = -133777467782987526L;

        public FinderParserException() {
        }

        public FinderParserException(String string) {
            super(string);
        }
    }
}

