/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Structure {
    public String name;
    public Hashtable elements;
    static int indentLevel = 0;
    static final String SPACES = "                                                     ";

    public String spaces() {
        return SPACES.substring(0, indentLevel * 2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.spaces() + "(" + this.name + "\n");
        Enumeration enumeration = this.elements.keys();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            ++indentLevel;
            String string = (String)enumeration.nextElement();
            Object v = this.elements.get(string);
            if (v instanceof Structure) {
                stringBuffer.append(v);
            } else if (v instanceof String) {
                stringBuffer.append(this.spaces() + string + ": " + (String)v + "\n");
            } else if (v instanceof Vector) {
                stringBuffer.append(this.spaces() + string + ": [ ");
                cloneable = (Vector)v;
                int n = ((Vector)cloneable).size();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append((String)((Vector)cloneable).elementAt(i) + " ");
                }
                stringBuffer.append("]\n");
            } else if (v instanceof Hashtable) {
                stringBuffer.append(this.spaces() + string + ": { ");
                cloneable = (Hashtable)v;
                Enumeration enumeration2 = ((Hashtable)cloneable).keys();
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    Object v2 = ((Hashtable)cloneable).get(string2);
                    stringBuffer.append("\n" + this.spaces() + this.spaces() + string2 + ": " + v2 + "\n");
                }
                stringBuffer.append("}\n");
            }
            --indentLevel;
        }
        stringBuffer.append(this.spaces() + ")\n");
        return stringBuffer.toString();
    }
}

