/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils.ddconverter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import weblogic.utils.jars.RandomAccessJarFile;

public final class WorkingJar
extends RandomAccessJarFile {
    private File m_destJarFile;
    private static final boolean debug = false;
    private static final Set excludes = new HashSet<Object>(Arrays.asList((Object[])new String[]{"META-INF/ejb-jar.xml", "META-INF/weblogic-ejb-jar.xml", "META-INF/MANIFEST.MF"}));

    public WorkingJar(File file) throws IOException {
        super(file);
        this.m_destJarFile = file;
    }

    public File getFile() {
        return this.m_destJarFile;
    }

    public WorkingJar(File file, String[] stringArray) throws IOException {
        super(file);
        this.copyJarWithExcludes(stringArray);
    }

    private void copyJarWithExcludes(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            JarFile jarFile = new JarFile(stringArray[i]);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || excludes.contains(string = jarEntry.getName())) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                OutputStream outputStream = this.writeEntry(string, true);
                byte[] byArray = new byte[1000];
                int n = 0;
                while ((n = inputStream.read(byArray)) >= 0) {
                    outputStream.write(byArray, 0, n);
                }
                outputStream.close();
            }
        }
    }
}

