/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.lang.reflect.Constructor;
import weblogic.ejb.container.cache.EntityCache;
import weblogic.ejb.container.cache.NRUCache;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.QueryCache;
import weblogic.utils.AssertionError;

public class EJBCacheFactory {
    public static EJBCache createNRUCache(String string, int n) {
        return new NRUCache(string, n);
    }

    public static EJBCache createNRUCache(String string, long l) {
        return new NRUCache(string, l);
    }

    public static EJBCache createEntityCache(String string, int n) {
        return new EntityCache(string, n);
    }

    public static EJBCache createEntityCache(String string, long l) {
        return new EntityCache(string, l);
    }

    public static QueryCache createQueryCache(String string, int n) {
        try {
            Class<?> clazz = Class.forName("weblogic.ejb.container.cache.QueryCache");
            Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
            return (QueryCache)constructor.newInstance(string, new Integer(n));
        }
        catch (Exception exception) {
            throw new AssertionError("Error creating query cache", (Throwable)exception);
        }
    }
}

