/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.PrintWriter;
import weblogic.ejb.container.EJBTextTextFormatter;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.management.DeploymentException;
import weblogic.utils.AssertionError;
import weblogic.utils.PlatformConstants;

public final class EJBDeploymentException
extends DeploymentException {
    private static final long serialVersionUID = 5093229614062171037L;
    private String ejbName;
    private String ejbFileName;
    private WLDeploymentException[] deploymentExceptions;
    private Throwable unexpectedError;

    public EJBDeploymentException(String string, String string2, WLDeploymentException wLDeploymentException) {
        super(string, wLDeploymentException);
        this.ejbName = string;
        this.ejbFileName = string2;
        this.deploymentExceptions = new WLDeploymentException[1];
        this.deploymentExceptions[0] = wLDeploymentException;
    }

    public EJBDeploymentException(String string, String string2, Throwable throwable) {
        super(string, throwable);
        this.ejbName = string;
        this.ejbFileName = string2;
        this.unexpectedError = throwable;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer(200);
        EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
        stringBuffer.append(eJBTextTextFormatter.ejbDeploymentError(this.ejbName, this.ejbFileName));
        if (this.deploymentExceptions != null) {
            for (int i = 0; i < this.deploymentExceptions.length; ++i) {
                stringBuffer.append(this.deploymentExceptions[i].getErrorMessage());
                stringBuffer.append(PlatformConstants.EOL);
            }
        } else if (this.unexpectedError != null) {
            stringBuffer.append(this.unexpectedError.getMessage());
            stringBuffer.append(PlatformConstants.EOL);
        } else {
            throw new AssertionError("Expected either deploymentExceptions or unexpectedError to be non-null.");
        }
        stringBuffer.append(PlatformConstants.EOL);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getMessage();
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        printWriter.println(this.getMessage());
    }
}

