/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.io.Archive;
import weblogic.application.io.Ear;
import weblogic.application.io.Jar;
import weblogic.ejb.spi.ExplodedEJB;
import weblogic.utils.classloaders.ClassFinder;

public class EJBJar {
    private final Archive archive;
    private final ClassFinder classfinder;

    public EJBJar(String string, File file) throws IOException {
        this.archive = file.isDirectory() ? new ExplodedEJB(string, new File[]{file}) : new Jar(string, file);
        this.classfinder = this.archive.getClassFinder();
    }

    public EJBJar(String string, ApplicationContextInternal applicationContextInternal) throws IOException {
        Ear ear = applicationContextInternal.getEar();
        if (ear == null) {
            File file = new File(applicationContextInternal.getStagingPath());
            if (!file.exists()) {
                throw new FileNotFoundException("Unable to find ejb-jar for uri " + string + " at path " + file.getAbsolutePath());
            }
            this.archive = file.isDirectory() ? new ExplodedEJB(string, new File[]{file}) : new Jar(string, file);
        } else {
            File[] fileArray = ear.getModuleRoots(string);
            if (fileArray.length == 0) {
                throw new FileNotFoundException("Unable to find ejb-jar with uri " + string + " in ear at " + applicationContextInternal.getStagingPath());
            }
            this.archive = fileArray.length == 1 && !fileArray[0].isDirectory() ? new Jar(string, fileArray[0]) : new ExplodedEJB(string, fileArray);
        }
        this.classfinder = this.archive.getClassFinder();
    }

    public ClassFinder getClassFinder() {
        return this.classfinder;
    }

    public void remove() {
        this.archive.remove();
    }
}

