/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import weblogic.application.utils.AnnotationDetector;
import weblogic.j2ee.J2EEUtils;
import weblogic.utils.classloaders.JarClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public final class EJBJarUtils {
    public static AnnotationDetector ejbAnnotationDetector;
    private static Method m_isAnnotationPresentMethod;

    public static boolean hasEJBSources(File file) throws IOException {
        return file.isDirectory() && ejbAnnotationDetector != null && ejbAnnotationDetector.hasAnnotatedSources(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEJB(File file) throws IOException {
        JarFile jarFile;
        block7: {
            block6: {
                boolean bl;
                if (file.isDirectory()) {
                    File file2 = new File(file, J2EEUtils.EJB_DD_PATH);
                    if (file2.exists() && file2.length() > 0L) {
                        return true;
                    }
                    if (ejbAnnotationDetector == null || !ejbAnnotationDetector.isAnnotated(file)) return false;
                    return true;
                }
                if (!file.getName().endsWith(".jar") || !file.exists()) return false;
                jarFile = null;
                try {
                    jarFile = new JarFile(file);
                    ZipEntry zipEntry = jarFile.getEntry("META-INF/ejb-jar.xml");
                    if (zipEntry == null || zipEntry.getSize() == 0L) break block6;
                    bl = true;
                    Object var5_6 = null;
                    if (jarFile == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (jarFile == null) throw throwable;
                    jarFile.close();
                    throw throwable;
                }
                jarFile.close();
                return bl;
            }
            if (ejbAnnotationDetector == null || !ejbAnnotationDetector.isAnnotated(jarFile)) break block7;
            boolean bl = true;
            Object var5_7 = null;
            if (jarFile == null) return bl;
            jarFile.close();
            return bl;
        }
        Object var5_8 = null;
        if (jarFile == null) return false;
        jarFile.close();
        return false;
    }

    public static boolean isEJB(VirtualJarFile virtualJarFile) throws IOException {
        ZipEntry zipEntry = virtualJarFile.getEntry("META-INF/ejb-jar.xml");
        if (zipEntry != null && zipEntry.getSize() != 0L) {
            return true;
        }
        return ejbAnnotationDetector != null && ejbAnnotationDetector.isAnnotated(virtualJarFile);
    }

    private static Class loadClass(File file, String string) throws IOException {
        Class clazz = null;
        try {
            String string2 = ".class";
            if (string.endsWith(string2)) {
                String string3 = "file:///" + file.getAbsolutePath();
                JarClassLoader jarClassLoader = new JarClassLoader(file);
                int n = string.lastIndexOf(string2);
                String string4 = string.substring(0, n).replace('/', '.');
                clazz = jarClassLoader.loadClass(string4);
                jarClassLoader.close();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return clazz;
    }

    private static boolean isAnnotationPresent(Class clazz) {
        boolean bl = false;
        try {
            Class<?> clazz2 = Class.forName("weblogic.dbeans.annotations.Entity");
            if (null == m_isAnnotationPresentMethod) {
                m_isAnnotationPresentMethod = clazz.getClass().getMethod("isAnnotationPresent", Class.class);
            }
            Boolean bl2 = (Boolean)m_isAnnotationPresentMethod.invoke((Object)clazz, clazz2);
            bl = bl2;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.out.println("Usage EjbJarUtils <file>");
            System.exit(-1);
        }
        System.out.println("Do we have annotations in the module? " + EJBJarUtils.isEJB(new File(stringArray[0])));
    }

    static {
        try {
            ejbAnnotationDetector = new AnnotationDetector(new Class[]{Class.forName("javax.ejb.MessageDriven"), Class.forName("javax.ejb.Stateful"), Class.forName("javax.ejb.Stateless")});
        }
        catch (Throwable throwable) {
            ejbAnnotationDetector = null;
        }
        m_isAnnotationPresentMethod = null;
    }
}

