/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.IOException;
import weblogic.application.Type;
import weblogic.application.library.ApplicationLibrary;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryContext;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.MultiClassFinder;

public class EJBLibraryDefinition
extends LibraryDefinition
implements Library,
ApplicationLibrary {
    private static String singletonAutoRefLibName = null;

    public EJBLibraryDefinition(LibraryData libraryData) {
        super(libraryData, Type.EJB);
    }

    public void importLibrary(J2EELibraryReference j2EELibraryReference, LibraryContext libraryContext, MultiClassFinder multiClassFinder) throws LibraryProcessingException {
        LibraryLoggingUtils.checkNoContextRootSet(j2EELibraryReference, Type.EJB);
        this.addEJB(libraryContext, this.getLocation().getName());
        try {
            libraryContext.registerLink(this.getLocation());
        }
        catch (IOException iOException) {
            throw new LibraryProcessingException(iOException);
        }
    }

    private ClassFinder getClassFinder() {
        return new ClasspathClassFinder2(this.getLocation().getAbsolutePath());
    }

    private void addEJB(LibraryContext libraryContext, String string) throws LibraryProcessingException {
        ApplicationBean applicationBean = libraryContext.getApplicationDD();
        applicationBean.createModule().setEjb(string);
        LibraryLoggingUtils.updateDescriptor(libraryContext.getApplicationDescriptor(), applicationBean);
    }

    public void init() throws LibraryProcessingException {
        LibraryConstants.AutoReferrer[] autoReferrerArray = this.getAutoRef();
        if (autoReferrerArray.length > 0) {
            for (LibraryConstants.AutoReferrer autoReferrer : autoReferrerArray) {
                if (autoReferrer == LibraryConstants.AutoReferrer.EJBApp) continue;
                throw new LibraryProcessingException("Unsupported Auto-Ref value: " + (Object)((Object)autoReferrer));
            }
            if (singletonAutoRefLibName == null) {
                singletonAutoRefLibName = this.getName();
            } else if (!singletonAutoRefLibName.equals(this.getName())) {
                throw new LibraryProcessingException("Only one ejb auto reference library allowed. " + singletonAutoRefLibName + " is already deployed as an auto reference library");
            }
        }
    }

    public void cleanup() throws LibraryProcessingException {
        LibraryConstants.AutoReferrer[] autoReferrerArray = this.getAutoRef();
        if (autoReferrerArray.length > 0 && singletonAutoRefLibName != null && singletonAutoRefLibName.equals(this.getName())) {
            singletonAutoRefLibName = null;
        }
    }
}

