/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.ejb.container.EJBLogger;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.logging.Loggable;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.TopLevelDescriptorMBean;
import weblogic.utils.jars.RandomAccessJarFile;

public class EjbDescriptorBean
implements TopLevelDescriptorMBean {
    private static final long serialVersionUID = 4598155809773582508L;
    private String jarFileName;
    private boolean readOnly;
    private EjbJarBean ejbJar;
    private WeblogicEjbJarBean wlEjbJar;
    private Set rdbms11Jars = new HashSet();
    private Set rdbms20Jars = new HashSet();
    private String appName;
    private String uri;
    private DescriptorManager descriptorManager;
    private boolean isEjb30 = false;
    private DeploymentPlanBean plan = null;
    private File configDir = null;
    private boolean isWeblogicEjbJarSynthetic = false;
    String destination = null;

    public EjbDescriptorBean() {
        this(false);
    }

    public void setEjb30(boolean bl) {
        this.isEjb30 = bl;
    }

    public boolean isEjb30() {
        if (this.ejbJar == null) {
            Loggable loggable = EJBLogger.logEjBJarBeanNotSetLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        return this.isEjb30;
    }

    public EjbDescriptorBean(boolean bl) {
        this.readOnly = bl;
        this.descriptorManager = bl ? new DescriptorManager() : new EditableDescriptorManager();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public EjbJarBean getEjbJarBean() {
        return this.ejbJar;
    }

    public void setEjbJarBean(EjbJarBean ejbJarBean) {
        this.ejbJar = ejbJarBean;
        String string = ((DescriptorBean)ejbJarBean).getDescriptor().getOriginalVersionInfo();
        if (string.equals("3.0")) {
            this.isEjb30 = true;
        }
    }

    public EjbJarBean createEjbJarBean() {
        EjbJarBean ejbJarBean = (EjbJarBean)this.descriptorManager.createDescriptorRoot(EjbJarBean.class).getRootBean();
        this.setEjbJarBean(ejbJarBean);
        return ejbJarBean;
    }

    public WeblogicEjbJarBean getWeblogicEjbJarBean() {
        return this.wlEjbJar;
    }

    public void setWeblogicEjbJarBean(WeblogicEjbJarBean weblogicEjbJarBean) {
        this.wlEjbJar = weblogicEjbJarBean;
    }

    public WeblogicEjbJarBean createWeblogicEjbJarBean() {
        return this.createWeblogicEjbJarBean(null);
    }

    public WeblogicEjbJarBean createWeblogicEjbJarBean(String string) {
        WeblogicEjbJarBean weblogicEjbJarBean = (WeblogicEjbJarBean)this.descriptorManager.createDescriptorRoot(WeblogicEjbJarBean.class, string).getRootBean();
        this.setWeblogicEjbJarBean(weblogicEjbJarBean);
        return weblogicEjbJarBean;
    }

    public weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] getWeblogicRdbmsJarBeans() {
        return this.rdbms20Jars.toArray(new weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[0]);
    }

    public void setWeblogicRdbmsJarBeans(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray) {
        this.rdbms20Jars.clear();
        if (weblogicRdbmsJarBeanArray != null) {
            for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
                this.rdbms20Jars.add(weblogicRdbmsJarBeanArray[i]);
            }
        }
    }

    public void addWeblogicRdbmsJarBean(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.rdbms20Jars.add(weblogicRdbmsJarBean);
    }

    public void removeWeblogicRdbmsJarBean(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.rdbms20Jars.remove(weblogicRdbmsJarBean);
    }

    public weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean createWeblogicRdbmsJarBean() {
        return this.createWeblogicRdbmsJarBean(null);
    }

    public weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean createWeblogicRdbmsJarBean(String string) {
        weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean = (weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean)this.descriptorManager.createDescriptorRoot(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean.class, string).getRootBean();
        this.addWeblogicRdbmsJarBean(weblogicRdbmsJarBean);
        return weblogicRdbmsJarBean;
    }

    public weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean getWeblogicRdbmsJarBean(String string) {
        Object v = this.getFileNameToRdbmsDescriptorMap().get(string);
        if (v instanceof weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean) {
            return (weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean)v;
        }
        return null;
    }

    public WeblogicRdbmsJarBean[] getWeblogicRdbms11JarBeans() {
        return this.rdbms11Jars.toArray(new WeblogicRdbmsJarBean[0]);
    }

    public void setWeblogicRdbms11JarBeans(WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray) {
        this.rdbms11Jars.clear();
        if (weblogicRdbmsJarBeanArray != null) {
            for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
                this.rdbms11Jars.add(weblogicRdbmsJarBeanArray[i]);
            }
        }
    }

    public void addWeblogicRdbms11JarBean(WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.rdbms11Jars.add(weblogicRdbmsJarBean);
    }

    public void removeWeblogicRdbms11JarBean(WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.rdbms11Jars.remove(weblogicRdbmsJarBean);
    }

    public WeblogicRdbmsJarBean createWeblogicRdbms11JarBean() {
        return this.createWeblogicRdbms11JarBean(null);
    }

    public WeblogicRdbmsJarBean createWeblogicRdbms11JarBean(String string) {
        WeblogicRdbmsJarBean weblogicRdbmsJarBean = (WeblogicRdbmsJarBean)this.descriptorManager.createDescriptorRoot(WeblogicRdbmsJarBean.class, string).getRootBean();
        this.addWeblogicRdbms11JarBean(weblogicRdbmsJarBean);
        return weblogicRdbmsJarBean;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public void setJarFileName(String string) {
        this.jarFileName = string;
    }

    public Set getRDBMSDescriptorFileNames() {
        return new HashSet();
    }

    public String getParsingErrorMessage() {
        return null;
    }

    public void setParsingErrorMessage(String string) {
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public DeploymentPlanBean getDeploymentPlan() {
        return this.plan;
    }

    public void setDeploymentPlan(DeploymentPlanBean deploymentPlanBean) {
        this.plan = deploymentPlanBean;
    }

    public File getConfigDirectory() {
        return this.configDir;
    }

    public void setConfigDirectory(File file) {
        this.configDir = file;
    }

    public String getName() {
        return null;
    }

    public void setName(String string) {
    }

    public String toXML(int n) {
        return "";
    }

    public void register() {
    }

    public void unregister() {
    }

    public void validate() throws DescriptorValidationException {
    }

    public void usePersistenceDestination(String string) {
        this.destination = string;
    }

    public void persist() throws IOException {
        if (this.destination == null) {
            throw new RuntimeException("No persistentDestination set!");
        }
        File file = new File(this.destination);
        if (file.isDirectory()) {
            this.persistToDirectory(file);
        } else {
            this.persistToJarFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persistDescriptor(File file, String string, Object object) throws IOException {
        if (!((DescriptorBean)object).isEditable()) {
            throw new IOException("Error: " + string + " is not editable");
        }
        File file2 = new File(file, string);
        file2.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            DescriptorBean descriptorBean = (DescriptorBean)object;
            descriptorBean.getDescriptor().toXML((OutputStream)fileOutputStream);
            Object var8_7 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (fileOutputStream == null) throw throwable;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    private void persistToDirectory(File file) throws IOException {
        this.persistDescriptor(file, "META-INF/ejb-jar.xml", (Object)this.ejbJar);
        if (this.wlEjbJar != null) {
            this.persistDescriptor(file, "META-INF/weblogic-ejb-jar.xml", (Object)this.wlEjbJar);
        }
        Map map = this.getFileNameToRdbmsDescriptorMap();
        Set set = map.keySet();
        for (String string : set) {
            Object v = map.get(string);
            if (v instanceof weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean) {
                this.persistDescriptor(file, string, (Object)((weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean)v));
                continue;
            }
            this.persistDescriptor(file, string, (Object)((WeblogicRdbmsJarBean)v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persistDescriptor(RandomAccessJarFile randomAccessJarFile, String string, Object object) throws IOException {
        OutputStream outputStream = null;
        try {
            DescriptorBean descriptorBean = (DescriptorBean)object;
            if (descriptorBean.isEditable()) {
                outputStream = randomAccessJarFile.writeEntry(string, true);
                descriptorBean.getDescriptor().toXML(outputStream);
            }
            Object var7_6 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persistToJarFile(File file) throws IOException {
        String string = ".";
        RandomAccessJarFile randomAccessJarFile = new RandomAccessJarFile(new File(string), file);
        try {
            this.persistDescriptor(randomAccessJarFile, "META-INF/ejb-jar.xml", (Object)this.ejbJar);
            if (this.wlEjbJar != null) {
                this.persistDescriptor(randomAccessJarFile, "META-INF/weblogic-ejb-jar.xml", (Object)this.wlEjbJar);
            }
            Map map = this.getFileNameToRdbmsDescriptorMap();
            Set set = map.keySet();
            for (String string2 : set) {
                Object v = map.get(string2);
                if (v instanceof weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean) {
                    this.persistDescriptor(randomAccessJarFile, string2, (Object)((weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean)v));
                    continue;
                }
                this.persistDescriptor(randomAccessJarFile, string2, (Object)((WeblogicRdbmsJarBean)v));
            }
            Object var10_9 = null;
            if (randomAccessJarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (randomAccessJarFile == null) throw throwable;
            randomAccessJarFile.close();
            throw throwable;
        }
        randomAccessJarFile.close();
    }

    public Map getFileNameToRdbmsDescriptorMap() {
        WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray;
        if (this.wlEjbJar == null) {
            return new HashMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = this.wlEjbJar.getWeblogicEnterpriseBeans();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            WeblogicRdbmsJarBean weblogicRdbmsJarBean;
            Object object;
            if (weblogicEnterpriseBeanBeanArray[i].getEntityDescriptor() == null || (object = weblogicEnterpriseBeanBeanArray[i].getEntityDescriptor()).getPersistence() == null || (weblogicRdbmsJarBean = object.getPersistence()) == null || (weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getPersistenceUse()) == null) continue;
            hashMap.put(weblogicEnterpriseBeanBeanArray[i].getEjbName(), weblogicRdbmsBeanBeanArray.getTypeStorage());
        }
        HashMap hashMap2 = new HashMap();
        for (WeblogicRdbmsJarBean weblogicRdbmsJarBean : this.rdbms11Jars) {
            weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
            if (weblogicRdbmsBeanBeanArray.length == 0) continue;
            hashMap2.put(hashMap.get(weblogicRdbmsBeanBeanArray[0].getEjbName()), weblogicRdbmsJarBean);
        }
        for (WeblogicRdbmsJarBean weblogicRdbmsJarBean : this.rdbms20Jars) {
            weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
            if (weblogicRdbmsBeanBeanArray.length == 0) continue;
            hashMap2.put(hashMap.get(weblogicRdbmsBeanBeanArray[0].getEjbName()), weblogicRdbmsJarBean);
        }
        return hashMap2;
    }

    public void persist(Properties properties) throws IOException {
    }

    public boolean isWeblogicEjbJarSynthetic() {
        return this.isWeblogicEjbJarSynthetic;
    }

    public void markWeblogicEjbJarSynthetic() {
        this.isWeblogicEjbJarSynthetic = true;
    }
}

