/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.ejb.container.utils.AutoRefLibHelper;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.ejb.spi.EjbDescriptorReader;
import weblogic.ejb.spi.EjbJarReader;
import weblogic.ejb.spi.WeblogicEjbJarReader;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class EjbJarDescriptor {
    public static final String STANDARD_DD = "META-INF/ejb-jar.xml";
    public static final String WEBLOGIC_DD = "META-INF/weblogic-ejb-jar.xml";
    private MyEjbJarDescriptor ejbJarDescriptor;
    private MyWlsEjbJarDescriptor wlsEjbJarDescriptor;
    private boolean isWritable = false;
    private EditableDescriptorManager edm = new EditableDescriptorManager();

    public EjbJarDescriptor(File file, String string, String string2) {
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(string);
        File file2 = null;
        DeploymentPlanBean deploymentPlanBean = null;
        if (applicationContextInternal != null) {
            deploymentPlanBean = applicationContextInternal.findDeploymentPlan();
            AppDeploymentMBean appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
            if (appDeploymentMBean.getPlanDir() != null) {
                file2 = new File(appDeploymentMBean.getLocalPlanDir());
            }
        }
        if (file.getPath().endsWith("weblogic-ejb-jar.xml")) {
            this.wlsEjbJarDescriptor = new MyWlsEjbJarDescriptor(file, file2, deploymentPlanBean, string2, this.ejbJarDescriptor);
        } else {
            this.ejbJarDescriptor = new MyEjbJarDescriptor(file, file2, deploymentPlanBean, string, string2);
        }
    }

    public EjbJarDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        if (file.getPath().endsWith("weblogic-ejb-jar.xml")) {
            this.wlsEjbJarDescriptor = new MyWlsEjbJarDescriptor(file, file2, deploymentPlanBean, string2, this.ejbJarDescriptor);
        } else {
            this.ejbJarDescriptor = new MyEjbJarDescriptor(file, file2, deploymentPlanBean, string, string2);
        }
    }

    public EjbJarDescriptor(VirtualJarFile virtualJarFile, String string, String string2) {
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(string);
        File file = null;
        DeploymentPlanBean deploymentPlanBean = null;
        if (applicationContextInternal != null) {
            deploymentPlanBean = applicationContextInternal.findDeploymentPlan();
            AppDeploymentMBean appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
            if (appDeploymentMBean.getPlanDir() != null) {
                file = new File(appDeploymentMBean.getLocalPlanDir());
            }
        }
        this.ejbJarDescriptor = new MyEjbJarDescriptor(virtualJarFile, file, deploymentPlanBean, string, string2);
        this.wlsEjbJarDescriptor = new MyWlsEjbJarDescriptor(virtualJarFile, file, deploymentPlanBean, string2, this.ejbJarDescriptor);
    }

    public EjbJarDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        this.ejbJarDescriptor = new MyEjbJarDescriptor(virtualJarFile, file, deploymentPlanBean, string, string2);
        this.wlsEjbJarDescriptor = new MyWlsEjbJarDescriptor(virtualJarFile, file, deploymentPlanBean, string2, this.ejbJarDescriptor);
    }

    public EjbJarDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
        this.ejbJarDescriptor = new MyEjbJarDescriptor(descriptorManager, genericClassLoader);
        this.wlsEjbJarDescriptor = new MyWlsEjbJarDescriptor(descriptorManager, genericClassLoader);
    }

    public EjbJarDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.ejbJarDescriptor = new MyEjbJarDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, STANDARD_DD);
        this.wlsEjbJarDescriptor = new MyWlsEjbJarDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
    }

    public EjbJarDescriptor(File file, File file2, File file3, DeploymentPlanBean deploymentPlanBean, String string) {
        this.ejbJarDescriptor = new MyEjbJarDescriptor(file, file3, deploymentPlanBean, string, STANDARD_DD);
        this.wlsEjbJarDescriptor = new MyWlsEjbJarDescriptor(file2, file3, deploymentPlanBean, string, null);
    }

    public void mergeEJBJar(VirtualJarFile[] virtualJarFileArray) throws IOException, XMLStreamException {
        AutoRefLibHelper.mergeEJBJar(this, virtualJarFileArray);
    }

    public EjbJarBean getEjbJarBean() throws IOException, XMLStreamException {
        return (EjbJarBean)this.ejbJarDescriptor.loadDescriptorBean();
    }

    public WeblogicEjbJarBean getWeblogicEjbJarBean() throws IOException, XMLStreamException {
        if (this.wlsEjbJarDescriptor == null) {
            return null;
        }
        EjbDescriptorReader ejbDescriptorReader = EjbDescriptorFactory.getEjbDescriptorReader();
        return ejbDescriptorReader.parseWebLogicEjbJarXML(this, this.wlsEjbJarDescriptor.getDeploymentPlan(), this.wlsEjbJarDescriptor.getConfigDir(), this.wlsEjbJarDescriptor.getModuleName(), this.wlsEjbJarDescriptor.getInputStream(), this.ejbJarDescriptor == null ? null : this.getEjbJarBean(), null, true);
    }

    public WeblogicEjbJarBean parseWeblogicEjbJarBean() throws IOException, XMLStreamException {
        if (this.wlsEjbJarDescriptor == null) {
            return null;
        }
        return (WeblogicEjbJarBean)this.wlsEjbJarDescriptor.loadDescriptorBean();
    }

    public EjbJarBean getEditableEjbJarBean() throws IOException, XMLStreamException {
        return (EjbJarBean)this.ejbJarDescriptor.loadEditableDescriptorBean();
    }

    public WeblogicEjbJarBean getEditableWeblogicEjbJarBean() throws IOException, XMLStreamException {
        if (this.wlsEjbJarDescriptor == null) {
            return null;
        }
        EjbDescriptorReader ejbDescriptorReader = EjbDescriptorFactory.getEjbDescriptorReader();
        return ejbDescriptorReader.parseWebLogicEjbJarXML(this, this.wlsEjbJarDescriptor.getDeploymentPlan(), this.wlsEjbJarDescriptor.getConfigDir(), this.wlsEjbJarDescriptor.getModuleName(), this.wlsEjbJarDescriptor.getInputStream(), this.getEjbJarBean(), null, false);
    }

    public WeblogicEjbJarBean parseEditableWeblogicEjbJarBean() throws IOException, XMLStreamException {
        this.isWritable = true;
        WeblogicEjbJarBean weblogicEjbJarBean = this.parseWeblogicEjbJarBean();
        this.isWritable = false;
        return weblogicEjbJarBean;
    }

    public AbstractDescriptorLoader2 getEjbDescriptorLoader() {
        return this.ejbJarDescriptor;
    }

    public AbstractDescriptorLoader2 getWlsEjbDescriptorLoader() {
        return this.wlsEjbJarDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        if (stringArray.length < 1) {
            EjbJarDescriptor.usage();
        }
        if (stringArray[0].lastIndexOf("create") > -1) {
            object2 = new DescriptorManager();
            object = object2.createDescriptorRoot(EjbJarBean.class);
            object.toXML((OutputStream)System.out);
            System.out.println("\n\n\n");
            object = object2.createDescriptorRoot(WeblogicEjbJarBean.class);
            object.toXML((OutputStream)System.out);
            System.exit(0);
        }
        try {
            object2 = stringArray[0];
            object = new File((String)object2);
            if (((File)object).getName().endsWith(".jar")) {
                JarFile jarFile = new JarFile((String)object2);
                VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
                System.out.println("\n\n... getting EjbJarBean:");
                EjbJarBean ejbJarBean = new EjbJarDescriptor(virtualJarFile, null, null).getEjbJarBean();
                ((DescriptorBean)ejbJarBean).getDescriptor().toXML((OutputStream)System.out);
                System.out.println("\n\n... getting WeblogicEjbBean:");
                WeblogicEjbJarBean weblogicEjbJarBean = new EjbJarDescriptor(virtualJarFile, null, null).getWeblogicEjbJarBean();
                ((DescriptorBean)weblogicEjbJarBean).getDescriptor().toXML((OutputStream)System.out);
            } else if (((File)object).getPath().endsWith("weblogic-ejb-jar.xml")) {
                File file;
                System.out.println("\n\n... getting WeblogicEjbBean:");
                WeblogicEjbJarBean weblogicEjbJarBean = new EjbJarDescriptor((File)object, null, null).getWeblogicEjbJarBean();
                ((DescriptorBean)weblogicEjbJarBean).getDescriptor().toXML((OutputStream)System.out);
                if (stringArray.length > 1 && (file = new File(stringArray[1])).getPath().endsWith("plan.xml")) {
                    System.out.println("\n\n... plan:");
                    DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file);
                    DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                    ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                    if (stringArray.length > 2) {
                        EjbJarDescriptor ejbJarDescriptor = new EjbJarDescriptor(null, (File)object, new File(deploymentPlanBean.getConfigRoot()), deploymentPlanBean, stringArray[2]);
                        System.out.println("\n\n... plan merged:");
                        ((DescriptorBean)ejbJarDescriptor.getWeblogicEjbJarBean()).getDescriptor().toXML((OutputStream)System.out);
                    } else {
                        System.out.println("\n\nNO MODULE NAME\n\nusage: java weblogic.ejb20.deployer.EjbJarDescriptor weblogic-ejb-jar.xml plan.xml module-name");
                    }
                }
            } else {
                Object object3;
                Object object4;
                DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader;
                File file;
                if (((File)object).getPath().endsWith("ejb-jar.xml")) {
                    File file2 = file = stringArray.length == 2 ? new File(stringArray[1]) : null;
                    if (file != null && file.getPath().endsWith("weblogic-ejb-jar.xml")) {
                        System.out.println("\n\n... getting EjbJarBean:");
                        deploymentPlanDescriptorLoader = null;
                        object4 = new EjbJarDescriptor((File)object, file, null, (DeploymentPlanBean)deploymentPlanDescriptorLoader, null);
                        object3 = ((EjbJarDescriptor)object4).getEjbJarBean();
                        ((DescriptorBean)object3).getDescriptor().toXML((OutputStream)System.out);
                        System.out.println("\n\n... getting WlsEjbJarBean:");
                        WeblogicEjbJarBean weblogicEjbJarBean = ((EjbJarDescriptor)object4).getWeblogicEjbJarBean();
                        ((DescriptorBean)weblogicEjbJarBean).getDescriptor().toXML((OutputStream)System.out);
                    } else {
                        System.out.println("\n\n... getting EjbJarBean:");
                        deploymentPlanDescriptorLoader = new EjbJarDescriptor((File)object, null, null).getEjbJarBean();
                        ((DescriptorBean)deploymentPlanDescriptorLoader).getDescriptor().toXML((OutputStream)System.out);
                    }
                }
                if (stringArray.length == 3) {
                    file = new File(stringArray[1]);
                    deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file);
                    object4 = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                    object3 = new EjbJarDescriptor((File)object, null, null, (DeploymentPlanBean)object4, stringArray[2]);
                    System.out.println("\n\n... plan merged:");
                    ((DescriptorBean)((EjbJarDescriptor)object3).getEjbJarBean()).getDescriptor().toXML((OutputStream)System.out);
                } else {
                    System.out.println("\n\n... neither ejb-jar nor weblogic-ejb-jar xml specified");
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("\n\n printing problem");
            System.out.println(throwable.toString());
            System.out.println(throwable.getMessage());
            System.out.println(throwable.getCause());
            throwable.printStackTrace();
        }
    }

    private static void usage() {
        System.err.println("usage: java weblogic.ejb20.deployer.EjbJarDescriptor <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.ejb20.deployer.EjbJarDescriptor jar or altDD file name ");
        System.exit(0);
    }

    private class MyWlsEjbJarDescriptor
    extends AbstractDescriptorLoader2 {
        MyEjbJarDescriptor ejbJarDescriptor;

        MyWlsEjbJarDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, MyEjbJarDescriptor myEjbJarDescriptor) {
            super(virtualJarFile, file, deploymentPlanBean, string, EjbJarDescriptor.WEBLOGIC_DD);
            this.ejbJarDescriptor = myEjbJarDescriptor;
        }

        MyWlsEjbJarDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, MyEjbJarDescriptor myEjbJarDescriptor) {
            super(file, file2, deploymentPlanBean, string, EjbJarDescriptor.WEBLOGIC_DD);
            this.ejbJarDescriptor = myEjbJarDescriptor;
        }

        MyWlsEjbJarDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            this(descriptorManager, genericClassLoader, null, null, null);
        }

        MyWlsEjbJarDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, EjbJarDescriptor.WEBLOGIC_DD);
        }

        public String getDocumentURI() {
            return EjbJarDescriptor.WEBLOGIC_DD;
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new WeblogicEjbJarReader(inputStream, this);
        }

        protected DescriptorManager getDescriptorManager() {
            if (EjbJarDescriptor.this.isWritable) {
                return EjbJarDescriptor.this.edm;
            }
            return super.getDescriptorManager();
        }
    }

    public static class MyEjbJarDescriptor
    extends AbstractDescriptorLoader2 {
        private boolean isWritable = false;
        private EditableDescriptorManager edm = new EditableDescriptorManager();

        MyEjbJarDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, EjbJarDescriptor.STANDARD_DD);
        }

        public MyEjbJarDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string2, EjbJarDescriptor.STANDARD_DD);
        }

        MyEjbJarDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            this(descriptorManager, genericClassLoader, null, null, null, EjbJarDescriptor.STANDARD_DD);
        }

        MyEjbJarDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, EjbJarDescriptor.STANDARD_DD);
        }

        public String getDocumentURI() {
            return EjbJarDescriptor.STANDARD_DD;
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new EjbJarReader(inputStream, this);
        }

        protected DescriptorManager getDescriptorManager() {
            if (this.isWritable) {
                return this.edm;
            }
            return super.getDescriptorManager();
        }

        protected DescriptorBean loadEditableDescriptorBean() throws IOException, XMLStreamException {
            this.isWritable = true;
            DescriptorBean descriptorBean = this.loadDescriptorBean();
            this.isWritable = false;
            return descriptorBean;
        }
    }
}

