/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.ReaderEvent2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.j2ee.OldDescriptorCompatibility;

public final class EjbJarReader
extends VersionMunger {
    private boolean doneVersion = false;
    private boolean inIcon = false;
    private boolean isEJB11 = false;
    private boolean isEJB20 = false;
    private boolean inEnvEntryValue = false;
    private boolean inEjbName = false;
    private boolean inEjbLink = false;
    private boolean inActivationConfig = false;
    private boolean inSecurity = false;
    private boolean inQueryMethod = false;
    private boolean inMethodIntf = false;
    private static final Map jmsNameConversion = new HashMap(4);

    public EjbJarReader(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        super(inputStream, abstractDescriptorLoader2, "weblogic.j2ee.descriptor.EjbJarBeanImpl$SchemaHelper2");
    }

    private boolean isIcon(String string) {
        return "small-icon".equals(string) || "large-icon".equals(string);
    }

    private boolean isSecurity(String string) {
        return "security-role-ref".equals(string) || "security-identity".equals(string);
    }

    public String getDtdNamespaceURI() {
        return "http://java.sun.com/xml/ns/javaee";
    }

    public void initDtdText(String string) {
        if (string.lastIndexOf("DTD Enterprise JavaBeans 1.1") > 0) {
            this.isEJB11 = true;
        } else if (string.lastIndexOf("DTD Enterprise JavaBeans 2.0") > 0) {
            this.isEJB20 = true;
        }
    }

    private boolean needsCMPVersion(String string) {
        if (this.isEJB11 && !this.doneVersion && "cmp-field".equals(string)) {
            this.doneVersion = true;
            return true;
        }
        return false;
    }

    private VersionMunger.Continuation startIcon(String string) {
        this.currentEvent.discard();
        this.inIcon = true;
        this.forceSkipParent = true;
        this.pushStartElement("icon");
        this.pushStartElementWithStackAsParent(string);
        return CONTINUE;
    }

    private VersionMunger.Continuation continueIcon(String string) {
        this.currentEvent.discard();
        this.pushStartElementWithStackAsParent(string);
        return CONTINUE;
    }

    private VersionMunger.Continuation endIcon(String string) {
        this.inIcon = false;
        this.pushEndElement("icon");
        this.forceSkipParent = false;
        return this.USE_BUFFER;
    }

    private VersionMunger.Continuation cmp11Version(String string) {
        this.pushStartElement("cmp-version");
        this.pushCharacters("1.x".toCharArray());
        this.pushEndElement("cmp-version");
        return this.USE_BUFFER;
    }

    private boolean isJMSProperty(String string) {
        return jmsNameConversion.containsKey(string);
    }

    private String convertJMSName(String string) {
        String string2 = (String)jmsNameConversion.get(string);
        return string2 == null ? string : string2;
    }

    private VersionMunger.Continuation startJMSProperty(String string) {
        if (!this.inActivationConfig) {
            this.forceSkipParent = true;
            this.pushStartElement("activation-config");
            this.inActivationConfig = true;
        }
        this.pushStartElementWithStackAsParent("activation-config-property");
        this.pushStartElementWithStackAsParent("activation-config-property-name");
        this.pushCharacters(this.convertJMSName(string).toCharArray());
        this.pushEndElement("activation-config-property-name");
        this.pushStartElementWithStackAsParent("activation-config-property-value");
        this.currentEvent.discard();
        return this.USE_BUFFER;
    }

    private VersionMunger.Continuation endActivationConfig() {
        return this.endActivationConfig(null);
    }

    private VersionMunger.Continuation endActivationConfig(String string) {
        this.inActivationConfig = false;
        this.forceSkipParent = false;
        this.pushEndElement("activation-config");
        return this.USE_BUFFER;
    }

    public VersionMunger.Continuation onStartElement(String string) {
        if ("query-method".equals(string)) {
            this.inQueryMethod = true;
        }
        if (this.inQueryMethod && "method-intf".equals(string)) {
            this.inMethodIntf = true;
            return this.SKIP;
        }
        if ("ejb-name".equals(string)) {
            this.doneVersion = false;
        }
        if (this.isIcon(string)) {
            if (!this.inIcon) {
                return this.startIcon(string);
            }
            return this.continueIcon(string);
        }
        if (this.inIcon) {
            return this.endIcon(string);
        }
        if (this.needsCMPVersion(string)) {
            return this.cmp11Version(string);
        }
        if ("message-driven-destination".equals(string)) {
            return this.SKIP;
        }
        if (this.isJMSProperty(string)) {
            return this.startJMSProperty(string);
        }
        if (this.inActivationConfig) {
            return this.endActivationConfig(string);
        }
        if ("env-entry-value".equals(string)) {
            this.inEnvEntryValue = true;
        }
        if ("ejb-name".equals(string)) {
            this.inEjbName = true;
        }
        if ("ejb-link".equals(string)) {
            this.inEjbLink = true;
        }
        return CONTINUE;
    }

    protected VersionMunger.Continuation onCharacters(String string) {
        if (this.inMethodIntf) {
            return this.SKIP;
        }
        if (this.currentEvent.isDiscarded() && this.stack.size() > 0) {
            ReaderEvent2 readerEvent2 = (ReaderEvent2)this.stack.peek();
            readerEvent2.getReaderEventInfo().setCharacters(string.toCharArray());
        }
        if (this.inEnvEntryValue && string != null && string.length() > 0 && (this.hasDTD() || this.isOldSchema())) {
            this.currentEvent.getReaderEventInfo().setCharacters(string.trim().toCharArray());
        }
        if (this.inEjbName || this.inEjbLink) {
            this.replaceSlashWithPeriod(this.inEjbLink);
        }
        return CONTINUE;
    }

    public VersionMunger.Continuation onEndElement(String string) {
        if (this.inQueryMethod) {
            if ("query-method".equals(string)) {
                this.inQueryMethod = false;
            } else if ("method-intf".equals(string)) {
                this.inMethodIntf = false;
                return this.SKIP;
            }
        }
        if ("message-driven-destination".equals(string)) {
            return this.SKIP;
        }
        if (this.isJMSProperty(string)) {
            this.pushEndElement("activation-config-property-value");
            this.pushEndElement("activation-config-property");
            return this.USE_BUFFER;
        }
        if (this.inActivationConfig) {
            this.inActivationConfig = false;
            this.forceSkipParent = false;
            this.pushEndElement("activation-config");
            this.pushEndElement(string);
            return this.USE_BUFFER;
        }
        if (this.isIcon(string)) {
            this.pushEndElement(string);
        }
        if ("env-entry-value".equals(string)) {
            this.inEnvEntryValue = false;
        }
        if ("ejb-name".equals(string)) {
            this.inEjbName = false;
        }
        if ("ejb-link".equals(string)) {
            this.inEjbLink = false;
        }
        return CONTINUE;
    }

    public VersionMunger.Continuation onEndDocument() {
        if (this.inActivationConfig) {
            this.pushEndElement("activation-config");
            return this.USE_BUFFER;
        }
        this.orderChildren();
        return CONTINUE;
    }

    protected String getLatestSchemaVersion() {
        return "3.0";
    }

    protected boolean isOldSchema() {
        String string = this.getNamespaceURI();
        return string != null && string.indexOf("j2ee") != -1;
    }

    protected void transformOldSchema() {
        if (this.currentEvent.getElementName().equals("ejb-jar")) {
            int n = this.currentEvent.getReaderEventInfo().getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = this.currentEvent.getReaderEventInfo().getAttributeLocalName(i);
                String string2 = this.currentEvent.getReaderEventInfo().getAttributeValue(i);
                if (!string2.equals("2.1")) continue;
                this.versionInfo = string2;
                this.currentEvent.getReaderEventInfo().setAttributeValue("3.0", i);
            }
            this.transformNamespace("http://java.sun.com/xml/ns/javaee", this.currentEvent, "http://java.sun.com/xml/ns/j2ee");
        }
        this.tranformedNamespace = "http://java.sun.com/xml/ns/javaee";
    }

    public String getText() {
        String string;
        String string2;
        if (this.debug) {
            System.out.println("** EjbJarReader.getText() " + this.currentEvent.getElementName());
        }
        if ((string2 = super.getText().trim()) != null && (string = OldDescriptorCompatibility.canonicalize(this.currentEvent.getElementName(), string2)) != null) {
            if (this.debug) {
                System.out.println("txt = " + string2 + ", replaced = " + string);
            }
            this.currentEvent.getReaderEventInfo().setCharacters(string.toCharArray());
            return string;
        }
        return string2;
    }

    public char[] getTextCharacters() {
        String string;
        char[] cArray;
        if (this.debug) {
            System.out.println("** EjbJarReader.getTextCharacters()" + this.currentEvent.getElementName());
        }
        if ((cArray = super.getTextCharacters()) != null && (string = OldDescriptorCompatibility.canonicalize(this.currentEvent.getElementName(), new String(cArray))) != null) {
            System.arraycopy(string.toCharArray(), 0, cArray, 0, string.length());
            if (this.debug) {
                System.out.println("chars = " + new String(cArray) + ", replaced = " + string);
            }
            this.currentEvent.getReaderEventInfo().setCharacters(cArray);
        }
        return cArray;
    }

    public String getElementText() throws XMLStreamException {
        String string;
        String string2;
        if (this.debug) {
            System.out.println("** EjbJarReader.getElementText()" + this.currentEvent.getElementName());
        }
        if ((string2 = super.getElementText()) != null && (string = OldDescriptorCompatibility.canonicalize(this.currentEvent.getElementName(), string2)) != null) {
            if (this.debug) {
                System.out.println("txt = " + string2 + ", replaced = " + string);
            }
            return string;
        }
        return string2;
    }

    public boolean supportsValidation() {
        return true;
    }

    static {
        jmsNameConversion.put("acknowledge-mode", "acknowledgeMode");
        jmsNameConversion.put("message-selector", "messageSelector");
        jmsNameConversion.put("destination-type", "destinationType");
        jmsNameConversion.put("subscription-durability", "subscriptionDurability");
    }
}

