/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import weblogic.cluster.GroupMessage;
import weblogic.ejb.container.deployer.EJBModule;
import weblogic.rmi.spi.HostID;

public class InvalidationMessage
implements GroupMessage {
    private String applicationName;
    private String componentName;
    private String ejbName;
    private Object pk;
    private Collection pks;

    public String toString() {
        return "[InvalidationMessage]: applicationName: " + this.applicationName + " componentName: " + this.componentName + " ejbName: " + this.ejbName + " pk: " + this.pk + " pks: " + this.pks;
    }

    public InvalidationMessage() {
    }

    public InvalidationMessage(String string, String string2, String string3) {
        this.applicationName = string;
        this.componentName = string2;
        this.ejbName = string3;
        this.pk = null;
        this.pks = null;
    }

    public InvalidationMessage(String string, String string2, String string3, Object object) {
        this.applicationName = string;
        this.componentName = string2;
        this.ejbName = string3;
        this.pk = object;
        this.pks = null;
    }

    public InvalidationMessage(String string, String string2, String string3, Collection collection) {
        this.applicationName = string;
        this.componentName = string2;
        this.ejbName = string3;
        this.pk = null;
        this.pks = collection;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public Collection getPrimaryKeys() {
        return this.pks;
    }

    public void execute(HostID hostID) {
        EJBModule eJBModule = EJBModule.findModule(this.applicationName, this.componentName);
        if (eJBModule != null) {
            eJBModule.invalidate(this);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.applicationName);
        objectOutput.writeObject(this.componentName);
        objectOutput.writeObject(this.ejbName);
        objectOutput.writeObject(this.pk);
        objectOutput.writeObject(this.pks);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.applicationName = (String)objectInput.readObject();
        this.componentName = (String)objectInput.readObject();
        this.ejbName = (String)objectInput.readObject();
        this.pk = objectInput.readObject();
        this.pks = (Collection)objectInput.readObject();
    }
}

