/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.cmp.rdbms.finders;

import java.util.Collection;
import java.util.List;
import org.xml.sax.SAXParseException;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLToken;
import weblogic.j2ee.validation.IDescriptorError;
import weblogic.j2ee.validation.IDescriptorErrorInfo;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.NestedException;
import weblogic.utils.StackTraceUtils;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public class EJBQLCompilerException
extends Exception
implements IDescriptorError {
    private static final long serialVersionUID = 5756198563339201332L;
    private IDescriptorErrorInfo errorInfo;
    private ErrorCollectionException errorCollectionEx;
    private boolean ejbqlRewritten = false;
    private String ejbqlRewrittenReasonsString = "Unknown ?";
    private String originalEjbqlText;
    private List ejbqlTokenList;
    private String header = "";
    private String errorIndicatorLeft = " =>> ";
    private String errorIndicatorRight = " <<=  ";
    private static Class[] bugs = new Class[]{Error.class, NullPointerException.class, AssertionError.class};

    public EJBQLCompilerException(ErrorCollectionException errorCollectionException, boolean bl, String string, String string2, List list, String string3, IDescriptorErrorInfo iDescriptorErrorInfo) {
        this.errorCollectionEx = errorCollectionException;
        this.ejbqlTokenList = list;
        this.originalEjbqlText = string2;
        this.ejbqlRewrittenReasonsString = string;
        this.ejbqlRewritten = bl;
        this.errorInfo = iDescriptorErrorInfo;
        if (string3 != null) {
            this.header = string3;
        }
    }

    public ErrorCollectionException getErrorCollectionException() {
        return this.errorCollectionEx;
    }

    public Collection getExceptions() {
        return this.getErrorCollectionException().getExceptions();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getErrorHeader()).append("\n\n");
        if (this.ejbqlRewritten) {
            stringBuffer.append(this.getEjbqlHasBeenRewrittenMessage()).append("\n\n");
            stringBuffer.append("    ").append(this.originalEjbqlText).append("\n\n\n\n");
            stringBuffer.append(" The rewritten query is:\n\n");
        }
        stringBuffer.append(this.getDefaultEjbqlString()).append("\n\n");
        stringBuffer.append(this.getExceptionMessagesOnly());
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.toString();
    }

    public List getEjbqlTokenList() {
        return this.ejbqlTokenList;
    }

    public String getErrorHeader() {
        return this.header;
    }

    public String getEjbqlHasBeenRewrittenMessage() {
        Loggable loggable = EJBLogger.logEjbqlHasBeenRewrittenLoggable((String)this.ejbqlRewrittenReasonsString);
        return loggable.getMessage();
    }

    public boolean isEmpty() {
        return this.getErrorCollectionException().isEmpty();
    }

    public String getExceptionMessagesOnly() {
        StringBuffer stringBuffer = new StringBuffer();
        if (super.getMessage() != null) {
            stringBuffer.append(super.getMessage());
        }
        for (Throwable throwable : this.getExceptions()) {
            String string = this.formatExceptionMessage(throwable);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String formatExceptionMessage(Throwable throwable) {
        boolean bl;
        NestedException nestedException;
        String string = throwable.getMessage();
        StringBuffer stringBuffer = new StringBuffer();
        if (throwable instanceof ClassNotFoundException) {
            stringBuffer.append("Unable to load class: " + string + "\n");
        } else if (throwable instanceof XMLParsingException) {
            nestedException = (XMLParsingException)((Object)throwable);
            Throwable throwable2 = nestedException.getNestedException();
            if (throwable2 instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable2;
                stringBuffer.append("Error parsing '" + ((XMLParsingException)nestedException).getFileName() + "' line " + sAXParseException.getLineNumber() + ": " + string + "\n");
            } else {
                stringBuffer.append("Error parsing '" + ((XMLParsingException)nestedException).getFileName() + "': " + string + "\n");
            }
        } else if (throwable instanceof XMLProcessingException) {
            nestedException = (XMLProcessingException)((Object)throwable);
            stringBuffer.append("Error processing '" + ((XMLProcessingException)nestedException).getFileName() + "': " + string + "\n");
        } else if (string != null) {
            stringBuffer.append(string + "\n");
        }
        boolean bl2 = bl = EJBDebugService.compilationLogger.isDebugEnabled() || EJBDebugService.deploymentLogger.isDebugEnabled();
        if (bl || string == null || this.isBug(throwable)) {
            stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
        return stringBuffer.toString();
    }

    private boolean isBug(Throwable throwable) {
        for (int i = 0; i < bugs.length; ++i) {
            if (!bugs[i].isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    public String getDefaultEjbqlString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (EJBQLToken eJBQLToken : this.ejbqlTokenList) {
            if (eJBQLToken.getHadException()) {
                stringBuffer.append(this.errorIndicatorLeft);
                stringBuffer.append(eJBQLToken.getTokenText());
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer.append(this.errorIndicatorRight);
                continue;
            }
            stringBuffer.append(eJBQLToken.getTokenText());
        }
        return stringBuffer.toString();
    }

    public boolean hasErrorInfo() {
        return this.errorInfo != null;
    }

    public IDescriptorErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setDescriptorErrorInfo(IDescriptorErrorInfo iDescriptorErrorInfo) {
        this.errorInfo = iDescriptorErrorInfo;
    }
}

