/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.cmp.rdbms.finders;

import weblogic.ejb.container.EJBTextTextFormatter;
import weblogic.j2ee.validation.IDescriptorError;
import weblogic.j2ee.validation.IDescriptorErrorInfo;
import weblogic.utils.PlatformConstants;

public final class InvalidFinderException
extends Exception
implements PlatformConstants,
IDescriptorError {
    private static final long serialVersionUID = 110338118255488893L;
    public static final int NULL_NAME = 1;
    public static final int EMPTY_NAME = 2;
    public static final int INVALID_NAME_PREFIX = 3;
    public static final int NULL_QUERY = 4;
    public static final int INVALID_EXPRESSION_NUMBER = 5;
    public static final int EMPTY_EXPRESSION_TEXT = 6;
    public static final int EMPTY_EXPRESSION_TYPE = 7;
    public static final int INVALID_QUERY = 8;
    private int errorType = 0;
    private String failedString = null;
    private IDescriptorErrorInfo errorInfo;

    public InvalidFinderException(int n, String string) {
        this.errorType = n;
        this.failedString = string;
    }

    public InvalidFinderException(int n, String string, IDescriptorErrorInfo iDescriptorErrorInfo) {
        this(n, string);
        this.errorInfo = iDescriptorErrorInfo;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public String getFailedString() {
        return this.failedString;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
        switch (this.errorType) {
            case 1: {
                stringBuffer.append(eJBTextTextFormatter.nullName(this.failedString));
                break;
            }
            case 2: {
                stringBuffer.append(eJBTextTextFormatter.emptyName(this.failedString));
                break;
            }
            case 3: {
                stringBuffer.append(eJBTextTextFormatter.invalidNamePrefix(this.failedString));
                break;
            }
            case 4: {
                stringBuffer.append(eJBTextTextFormatter.nullQuery(this.failedString));
                break;
            }
            case 5: {
                stringBuffer.append(eJBTextTextFormatter.invalidExpressionNumber(this.failedString));
                break;
            }
            case 6: {
                stringBuffer.append(eJBTextTextFormatter.emptyExpressionText(this.failedString));
                break;
            }
            case 7: {
                stringBuffer.append(eJBTextTextFormatter.emptyExpressionType(this.failedString));
                break;
            }
            case 8: {
                stringBuffer.append(eJBTextTextFormatter.invalidQuery(this.failedString));
            }
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public boolean hasErrorInfo() {
        return this.errorInfo != null;
    }

    public IDescriptorErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setDescriptorErrorInfo(IDescriptorErrorInfo iDescriptorErrorInfo) {
        this.errorInfo = iDescriptorErrorInfo;
    }
}

