/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import java.io.Serializable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.spi.PortableReplaceable;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;

public final class EJBMetaDataImpl
implements Serializable,
EJBMetaData,
PortableReplaceable {
    private static final long serialVersionUID = -7427414006230547782L;
    private final EJBHome ejbHome;
    private final String homeInterfaceClassName;
    private final String primaryKeyClassName;
    private final String remoteInterfaceClassName;
    private transient Class homeInterfaceClass;
    private transient Class primaryKeyClass;
    private transient Class remoteInterfaceClass;
    private final boolean isSession;
    private final boolean isStatelessSession;

    public EJBMetaDataImpl(EJBHome eJBHome, Class clazz, Class clazz2, Class clazz3, boolean bl, boolean bl2) {
        if (bl && clazz3 != null) {
            throw new AssertionError("PK class should be null for session beans!");
        }
        this.ejbHome = eJBHome;
        this.homeInterfaceClass = clazz;
        this.remoteInterfaceClass = clazz2;
        this.primaryKeyClass = clazz3;
        this.isSession = bl;
        this.isStatelessSession = bl2;
        this.homeInterfaceClassName = clazz.getName();
        this.remoteInterfaceClassName = clazz2.getName();
        this.primaryKeyClassName = clazz3 == null ? null : clazz3.getName();
    }

    public EJBHome getEJBHome() {
        return this.ejbHome;
    }

    public Class getHomeInterfaceClass() {
        if (this.homeInterfaceClass == null) {
            try {
                this.homeInterfaceClass = this.ejbHome.getClass().getClassLoader().loadClass(this.homeInterfaceClassName);
            }
            catch (Exception exception) {
                throw new AssertionError("Unable to load home class: " + exception);
            }
        }
        return this.homeInterfaceClass;
    }

    public Class getPrimaryKeyClass() {
        if (this.isSession) {
            Loggable loggable = EJBLogger.logillegalAttemptToInvokeGetPrimaryKeyClassLoggable();
            throw new RuntimeException(loggable.getMessage());
        }
        if (this.primaryKeyClass == null) {
            try {
                this.primaryKeyClass = this.ejbHome.getClass().getClassLoader().loadClass(this.primaryKeyClassName);
            }
            catch (Exception exception) {
                throw new AssertionError("Unable to load pk class: " + exception);
            }
        }
        return this.primaryKeyClass;
    }

    public Class getRemoteInterfaceClass() {
        if (this.remoteInterfaceClass == null) {
            try {
                this.remoteInterfaceClass = this.ejbHome.getClass().getClassLoader().loadClass(this.remoteInterfaceClassName);
            }
            catch (Exception exception) {
                throw new AssertionError("Unable to load remote interface: " + exception);
            }
        }
        return this.remoteInterfaceClass;
    }

    public boolean isSession() {
        return this.isSession;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSession;
    }
}

