/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.omg.CORBA.MARSHAL;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.ReplacerObjectInputStream;
import weblogic.common.internal.ReplacerObjectOutputStream;
import weblogic.ejb.spi.PortableReplaceable;
import weblogic.ejb20.internal.HomeHandleImpl;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.io.Replacer;

public final class HandleImpl
implements Handle,
Externalizable,
PortableReplaceable {
    private static final long serialVersionUID = 5484839489411820318L;
    private transient EJBObject ejbObject = null;
    private HomeHandleImpl homeHandle = null;
    private Object primaryKey = null;
    private Object stubInfo = null;

    public HandleImpl() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.homeHandle.writeExternal(objectOutput);
        objectOutput.writeObject(this.primaryKey);
        if (objectOutput instanceof WLObjectOutput) {
            objectOutput.writeObject(this.stubInfo);
        } else {
            ReplacerObjectOutputStream replacerObjectOutputStream = new ReplacerObjectOutputStream((OutputStream)((Object)objectOutput), RemoteObjectReplacer.getReplacer());
            replacerObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
            if (this.stubInfo != null) {
                replacerObjectOutputStream.writeObject(this.stubInfo);
            } else {
                objectOutput.writeObject(this.stubInfo);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.homeHandle = new HomeHandleImpl();
        this.homeHandle.readExternal(objectInput);
        this.primaryKey = objectInput.readObject();
        try {
            if (objectInput instanceof WLObjectInput) {
                this.stubInfo = objectInput.readObject();
            } else {
                Replacer replacer = RemoteObjectReplacer.getReplacer();
                ReplacerObjectInputStream replacerObjectInputStream = new ReplacerObjectInputStream((InputStream)((Object)objectInput), replacer, null);
                this.stubInfo = replacerObjectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
        }
        catch (MARSHAL mARSHAL) {
            // empty catch block
        }
    }

    public String toString() {
        return this.homeHandle + "#" + this.primaryKey;
    }

    public HandleImpl(EJBObject eJBObject) throws RemoteException {
        this.ejbObject = eJBObject;
        EJBHome eJBHome = eJBObject.getEJBHome();
        assert (eJBHome.getEJBMetaData().isStatelessSession());
        this.primaryKey = null;
        this.homeHandle = (HomeHandleImpl)eJBHome.getHomeHandle();
    }

    public HandleImpl(EJBObject eJBObject, Object object) throws RemoteException {
        assert (eJBObject != null);
        assert (object != null);
        this.ejbObject = eJBObject;
        EJBHome eJBHome = eJBObject.getEJBHome();
        assert (!eJBHome.getEJBMetaData().isStatelessSession());
        this.primaryKey = object;
        this.homeHandle = (HomeHandleImpl)eJBHome.getHomeHandle();
        if (eJBHome.getEJBMetaData().isSession()) {
            this.stubInfo = eJBObject;
        }
    }

    private EJBObject allocateEO(EJBHome eJBHome, Class[] classArray, Object[] objectArray) throws RemoteException {
        Class<?> clazz = eJBHome.getClass();
        try {
            Method method = clazz.getMethod("allocateEJBObject", classArray);
            return (EJBObject)method.invoke((Object)eJBHome, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Class " + clazz.getName() + " did not have allocateEO method"));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RemoteException) {
                throw (RemoteException)throwable;
            }
            throw new RemoteException("Exception re-establishing handle", throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RemoteException("Exception re-establishing handle", illegalAccessException);
        }
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.ejbObject != null) {
            return this.ejbObject;
        }
        if (this.primaryKey == null) {
            EJBHome eJBHome = this.homeHandle.getEJBHome();
            assert (eJBHome.getEJBMetaData().isStatelessSession());
            return this.allocateEO(eJBHome, null, null);
        }
        EJBObject eJBObject = null;
        if (this.stubInfo != null) {
            eJBObject = (EJBObject)this.stubInfo;
        } else {
            EJBHome eJBHome = this.homeHandle.getEJBHome();
            assert (!eJBHome.getEJBMetaData().isStatelessSession());
            eJBObject = this.allocateEO(eJBHome, new Class[]{Object.class}, new Object[]{this.primaryKey});
        }
        return eJBObject;
    }
}

