/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.internal.URLDelegate;
import weblogic.ejb.spi.PortableReplaceable;
import weblogic.protocol.ChannelHelperBase;
import weblogic.rmi.extensions.PortableRemoteObject;

public final class HomeHandleImpl
implements HomeHandle,
Externalizable,
PortableReplaceable {
    private static final long serialVersionUID = -4517252809192149290L;
    private String serverURL;
    private Name jndiName;
    private transient EJBHome home = null;
    private transient URLDelegate urlDelegate = null;

    public HomeHandleImpl() {
    }

    public HomeHandleImpl(EJBHome eJBHome, Name name, URLDelegate uRLDelegate) {
        this.home = eJBHome;
        this.jndiName = name;
        this.urlDelegate = uRLDelegate;
    }

    public String toString() {
        return this.jndiName + ":" + this.serverURL;
    }

    public EJBHome getEJBHome() throws RemoteException {
        if (this.home == null) {
            String string = this.serverURL;
            if (string == null) {
                string = ChannelHelperBase.getDefaultURL();
            }
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                hashtable.put("java.naming.provider.url", string);
                InitialContext initialContext = new InitialContext(hashtable);
                this.home = (EJBHome)PortableRemoteObject.narrow((Object)initialContext.lookup(this.jndiName), EJBHome.class);
                assert (this.home != null);
            }
            catch (ClassCastException classCastException) {
                EJBLogger.logStackTrace((Throwable)classCastException);
            }
            catch (NamingException namingException) {
                throw new NoSuchObjectException("Unable to locate EJBHome: '" + this.jndiName + "' on server: '" + string);
            }
        }
        return this.home;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.serverURL == null) {
            objectOutput.writeObject(this.urlDelegate.getURL(objectOutput));
        } else {
            objectOutput.writeObject(this.serverURL);
        }
        objectOutput.writeObject(this.jndiName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.serverURL = (String)objectInput.readObject();
        this.jndiName = (Name)objectInput.readObject();
        this.urlDelegate = URLDelegate.CHANNEL_URL_DELEGATE;
    }
}

