/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb20.interfaces.LocalHandle;
import weblogic.utils.AssertionError;

public final class LocalHandleImpl
implements LocalHandle,
Serializable {
    private static final long serialVersionUID = 3817127104258844908L;
    private transient EJBLocalObject ejbObject = null;
    private EJBLocalHome home = null;
    private Object primaryKey = null;
    private static final boolean debug = false;

    public LocalHandleImpl() {
    }

    public LocalHandleImpl(EJBLocalObject eJBLocalObject) {
        this.ejbObject = eJBLocalObject;
        this.home = eJBLocalObject.getEJBLocalHome();
        this.primaryKey = null;
    }

    public LocalHandleImpl(EJBLocalObject eJBLocalObject, Object object) {
        this.ejbObject = eJBLocalObject;
        this.home = eJBLocalObject.getEJBLocalHome();
        this.primaryKey = object;
    }

    private EJBLocalObject allocateELO(Class[] classArray, Object[] objectArray) {
        Class<?> clazz = this.home.getClass();
        try {
            Method method = clazz.getMethod("allocateELO", classArray);
            return (EJBLocalObject)method.invoke((Object)this.home, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EJBRuntimeUtils.throwEJBException("Exception re-establishing handle: " + clazz + " doesn't define allocatELO() method", noSuchMethodException);
            throw new AssertionError("cannot reach here");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            EJBRuntimeUtils.throwEJBException("Exception re-establishing handle", throwable);
            throw new AssertionError("cannot reach here");
        }
        catch (IllegalAccessException illegalAccessException) {
            EJBRuntimeUtils.throwEJBException("Exception re-establishing handle", illegalAccessException);
            throw new AssertionError("cannot reach here");
        }
    }

    public EJBLocalObject getEJBLocalObject() {
        if (this.ejbObject != null) {
            return this.ejbObject;
        }
        if (this.primaryKey == null) {
            return this.allocateELO(null, null);
        }
        return this.allocateELO(new Class[]{Object.class}, new Object[]{this.primaryKey});
    }
}

