/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import java.io.Serializable;
import javax.ejb.EJBLocalHome;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb20.interfaces.LocalHomeHandle;

public final class LocalHomeHandleImpl
implements LocalHomeHandle,
Serializable {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final long serialVersionUID = -4325019294372383553L;
    private Name localJNDIName;
    private transient EJBLocalHome home = null;

    public LocalHomeHandleImpl() {
    }

    public LocalHomeHandleImpl(EJBLocalHome eJBLocalHome, Name name) {
        this.home = eJBLocalHome;
        this.localJNDIName = name;
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.home == null) {
            try {
                InitialContext initialContext = new InitialContext();
                this.home = (EJBLocalHome)initialContext.lookup(this.localJNDIName);
            }
            catch (ClassCastException classCastException) {
                EJBLogger.logStackTraceAndMessage((String)classCastException.getMessage(), (Throwable)classCastException);
                EJBRuntimeUtils.throwEJBException("ClassCastException: ", classCastException);
            }
            catch (NamingException namingException) {
                EJBRuntimeUtils.throwEJBException("Unable to locate EJBLocalHome: '" + this.localJNDIName, namingException);
            }
        }
        return this.home;
    }
}

