/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.FinderException;
import weblogic.ejb.PreparedQuery;
import weblogic.ejb20.interfaces.QueryHandler;
import weblogic.ejb20.internal.WLQueryPropertiesImpl;
import weblogic.utils.StackTraceUtils;

public class PreparedQueryImpl
extends WLQueryPropertiesImpl
implements PreparedQuery,
Serializable {
    private QueryHandler handler;
    private String sql;
    private String ejbql;
    private Map arguments = new TreeMap();
    private Map flattenedArguments = new TreeMap();

    public PreparedQueryImpl(String string, QueryHandler queryHandler, Properties properties) throws FinderException {
        this.ejbql = string;
        this.handler = queryHandler;
        this.setProperties(properties);
    }

    public String getEjbql() {
        return this.ejbql;
    }

    public Collection find() throws FinderException {
        try {
            Object[] objectArray = (Object[])this.handler.executePreparedQuery(this.sql, this, this.arguments, this.flattenedArguments, false);
            this.sql = (String)objectArray[0];
            this.flattenedArguments = (Map)objectArray[1];
            this.arguments.clear();
            return (Collection)objectArray[2];
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public ResultSet execute() throws FinderException {
        try {
            Object[] objectArray = (Object[])this.handler.executePreparedQuery(this.sql, this, this.arguments, this.flattenedArguments, false);
            this.sql = (String)objectArray[0];
            this.flattenedArguments = (Map)objectArray[1];
            this.arguments.clear();
            return (ResultSet)objectArray[2];
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public void setString(int n, String string) {
        this.setParameter(n, string);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.setParameter(n, bigDecimal);
    }

    public void setBigInteger(int n, BigInteger bigInteger) {
        this.setParameter(n, bigInteger);
    }

    public void setBinary(int n, byte[] byArray) {
        this.setParameter(n, byArray);
    }

    public void setBoolean(int n, boolean bl) {
        this.setParameter(n, new Boolean(bl));
    }

    public void setByte(int n, byte by) {
        this.setParameter(n, new Byte(by));
    }

    public void setCharacter(int n, char c) {
        this.setParameter(n, new Character(c));
    }

    public void setShort(int n, short s) {
        this.setParameter(n, new Short(s));
    }

    public void setInt(int n, int n2) {
        this.setParameter(n, new Integer(n2));
    }

    public void setLong(int n, long l) {
        this.setParameter(n, new Long(l));
    }

    public void setFloat(int n, float f) {
        this.setParameter(n, new Float(f));
    }

    public void setDouble(int n, double d) {
        this.setParameter(n, new Double(d));
    }

    public void setDate(int n, Date date) {
        this.setParameter(n, date);
    }

    public void setDate(int n, java.util.Date date) {
        this.setParameter(n, date);
    }

    public void setTime(int n, Time time) {
        this.setParameter(n, time);
    }

    public void setTime(int n, java.util.Date date) {
        this.setParameter(n, date);
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.setParameter(n, timestamp);
    }

    public void setTimestamp(int n, java.util.Date date) {
        this.setParameter(n, date);
    }

    public void setCalender(int n, Calendar calendar) {
        this.setParameter(n, calendar);
    }

    public void setObject(int n, Object object) {
        this.setParameter(n, object);
    }

    private void setParameter(int n, Object object) {
        Integer n2 = new Integer(n);
        Object object2 = this.arguments.put(n2, object);
        if (object2 != null) {
            this.arguments.put(n2, object2);
            throw new RuntimeException("Attempt to set more than one value for query parameter '" + n2 + "'.  Previous value was '" + object2 + "'.");
        }
    }

    public String toString() {
        return "PreparedQueryImpl: [ \nejbql: " + this.ejbql + "\n" + "sql: " + this.sql + "\n" + "arguments: " + this.arguments + "\n" + "flattenedArguments: " + this.flattenedArguments + "\n" + "hashCode: " + this.hashCode() + "\n" + "] ";
    }
}

