/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.FinderException;
import weblogic.ejb.Query;
import weblogic.ejb20.interfaces.QueryHandler;
import weblogic.ejb20.internal.WLQueryPropertiesImpl;
import weblogic.utils.StackTraceUtils;

public class QueryImpl
extends WLQueryPropertiesImpl
implements Query,
Serializable {
    private static final long serialVersionUID = -6324059333171473291L;
    private QueryHandler handler;
    private boolean isSql = false;

    public QueryImpl(QueryHandler queryHandler) {
        this.handler = queryHandler;
    }

    public QueryImpl(QueryHandler queryHandler, boolean bl) {
        this.handler = queryHandler;
        this.isSql = bl;
    }

    public String getLanguage() {
        if (this.isSql) {
            return "SQL";
        }
        return "EJB QL";
    }

    public Collection find(String string) throws FinderException {
        try {
            return (Collection)this.handler.executeQuery(string, this, false, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public Collection find(String string, Properties properties) throws FinderException {
        this.setProperties(properties);
        try {
            return (Collection)this.handler.executeQuery(string, this, false, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public ResultSet execute(String string) throws FinderException {
        try {
            return (ResultSet)this.handler.executeQuery(string, this, true, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public ResultSet execute(String string, Properties properties) throws FinderException {
        this.setProperties(properties);
        try {
            return (ResultSet)this.handler.executeQuery(string, this, true, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }
}

