/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.portable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import weblogic.ejb20.portable.PortableHomeHandleImpl;

public final class PortableEJBMetaDataImpl
implements EJBMetaData,
Serializable {
    static final long serialVersionUID = 2161422698991859090L;
    private Class keyClass;
    private Class homeClass;
    private Class remoteClass;
    private boolean isSessionBean;
    private boolean isStatelessSessionBean;
    private HomeHandle homeHandle;

    public PortableEJBMetaDataImpl(EJBMetaData eJBMetaData) {
        this.homeHandle = new PortableHomeHandleImpl(eJBMetaData.getEJBHome());
        this.isStatelessSessionBean = eJBMetaData.isStatelessSession();
        this.isSessionBean = eJBMetaData.isSession();
        this.keyClass = !this.isSessionBean ? eJBMetaData.getPrimaryKeyClass() : null;
        this.homeClass = eJBMetaData.getHomeInterfaceClass();
        this.remoteClass = eJBMetaData.getRemoteInterfaceClass();
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public EJBHome getEJBHome() {
        try {
            return this.homeHandle.getEJBHome();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Could not get ejbHome from HomeHandle " + remoteException.getMessage());
        }
    }

    public Class getPrimaryKeyClass() {
        if (this.keyClass == null) {
            throw new RuntimeException("SessionBeans do not have a primary key");
        }
        return this.keyClass;
    }

    public boolean isSession() {
        return this.isSessionBean;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSessionBean;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.isSessionBean = objectInputStream.readBoolean();
        this.isStatelessSessionBean = objectInputStream.readBoolean();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.remoteClass = classLoader.loadClass(objectInputStream.readUTF());
        this.homeClass = classLoader.loadClass(objectInputStream.readUTF());
        if (!this.isSessionBean) {
            this.keyClass = classLoader.loadClass(objectInputStream.readUTF());
        }
        this.homeHandle = (HomeHandle)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.isSessionBean);
        objectOutputStream.writeBoolean(this.isStatelessSessionBean);
        objectOutputStream.writeUTF(this.remoteClass.getName());
        objectOutputStream.writeUTF(this.homeClass.getName());
        if (!this.isSessionBean) {
            objectOutputStream.writeUTF(this.keyClass.getName());
        }
        objectOutputStream.writeObject(this.homeHandle);
    }
}

