/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.timer;

import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.TimerHelper;
import weblogic.ejb.container.interfaces.TimerIntf;
import weblogic.logging.Loggable;

public final class TimerHandleImpl
implements TimerHandle,
Serializable {
    private static final long serialVersionUID = 3158846282971285273L;
    private transient TimerIntf timer;
    private Long timerID;
    private String jarName;
    private String ejbName;

    public TimerHandleImpl(TimerIntf timerIntf, Long l, String string, String string2) {
        this.timer = timerIntf;
        this.timerID = l;
        this.jarName = string;
        this.ejbName = string2;
    }

    public Timer getTimer() {
        InitialContext initialContext;
        if (this.timer != null) {
            if (!this.timer.exists()) {
                Loggable loggable = EJBLogger.logExpiredTimerHandleLoggable();
                throw new NoSuchObjectLocalException(loggable.getMessage());
            }
            return this.timer;
        }
        TimerHelper timerHelper = null;
        try {
            initialContext = new InitialContext();
            timerHelper = (TimerHelper)initialContext.lookup("java:app/ejb/" + this.jarName + "#" + this.ejbName + "/timerHelper");
        }
        catch (NamingException namingException) {
            Loggable loggable = EJBLogger.logTimerHandleInvokedOutsideOriginalAppContextLoggable();
            throw new EJBException(loggable.getMessage());
        }
        this.timer = (TimerIntf)timerHelper.getTimer(this.timerID);
        if (this.timer != null) {
            return this.timer;
        }
        initialContext = EJBLogger.logExpiredTimerHandleLoggable();
        throw new NoSuchObjectLocalException(initialContext.getMessage());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ejbName == null ? 0 : this.ejbName.hashCode());
        n = 31 * n + (this.jarName == null ? 0 : this.jarName.hashCode());
        n = 31 * n + (this.timerID == null ? 0 : this.timerID.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TimerHandleImpl)) {
            return false;
        }
        TimerHandleImpl timerHandleImpl = (TimerHandleImpl)object;
        if (!this.ejbName.equals(timerHandleImpl.ejbName)) {
            return false;
        }
        if (!this.jarName.equals(timerHandleImpl.jarName)) {
            return false;
        }
        return this.timerID.equals(timerHandleImpl.timerID);
    }

    public String toString() {
        return "[TimerHandle] timerID: " + this.timerID + " jarName: " + this.jarName + " ejbName: " + this.ejbName;
    }
}

