/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.container.utils.DDConverter;
import weblogic.ejb.spi.EJBCFactory;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.kernel.Kernel;
import weblogic.utils.AssertionError;
import weblogic.utils.BadOptionException;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.CompilerInvoker;
import weblogic.utils.compiler.ICompilerFactory;
import weblogic.utils.compiler.Tool;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public class ejbc20
extends Tool {
    private EJBComplianceTextFormatter fmt = new EJBComplianceTextFormatter();
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final String EJBC_WORKING_DIR = "ejbcgen";
    private String sourceJarFileName;
    private String targetJarFileName;
    private File inputJar;
    private String appId;
    private EjbDescriptorBean ejbDescriptor;
    private File outputDir;
    private boolean runFromCmdLine = true;
    protected ICompilerFactory compilerFactory = null;
    private boolean doClose = true;
    private boolean createOutputJar = true;
    private VirtualJarFile myJar = null;
    private GenericClassLoader m_classLoader;
    private Class[] bugs = new Class[]{Error.class, NullPointerException.class, IndexOutOfBoundsException.class, AssertionError.class};

    public ejbc20(String[] stringArray) {
        super(stringArray);
        if (Kernel.isServer()) {
            this.runFromCmdLine = false;
        }
    }

    public void setRunFromCmdLine(boolean bl) {
        this.runFromCmdLine = bl;
    }

    public void prepare() {
        this.opts.addFlag("nodeploy", "Do not unpack jar files into the target dir.");
        this.opts.setUsageArgs("<source directory or jar file> [<target directory or jar file>]");
        this.opts.addFlag("idl", "Generate idl for remote interfaces");
        this.opts.addFlag("idlOverwrite", "Always overwrite existing IDL files");
        this.opts.addFlag("idlVerbose", "Display verbose information for IDL generation");
        this.opts.addFlag("idlNoValueTypes", "Do not generate valuetypes and methods/attributes that contain them.");
        this.opts.addFlag("idlNoAbstractInterfaces", "Do not generate abstract interfaces and methods/attributes that contain them.");
        this.opts.addFlag("idlFactories", "Generate factory methods for valuetypes.");
        this.opts.addFlag("idlVisibroker", "Generate IDL somewhat compatible with Visibroker 4.5 C++.");
        this.opts.addFlag("idlOrbix", "Generate IDL somewhat compatible with Orbix 2000 2.0 C++.");
        this.opts.addOption("idlDirectory", "dir", "Specify the directory where IDL files will be created (default : target directory or jar)");
        this.opts.addFlag("iiop", "Generate CORBA stubs.");
        this.opts.addFlag("iiopSun", "Use Sun's rmic for generating CORBA stubs.");
        this.opts.markPrivate("iiopSun");
        this.opts.addFlag("iiopTie", "Generate CORBA skeletons, uses Sun's rmic.");
        this.opts.markPrivate("iiopTie");
        this.opts.addOption("iiopDirectory", "dir", "Specify the directory where IIOP stub files will be written (default : target directory or jar)");
        this.opts.addOption("idlMethodSignatures", "", "Specify the method signatures used to trigger idl code generation.");
        this.opts.addFlag("idlCompatibility", "Substitute structs for value types to generate CORBA 2.2 compatible IDL.");
        this.opts.markPrivate("idlCompatibility");
        this.opts.addOption("dispatchPolicy", "policy", "Specify the Dispatch Policy for this EJB");
        this.opts.markPrivate("dispatchPolicy");
        this.opts.addFlag("stickToFirstServer", "Enables sticky load balancing");
        this.opts.markPrivate("stickToFirstServer");
        this.opts.addFlag("nocompliance", "Do not run the EJB Compliance Checker.");
        this.opts.addFlag("forceGeneration", "Force generation of wrapper classes.  Without this flag the classes may not be regenerated if it is determined to be unnecessary.");
        this.opts.addFlag("basicClientJar", "Generate a client jar that does not contain deployment descriptors.");
        this.opts.addFlag("convertDDs", "Convert old 1.1 deployment descriptors to 7.0. If this flag is set, ejbc invokes ddconverter to convert to 70 descriptors.");
        this.opts.addFlag("disableHotCodeGen", "Generate ejb stub and skel as part of ejbc. Avoid HotCodeGen to have better performance.");
        new CompilerInvoker(this.opts);
        this.opts.markPrivate("nowrite");
        this.opts.markPrivate("commentary");
        this.opts.markPrivate("nodeploy");
        this.opts.markPrivate("O");
        this.opts.markPrivate("d");
        this.opts.markPrivate("nocompliance");
        try {
            this.opts.setFlag("nowarn", true);
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Throwable)badOptionException);
        }
    }

    private String getSourceJarFileName(Getopt2 getopt2) {
        String[] stringArray = getopt2.args();
        return stringArray[0];
    }

    private void makeOutputDir(String string) throws ToolFailureException {
        this.outputDir = new File(string);
        if (!this.outputDir.exists()) {
            if (!this.outputDir.mkdir()) {
                throw new ToolFailureException("ERROR: Ejbc ould not create temporary working directory:" + this.outputDir.getAbsolutePath() + ".  Please ensure that this directory can be created.");
            }
        } else if (!this.outputDir.canWrite()) {
            throw new ToolFailureException("ERROR: Ejbc can not write to the temporary working directory:" + this.outputDir.getAbsolutePath() + ".  Please ensure that you have write permission for this directory.  You may also specify an alternative output directory on the weblogic.ejbc command line.");
        }
    }

    private String getTargetJarFileName(Getopt2 getopt2) throws ToolFailureException {
        String[] stringArray = getopt2.args();
        this.targetJarFileName = getopt2.getOption("d");
        if (this.targetJarFileName == null) {
            this.targetJarFileName = stringArray.length == 1 ? stringArray[0] : stringArray[1];
        }
        if (this.targetJarFileName.endsWith(".jar") || this.targetJarFileName.endsWith(".JAR")) {
            this.outputDir = new File(EJBC_WORKING_DIR);
            if (this.outputDir.exists()) {
                FileUtils.remove((File)new File(EJBC_WORKING_DIR));
            }
            this.makeOutputDir(EJBC_WORKING_DIR);
        } else {
            this.makeOutputDir(this.targetJarFileName);
            this.targetJarFileName = null;
        }
        return this.targetJarFileName;
    }

    private void validateToolInputs() throws ToolFailureException {
        if (this.opts.args().length < 1 || this.opts.args().length > 2) {
            this.opts.usageError("weblogic.ejbc");
            throw new ToolFailureException("ERROR: incorrect command-line.");
        }
        this.sourceJarFileName = this.getSourceJarFileName(this.opts);
        if (this.inputJar == null) {
            this.inputJar = new File(this.sourceJarFileName);
        }
        if (!this.inputJar.exists()) {
            throw new ToolFailureException("ERROR: source file: " + this.sourceJarFileName + " could not be found.");
        }
        if (!this.inputJar.isDirectory() && !this.sourceJarFileName.endsWith(".jar")) {
            throw new ToolFailureException("ERROR: You must specify a source directory or ejb-jar file ending with the suffix .jar to run weblogic.ejbc");
        }
        this.appId = this.inputJar.getName();
        this.targetJarFileName = this.getTargetJarFileName(this.opts);
        try {
            this.opts.setOption("d", this.outputDir.getPath());
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Throwable)badOptionException);
        }
    }

    private File backupJar(File file) throws ToolFailureException {
        File file2 = new File(file + "SAVE");
        if (file2.exists() && !file2.delete()) {
            throw new ToolFailureException("ERROR: Could not delete old backup file: " + file2.getAbsolutePath());
        }
        try {
            FileUtils.copy((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new ToolFailureException("ERROR: Could not create a backup file " + file2.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new ToolFailureException("ERROR: Could not delete previous jar " + file.getAbsolutePath());
        }
        return file2;
    }

    private void createOutputJar(String string) throws ToolFailureException {
        File file = new File(string);
        File file2 = null;
        if (file.exists()) {
            file2 = this.backupJar(file);
        }
        try {
            JarFileUtils.createJarFileFromDirectory((String)string, (File)this.outputDir);
            if (file2 != null) {
                file2.delete();
            }
            FileUtils.remove((File)this.outputDir);
        }
        catch (Exception exception) {
            if (file.exists()) {
                file.delete();
            }
            if (file2 != null && file2.exists()) {
                file2.renameTo(file);
                throw new ToolFailureException("ERROR: Could not create output jar, restoring previous jar.  The error was " + exception);
            }
            throw new ToolFailureException("ERROR: Could not create output jar.  The error was:" + exception);
        }
    }

    public void setClose(boolean bl) {
        this.doClose = bl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.m_classLoader = (GenericClassLoader)classLoader;
    }

    public void setJarFile(VirtualJarFile virtualJarFile) {
        this.myJar = virtualJarFile;
    }

    public void setCreateOutputJar(boolean bl) {
        this.createOutputJar = bl;
    }

    /*
     * Loose catch block
     */
    public void runBody() throws ToolFailureException, ErrorCollectionException {
        block32: {
            ClasspathClassFinder2 classpathClassFinder2;
            VirtualJarFile virtualJarFile;
            block31: {
                Object object;
                this.validateToolInputs();
                virtualJarFile = null;
                if (this.myJar != null) {
                    virtualJarFile = this.myJar;
                } else {
                    try {
                        virtualJarFile = VirtualJarFactory.createVirtualJar((File)this.inputJar);
                    }
                    catch (IOException iOException) {
                        throw new ToolFailureException("ERROR: Error processing input Jar file: " + iOException);
                    }
                }
                if (this.targetJarFileName != null || !this.inputJar.equals(this.outputDir)) {
                    try {
                        if (this.outputDir != null && virtualJarFile != null) {
                            this.inform(this.fmt.getExpandJar(virtualJarFile.getName(), this.outputDir.getPath()));
                            JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)this.outputDir);
                        }
                    }
                    catch (IOException iOException) {
                        throw new ToolFailureException("ERROR: Error expanding input Jar file: " + iOException);
                    }
                }
                classpathClassFinder2 = null;
                if (this.m_classLoader == null) {
                    Object object2;
                    object = this.outputDir.getAbsolutePath();
                    if (this.opts.hasOption("classpath")) {
                        object2 = new StringBuffer();
                        ((StringBuffer)object2).append((String)object);
                        ((StringBuffer)object2).append(File.pathSeparator);
                        ((StringBuffer)object2).append(this.opts.getOption("classpath"));
                        ((StringBuffer)object2).append(File.pathSeparator);
                        object = ((StringBuffer)object2).toString();
                    }
                    classpathClassFinder2 = new ClasspathClassFinder2((String)object);
                    object2 = ((Object)((Object)this)).getClass().getClassLoader();
                    this.m_classLoader = new GenericClassLoader((ClassFinder)classpathClassFinder2, (ClassLoader)object2);
                    this.m_classLoader.setAnnotation(new Annotation(this.appId, this.appId));
                }
                if (this.opts.hasOption("convertDDs")) {
                    this.convertOldDescriptorsToLatest(virtualJarFile);
                }
                if (this.ejbDescriptor == null) {
                    this.inform(this.fmt.getExtractingDesc(virtualJarFile.getName()));
                    try {
                        this.ejbDescriptor = this.getDescriptorFromJar(virtualJarFile, true, this.m_classLoader);
                    }
                    catch (ErrorCollectionException errorCollectionException) {
                        ErrorCollectionException errorCollectionException2;
                        if (this.runFromCmdLine) {
                            errorCollectionException.printStackTrace();
                            errorCollectionException2 = this.formatErrorsInCollection(errorCollectionException);
                            errorCollectionException2.add((Throwable)new ToolFailureException("ERROR: ejbc couldn't load descriptor from jar"));
                        }
                        throw errorCollectionException2;
                    }
                }
                try {
                    this.opts.setOption("classpath", this.m_classLoader.getClassPath());
                }
                catch (BadOptionException badOptionException) {
                    throw new AssertionError((Throwable)badOptionException);
                }
                object = EJBCFactory.createEJBC(this.opts);
                object.setCompilerFactory(this.compilerFactory);
                this.inform(this.fmt.getCompilingJar(virtualJarFile.getName()));
                object.compileEJB(this.m_classLoader, null, this.ejbDescriptor, virtualJarFile);
                Object var6_12 = null;
                if (!this.doClose) break block31;
                try {
                    virtualJarFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (classpathClassFinder2 != null) {
                classpathClassFinder2.close();
            }
            break block32;
            {
                catch (ErrorCollectionException errorCollectionException) {
                    ErrorCollectionException errorCollectionException3;
                    if (this.runFromCmdLine) {
                        errorCollectionException3 = this.formatErrorsInCollection(errorCollectionException);
                        errorCollectionException3.add((Throwable)new ToolFailureException("ERROR: ejbc couldn't invoke compiler"));
                    }
                    throw errorCollectionException3;
                }
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                if (this.doClose) {
                    try {
                        virtualJarFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (classpathClassFinder2 != null) {
                    classpathClassFinder2.close();
                }
                throw throwable;
            }
        }
        if (this.targetJarFileName != null && this.createOutputJar) {
            this.inform(this.fmt.getCreatingOutputJar(this.targetJarFileName));
            this.createOutputJar(this.targetJarFileName);
        }
        if (this.runFromCmdLine) {
            System.out.println("ejbc successful.");
        } else {
            this.inform("\n" + this.fmt.getEJBCSuccess());
        }
    }

    private void convertOldDescriptorsToLatest(VirtualJarFile virtualJarFile) throws ErrorCollectionException {
        EjbDescriptorBean ejbDescriptorBean = null;
        try {
            ejbDescriptorBean = this.getDescriptorFromJar(virtualJarFile, false, null);
        }
        catch (ErrorCollectionException errorCollectionException) {
            ErrorCollectionException errorCollectionException2;
            if (this.runFromCmdLine) {
                errorCollectionException2 = this.formatErrorsInCollection(errorCollectionException);
                errorCollectionException2.add((Throwable)new ToolFailureException("ERROR: ejbc couldn't find descriptor"));
            }
            throw errorCollectionException2;
        }
        try {
            ProcessorFactory processorFactory = new ProcessorFactory();
            processorFactory.setValidating(false);
            if (this.runFromCmdLine) {
                System.out.println("Converting old descriptor files");
            }
            EJBDescriptorMBeanUtils.loadWeblogicRDBMSJarMBeans(ejbDescriptorBean, virtualJarFile, processorFactory, false);
        }
        catch (Exception exception) {
            ErrorCollectionException errorCollectionException = new ErrorCollectionException();
            errorCollectionException.add((Throwable)exception);
            errorCollectionException = this.formatErrorsInCollection(errorCollectionException);
            errorCollectionException.add((Throwable)new ToolFailureException("ERROR: ejbc couldn't load MBeans"));
            throw errorCollectionException;
        }
        try {
            DDConverter.convertTo11Latest(ejbDescriptorBean);
        }
        catch (Exception exception) {
            ErrorCollectionException errorCollectionException = new ErrorCollectionException();
            errorCollectionException.add((Throwable)exception);
            errorCollectionException = this.formatErrorsInCollection(errorCollectionException);
            errorCollectionException.add((Throwable)new ToolFailureException("ERROR: ejbc couldn't convert old decsriptors"));
            throw errorCollectionException;
        }
        this.persistNewDescriptors(ejbDescriptorBean);
    }

    private void persistNewDescriptors(EjbDescriptorBean ejbDescriptorBean) throws ErrorCollectionException {
        try {
            this.renameOldDescriptors();
            ejbDescriptorBean.usePersistenceDestination(this.outputDir.getAbsolutePath());
            ejbDescriptorBean.persist();
        }
        catch (IOException iOException) {
            ErrorCollectionException errorCollectionException = new ErrorCollectionException();
            errorCollectionException.add((Throwable)iOException);
            errorCollectionException = this.formatErrorsInCollection(errorCollectionException);
            errorCollectionException.add((Throwable)new ToolFailureException("ERROR: ejbc couldn't rename decsriptors"));
            throw errorCollectionException;
        }
    }

    private void renameOldDescriptors() {
        File file = new File(this.outputDir.getAbsolutePath());
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2;
            System.out.println("the file names are " + stringArray[i]);
            if (!stringArray[i].equalsIgnoreCase("META-INF") || !(file2 = new File(this.outputDir.getAbsolutePath() + System.getProperty("file.separator") + stringArray[i])).isDirectory()) continue;
            String[] stringArray2 = file2.list();
            for (int j = 0; j < stringArray2.length; ++j) {
                System.out.println("the xml file names are " + stringArray2[j]);
                if (!stringArray2[j].equalsIgnoreCase("ejb-jar.xml") && !stringArray2[j].equalsIgnoreCase("weblogic-ejb-jar.xml") && !stringArray2[j].equalsIgnoreCase("weblogic-cmp-rdbms-jar.xml")) continue;
                String string = file2.getAbsolutePath() + System.getProperty("file.separator") + stringArray2[j];
                new File(string).renameTo(new File(string + ".old"));
            }
        }
    }

    public ErrorCollectionException formatErrorsInCollection(ErrorCollectionException errorCollectionException) {
        Collection collection = errorCollectionException.getExceptions();
        ErrorCollectionException errorCollectionException2 = new ErrorCollectionException(errorCollectionException.getBaseMessage());
        String string = null;
        for (Throwable throwable : collection) {
            string = this.formatExceptionMessage(throwable);
            errorCollectionException2.add((Throwable)new ToolFailureException(string));
        }
        return errorCollectionException2;
    }

    public String formatExceptionMessage(Throwable throwable) {
        String string = throwable.getMessage() + "\n";
        String string2 = "ERROR: Error from ejbc: ";
        StringBuffer stringBuffer = new StringBuffer();
        if (throwable instanceof ToolFailureException) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string2);
            if (throwable instanceof ClassNotFoundException) {
                stringBuffer.append("Unable to load a class specified in your ejb-jar.xml: " + string);
            } else if (throwable instanceof XMLProcessingException) {
                XMLProcessingException xMLProcessingException = (XMLProcessingException)((Object)throwable);
                stringBuffer.append("Error processing '" + xMLProcessingException.getFileName() + "': " + string);
            } else {
                stringBuffer.append(string);
            }
            if (this.opts.hasOption("verbose") || string == null || this.isBug(throwable)) {
                stringBuffer.append("\n" + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
        return stringBuffer.toString();
    }

    private EjbDescriptorBean getDescriptorFromJar(VirtualJarFile virtualJarFile, boolean bl, GenericClassLoader genericClassLoader) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        EjbDescriptorBean ejbDescriptorBean = null;
        try {
            ejbDescriptorBean = bl ? EjbDescriptorFactory.createReadOnlyDescriptorFromJarFile(virtualJarFile, genericClassLoader) : EjbDescriptorFactory.createDescriptorFromJarFile(virtualJarFile);
        }
        catch (XMLProcessingException xMLProcessingException) {
            errorCollectionException.add((Throwable)new ToolFailureException("ERROR: ejbc found errors while processing the descriptor for " + this.sourceJarFileName + ": \n"));
            errorCollectionException.add((Throwable)((Object)xMLProcessingException));
            throw errorCollectionException;
        }
        catch (XMLParsingException xMLParsingException) {
            errorCollectionException.add((Throwable)new ToolFailureException("ERROR: ejbc found errors while parsing the descriptor for " + this.sourceJarFileName + ": \n"));
            errorCollectionException.add((Throwable)((Object)xMLParsingException));
            throw errorCollectionException;
        }
        catch (Exception exception) {
            errorCollectionException.add((Throwable)new ToolFailureException("ERROR: Error creating descriptor from jar file " + this.sourceJarFileName + ": "));
            errorCollectionException.add((Throwable)exception);
            throw errorCollectionException;
        }
        return ejbDescriptorBean;
    }

    private boolean isBug(Throwable throwable) {
        for (int i = 0; i < this.bugs.length; ++i) {
            if (!this.bugs[i].isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    private void inform(String string) {
    }

    public ICompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(ICompilerFactory iCompilerFactory) {
        this.compilerFactory = iCompilerFactory;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\nDEPRECATED: The weblogic.ejbc20 compiler is deprecated and will be removed in a future version of WebLogic Server.  Please use weblogic.ejbc instead.\n");
        new ejbc20(stringArray).run();
    }
}

