/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.data.ldap;

import java.util.Properties;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import weblogic.entitlement.data.BaseResource;
import weblogic.entitlement.data.ldap.EData;
import weblogic.security.shared.LoggerWrapper;

abstract class ECursorBase {
    private static int cursorId = 1;
    private String cursorName;
    private LDAPConnection conn;
    private LDAPSearchResults results;
    private LDAPEntry currEntry;
    private int currEntryNum;
    private int maximumToReturn;
    protected EData data;
    protected LoggerWrapper traceLogger;

    public ECursorBase(String string, LDAPConnection lDAPConnection, LDAPSearchResults lDAPSearchResults, int n, EData eData, LoggerWrapper loggerWrapper) {
        this.traceLogger = loggerWrapper;
        this.data = eData;
        this.conn = lDAPConnection;
        this.results = lDAPSearchResults;
        this.maximumToReturn = n;
        this.currEntry = null;
        this.currEntryNum = 0;
        this.cursorName = string + this.hashCode() + this.getNextCursorId();
        if (lDAPSearchResults != null) {
            if (loggerWrapper != null && loggerWrapper.isDebugEnabled()) {
                loggerWrapper.debug("ECursorBase has more elements: " + lDAPSearchResults.hasMoreElements());
            }
            if (!lDAPSearchResults.hasMoreElements()) {
                this.conn = null;
                if (lDAPConnection != null) {
                    EData.releaseConnection(lDAPConnection);
                }
            } else {
                this.advance();
            }
        }
    }

    public abstract Properties getCurrentProperties();

    public void advance() {
        this.advance(true);
    }

    protected void advance(boolean bl) {
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("advance(" + bl + ")");
        }
        this.currEntry = null;
        try {
            if (this.results != null && this.results.hasMoreElements() && (this.maximumToReturn == 0 || this.currEntryNum < this.maximumToReturn)) {
                this.currEntry = this.results.next();
                if (bl) {
                    ++this.currEntryNum;
                }
            } else {
                this.close();
            }
        }
        catch (LDAPException lDAPException) {
            if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
                this.traceLogger.debug("LDAPException while trying to advance cursor");
            }
            this.close();
            EData.checkStorageException(lDAPException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("close");
        }
        try {
            if (this.results != null && this.conn != null) {
                if (this.traceLogger != null) {
                    this.traceLogger.debug("ECursorBase abandoning search results");
                }
                LDAPSearchResults lDAPSearchResults = this.results;
                this.results = null;
                this.conn.abandon(lDAPSearchResults);
            }
        }
        catch (LDAPException lDAPException) {
            if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
                this.traceLogger.debug("LDAPException while trying to abandon results");
            }
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (this.conn != null) {
                if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
                    this.traceLogger.debug("ECursorBase releasing connection");
                }
                LDAPConnection lDAPConnection = this.conn;
                this.conn = null;
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    public boolean haveCurrent() {
        return this.currEntry != null;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    protected LDAPEntry getCurrentEntry() {
        return this.currEntry;
    }

    protected String getEntitlement(BaseResource baseResource) {
        String string = baseResource.getEntitlement();
        return string != null ? string : "";
    }

    private synchronized int getNextCursorId() {
        return cursorId++;
    }
}

