/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.data.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import weblogic.entitlement.data.EPolicyCollectionInfo;
import weblogic.entitlement.data.EResource;
import weblogic.entitlement.data.ERole;
import weblogic.entitlement.data.ERoleCollectionInfo;
import weblogic.entitlement.data.ERoleId;
import weblogic.entitlement.data.EnConflictException;
import weblogic.entitlement.data.EnCreateException;
import weblogic.entitlement.data.EnCursorResourceFilter;
import weblogic.entitlement.data.EnCursorRoleFilter;
import weblogic.entitlement.data.EnData;
import weblogic.entitlement.data.EnDataChangeListener;
import weblogic.entitlement.data.EnDuplicateKeyException;
import weblogic.entitlement.data.EnFinderException;
import weblogic.entitlement.data.EnRemoveException;
import weblogic.entitlement.data.EnResourceCursor;
import weblogic.entitlement.data.EnRoleCursor;
import weblogic.entitlement.data.EnStorageException;
import weblogic.entitlement.data.ldap.EResourceCursor;
import weblogic.entitlement.data.ldap.ERoleCursor;
import weblogic.entitlement.data.ldap.EnLDAP;
import weblogic.entitlement.expression.EAuxiliary;
import weblogic.entitlement.expression.EExprRep;
import weblogic.entitlement.expression.EExpression;
import weblogic.entitlement.util.Escaping;
import weblogic.entitlement.util.TextFilter;
import weblogic.ldap.EmbeddedLDAP;
import weblogic.ldap.EmbeddedLDAPChange;
import weblogic.ldap.EmbeddedLDAPChangeListener;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.ProviderUtils;

public class EData
extends EnLDAP
implements EnData {
    private String roleBaseDN = null;
    private String resourceBaseDN = null;
    private String predicateBaseDN = null;
    private String policyCollectionBaseDN = null;
    private String roleCollectionBaseDN = null;
    private static final String eexprAttribute = "EExpr";
    private static final String auxAttribute = "EAux";
    private static final String[] ROLE_OBJ_CLASSES = new String[]{"top", "ERole"};
    private static final String[] RESOURCE_OBJ_CLASSES = new String[]{"top", "EResource"};
    private static final String[] PREDICATE_OBJ_CLASSES = new String[]{"top", "EPredicate"};
    private static final String[] POLICY_COL_OBJ_CLASSES = new String[]{"top", "wlsPolicyCollectionInfo"};
    private static final String[] ROLE_COL_OBJ_CLASSES = new String[]{"top", "wlsRoleCollectionInfo"};
    private static final String roleBaseName = "ERole";
    private static final String resourceBaseName = "EResource";
    private static final String predicateBaseName = "EPredicate";
    private static final String policyCollectionBaseName = "EPolicyCollectionInfo";
    private static final String roleCollectionBaseName = "ERoleCollectionInfo";
    private static final String WLSCREATORINFO = "wlsCreatorInfo";
    private static final String wlsCollectionName = "wlsCollectionName";
    private static final String wlsCollectionVersion = "wlsCollectionVersion";
    private static final String wlsCollectionTimestamp = "wlsCollectionTimestamp";
    private static final String[] eexprAttrList = new String[]{"EExpr", "EAux", "wlsCreatorInfo", "wlsCollectionName"};
    private static final String[] conflictAttrList = new String[]{"wlsCreatorInfo", "wlsCollectionName"};
    private static final String[] collectionAttrList = new String[]{"wlsCollectionName", "wlsCollectionVersion", "wlsCollectionTimestamp"};
    private static final char[] SPECIAL_CHARS = new char[]{'@', '|', '&', '!', '=', '<', '>', '~', '(', ')', '*', ':', ',', ';', ' ', '\"', '\'', '\t', '\\', '+', '/'};
    public static final Escaping escaper = new Escaping(SPECIAL_CHARS);

    public EData(Properties properties) {
        super(properties);
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("Initializing EData.");
        }
        this.roleBaseDN = "ou=ERole," + this.realmDN;
        this.resourceBaseDN = "ou=EResource," + this.realmDN;
        this.predicateBaseDN = "ou=EPredicate," + this.realmDN;
        this.policyCollectionBaseDN = "ou=EPolicyCollectionInfo," + this.realmDN;
        this.roleCollectionBaseDN = "ou=ERoleCollectionInfo," + this.realmDN;
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            this.createHierachy(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            lDAPConnection = null;
            throw new EnStorageException(lDAPException.getMessage());
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    private void createHierachy(LDAPConnection lDAPConnection) throws LDAPException {
        EData.addStructuralEntry(lDAPConnection, this.roleBaseDN, false, roleBaseName);
        EData.addStructuralEntry(lDAPConnection, this.resourceBaseDN, false, resourceBaseName);
        EData.addStructuralEntry(lDAPConnection, this.predicateBaseDN, false, predicateBaseName);
        EData.addStructuralEntry(lDAPConnection, this.policyCollectionBaseDN, false, policyCollectionBaseName);
        EData.addStructuralEntry(lDAPConnection, this.roleCollectionBaseDN, false, roleCollectionBaseName);
    }

    private static void checkDuplicateException(LDAPException lDAPException) throws EnDuplicateKeyException {
        EData.checkStorageException(lDAPException);
        if (lDAPException.getLDAPResultCode() == 68) {
            throw new EnDuplicateKeyException(lDAPException.toString());
        }
    }

    private static void checkFinderException(LDAPException lDAPException) throws EnFinderException {
        EData.checkStorageException(lDAPException);
        if (lDAPException.getLDAPResultCode() == 32) {
            throw new EnFinderException(lDAPException.toString());
        }
    }

    public Collection fetchRoleIds(String string, TextFilter textFilter) {
        String string2 = textFilter == null ? "*" : textFilter.toString(escaper, "*");
        string = escaper.escapeString(string);
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("fetchRoleIds: ");
        }
        return this.fetchERoleIds(EData.PK2Name(string, string2), this.roleBaseDN, "cn");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection fetchERoleIds(String string, String string2, String string3) {
        ArrayList<ERoleId> arrayList = new ArrayList<ERoleId>();
        LDAPConnection lDAPConnection = null;
        try {
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug(string);
            }
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 1, string3 + "=" + string, noAttrs, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string4 = EData.getEntryName(lDAPEntry);
                ERoleId eRoleId = EData.name2PK(string4);
                arrayList.add(eRoleId);
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
        return arrayList;
    }

    public Collection fetchResourceRoleIds(TextFilter textFilter) {
        String string;
        String string2 = string = textFilter == null ? "*" : textFilter.toString(escaper, "*");
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("fetchResourceRoleIds: ");
        }
        return this.fetchERoleIds(EData.PK2Name(string, "*"), this.roleBaseDN, "cn");
    }

    public Collection fetchGlobalRoles() {
        return this.fetchRoles("", null);
    }

    public Collection fetchRoles(String string) {
        return this.fetchRoles(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection fetchRoles(String string, TextFilter textFilter) {
        ArrayList<ERole> arrayList = new ArrayList<ERole>();
        LDAPConnection lDAPConnection = null;
        try {
            String string2;
            string = escaper.escapeString(string);
            String string3 = string2 = textFilter == null ? "*" : textFilter.toString(escaper, "*");
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("fetchRoles(" + string + "," + string2 + ") ==> ");
            }
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, "cn=" + EData.PK2Name(string, string2), eexprAttrList, false);
            while (lDAPSearchResults.hasMoreElements()) {
                arrayList.add(this.getRoleFromEntry(lDAPSearchResults.next()));
            }
            if (lDAPConnection == null) return arrayList;
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
            return arrayList;
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
        EData.releaseConnection(lDAPConnection);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection fetchNames(TextFilter textFilter, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LDAPConnection lDAPConnection = null;
        try {
            String string3;
            String string4 = string3 = textFilter == null ? "*" : textFilter.toString(escaper, "*");
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug(string3);
            }
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, string2 + "=" + string3, noAttrs, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string5 = EData.getEntryName(lDAPEntry);
                string5 = escaper.unescapeString(string5);
                arrayList.add(string5);
            }
            if (lDAPConnection == null) return arrayList;
        }
        catch (LDAPException lDAPException) {
            try {
                EData.checkStorageException(lDAPException);
                if (lDAPConnection == null) return arrayList;
            }
            catch (Throwable throwable) {
                if (lDAPConnection == null) throw throwable;
                EData.releaseConnection(lDAPConnection);
                throw throwable;
            }
            EData.releaseConnection(lDAPConnection);
            return arrayList;
        }
        EData.releaseConnection(lDAPConnection);
        return arrayList;
    }

    public Collection fetchResourceNames(TextFilter textFilter) {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("fetchResourceNames: ");
        }
        return this.fetchNames(textFilter, this.resourceBaseDN, "cn");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection fetchResources(TextFilter textFilter) {
        ArrayList<EResource> arrayList = new ArrayList<EResource>();
        LDAPConnection lDAPConnection = null;
        try {
            String string;
            String string2 = string = textFilter == null ? "*" : textFilter.toString(escaper, "*");
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("fetchResources(" + string + ")");
            }
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.resourceBaseDN, 1, "cn=" + string, eexprAttrList, false);
            while (lDAPSearchResults.hasMoreElements()) {
                arrayList.add(this.getResourceFromEntry(lDAPSearchResults.next()));
            }
            if (lDAPConnection == null) return arrayList;
        }
        catch (LDAPException lDAPException) {
            try {
                EData.checkStorageException(lDAPException);
                if (lDAPConnection == null) return arrayList;
            }
            catch (Throwable throwable) {
                if (lDAPConnection == null) throw throwable;
                EData.releaseConnection(lDAPConnection);
                throw throwable;
            }
            EData.releaseConnection(lDAPConnection);
            return arrayList;
        }
        EData.releaseConnection(lDAPConnection);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERole[] fetchRoles(ERoleId[] eRoleIdArray, boolean bl) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("fetch roles");
        }
        ERole[] eRoleArray = new ERole[eRoleIdArray.length];
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getRoleNames(eRoleIdArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, EData.makeNameFilter(stringArray), eexprAttrList, false);
            HashMap<Object, ERole> hashMap = new HashMap<Object, ERole>(eRoleIdArray.length);
            while (lDAPSearchResults.hasMoreElements()) {
                ERole eRole = this.getRoleFromEntry(lDAPSearchResults.next());
                hashMap.put(eRole.getPrimaryKey(), eRole);
            }
            for (int i = 0; i < eRoleIdArray.length; ++i) {
                eRoleArray[i] = (ERole)hashMap.get(eRoleIdArray[i]);
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    traceLogger.debug("role[" + i + "]=" + eRoleIdArray[i] + (eRoleArray[i] == null ? "Not Found" : eRoleArray[i].getEntitlement()));
                }
                if (eRoleArray[i] != null || bl) continue;
                throw new EnFinderException("Role '" + eRoleIdArray[i].getRoleName() + "' not found.");
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
        return eRoleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EResource[] fetchResources(String[] stringArray, boolean bl) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("fetch resources");
        }
        EResource[] eResourceArray = new EResource[stringArray.length];
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = escaper.escapeString(stringArray[i]);
            }
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.resourceBaseDN, 1, EData.makeNameFilter(stringArray2), eexprAttrList, false);
            HashMap<String, EResource> hashMap = new HashMap<String, EResource>(stringArray.length);
            while (lDAPSearchResults.hasMoreElements()) {
                EResource eResource = this.getResourceFromEntry(lDAPSearchResults.next());
                hashMap.put(eResource.getName(), eResource);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                eResourceArray[i] = (EResource)hashMap.get(stringArray[i]);
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    traceLogger.debug("resource[" + i + "]=" + stringArray[i] + " : " + (eResourceArray[i] == null ? "Not Found" : eResourceArray[i].getEntitlement()));
                }
                if (eResourceArray[i] != null || bl) continue;
                throw new EnFinderException("Resource '" + stringArray[i] + "' not found.");
            }
            if (lDAPConnection == null) return eResourceArray;
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
            return eResourceArray;
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
        EData.releaseConnection(lDAPConnection);
        return eResourceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ERole[] eRoleArray, boolean bl) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("update roles");
        }
        if (eRoleArray.length == 0) {
            return;
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getRoleNames(eRoleArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, EData.makeNameFilter(stringArray), noAttrs, true);
            if (EData.countEntries(lDAPSearchResults) != eRoleArray.length) {
                throw new EnFinderException("Attempt to modify unknown role");
            }
            for (int i = 0; i < eRoleArray.length; ++i) {
                LDAPModification[] lDAPModificationArray;
                EExpression eExpression = eRoleArray[i].getExpression();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(eexprAttribute, eExpression == null ? null : eExpression.serialize());
                LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
                LDAPAttribute lDAPAttribute2 = new LDAPAttribute(WLSCREATORINFO, bl ? "deploy" : "mbean");
                LDAPModification lDAPModification2 = new LDAPModification(2, lDAPAttribute2);
                String string = eRoleArray[i].getCollectionName();
                if (string != null) {
                    LDAPAttribute lDAPAttribute3 = new LDAPAttribute(wlsCollectionName, escaper.escapeString(string));
                    LDAPModification lDAPModification3 = new LDAPModification(2, lDAPAttribute3);
                    lDAPModificationArray = new LDAPModification[]{lDAPModification, lDAPModification2, lDAPModification3};
                } else {
                    lDAPModificationArray = new LDAPModification[]{lDAPModification, lDAPModification2};
                }
                lDAPConnection.modify("cn=" + stringArray[i] + "," + this.roleBaseDN, lDAPModificationArray);
                if (traceLogger == null || !traceLogger.isDebugEnabled()) continue;
                traceLogger.debug("role[" + i + "]=" + eRoleArray[i].getPrimaryKey() + " : " + eRoleArray[i].getEntitlement());
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuxiliary(ERole[] eRoleArray, boolean bl) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("update roles auxiliary");
        }
        if (eRoleArray.length == 0) {
            return;
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getRoleNames(eRoleArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, EData.makeNameFilter(stringArray), noAttrs, true);
            if (EData.countEntries(lDAPSearchResults) != eRoleArray.length) {
                throw new EnFinderException("Attempt to modify unknown role");
            }
            for (int i = 0; i < eRoleArray.length; ++i) {
                EAuxiliary eAuxiliary = eRoleArray[i].getAuxiliary();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(auxAttribute, eAuxiliary == null ? null : eAuxiliary.toString());
                LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
                LDAPAttribute lDAPAttribute2 = new LDAPAttribute(WLSCREATORINFO, bl ? "deploy" : "mbean");
                LDAPModification lDAPModification2 = new LDAPModification(2, lDAPAttribute2);
                LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification, lDAPModification2};
                lDAPConnection.modify("cn=" + stringArray[i] + "," + this.roleBaseDN, lDAPModificationArray);
                if (traceLogger == null || !traceLogger.isDebugEnabled()) continue;
                traceLogger.debug("role[" + i + "]=" + eRoleArray[i].getPrimaryKey() + " : " + eRoleArray[i].getAuxiliary());
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(EResource[] eResourceArray, boolean bl) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("update resources");
        }
        if (eResourceArray.length == 0) {
            return;
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getResourceNames(eResourceArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.resourceBaseDN, 1, EData.makeNameFilter(stringArray), noAttrs, true);
            if (EData.countEntries(lDAPSearchResults) != eResourceArray.length) {
                throw new EnFinderException("Attempt to modify unknown resource.");
            }
            for (int i = 0; i < eResourceArray.length; ++i) {
                LDAPModification[] lDAPModificationArray;
                EExpression eExpression = eResourceArray[i].getExpression();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(eexprAttribute, eExpression == null ? null : eExpression.serialize());
                LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
                LDAPAttribute lDAPAttribute2 = new LDAPAttribute(WLSCREATORINFO, bl ? "deploy" : "mbean");
                LDAPModification lDAPModification2 = new LDAPModification(2, lDAPAttribute2);
                String string = eResourceArray[i].getCollectionName();
                if (string != null) {
                    LDAPAttribute lDAPAttribute3 = new LDAPAttribute(wlsCollectionName, escaper.escapeString(string));
                    LDAPModification lDAPModification3 = new LDAPModification(2, lDAPAttribute3);
                    lDAPModificationArray = new LDAPModification[]{lDAPModification, lDAPModification2, lDAPModification3};
                } else {
                    lDAPModificationArray = new LDAPModification[]{lDAPModification, lDAPModification2};
                }
                lDAPConnection.modify("cn=" + stringArray[i] + "," + this.resourceBaseDN, lDAPModificationArray);
                if (traceLogger == null || !traceLogger.isDebugEnabled()) continue;
                traceLogger.debug("resource[" + i + "]=" + eResourceArray[i].getName() + " : " + eResourceArray[i].getEntitlement());
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(ERole[] eRoleArray, boolean bl) throws EnDuplicateKeyException, EnCreateException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("create roles");
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getRoleNames(eRoleArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, EData.makeNameFilter(stringArray), noAttrs, false);
            if (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string = EData.getEntryName(lDAPEntry);
                String string2 = escaper.unescapeString(string.substring(string.indexOf("::") + "::".length()));
                throw new EnDuplicateKeyException("Role policy definition for '" + string2 + "' already exist.");
            }
            for (int i = 0; i < eRoleArray.length; ++i) {
                EAuxiliary eAuxiliary;
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", ROLE_OBJ_CLASSES));
                lDAPAttributeSet.add(new LDAPAttribute("cn", stringArray[i]));
                EExpression eExpression = eRoleArray[i].getExpression();
                if (eExpression != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(eexprAttribute, eExpression.serialize()));
                }
                if ((eAuxiliary = eRoleArray[i].getAuxiliary()) != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(auxAttribute, eAuxiliary.toString()));
                }
                String string = "cn=" + stringArray[i] + "," + this.roleBaseDN;
                LDAPAttribute lDAPAttribute = new LDAPAttribute(WLSCREATORINFO, bl ? "deploy" : "mbean");
                lDAPAttributeSet.add(lDAPAttribute);
                String string3 = eRoleArray[i].getCollectionName();
                if (string3 != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionName, escaper.escapeString(string3)));
                }
                LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkDuplicateException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createForCollection(ERole[] eRoleArray) throws EnConflictException, EnDuplicateKeyException, EnCreateException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("create roles for collection");
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getRoleNames(eRoleArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, EData.makeNameFilter(stringArray), conflictAttrList, false);
            if (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string = EData.getEntryName(lDAPEntry);
                boolean bl = EData.getEntryDeployData(lDAPEntry);
                String string2 = "Entitlement role definition for '" + escaper.unescapeString(string) + "' ";
                if (bl) {
                    throw new EnDuplicateKeyException(string2 + " already exist.");
                }
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    String string3 = EData.getEntryAttribute(lDAPEntry, wlsCollectionName);
                    traceLogger.debug("conflict: " + string3 + " -- " + string);
                }
                throw new EnConflictException(string2 + " is customized.");
            }
            for (int i = 0; i < eRoleArray.length; ++i) {
                EAuxiliary eAuxiliary;
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", ROLE_OBJ_CLASSES));
                lDAPAttributeSet.add(new LDAPAttribute("cn", stringArray[i]));
                EExpression eExpression = eRoleArray[i].getExpression();
                if (eExpression != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(eexprAttribute, eExpression.serialize()));
                }
                if ((eAuxiliary = eRoleArray[i].getAuxiliary()) != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(auxAttribute, eAuxiliary.toString()));
                }
                String string = "cn=" + stringArray[i] + "," + this.roleBaseDN;
                boolean bl = eRoleArray[i].isDeployData();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(WLSCREATORINFO, bl ? "deploy" : "mbean");
                lDAPAttributeSet.add(lDAPAttribute);
                String string4 = eRoleArray[i].getCollectionName();
                if (string4 != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionName, escaper.escapeString(string4)));
                }
                LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkDuplicateException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(EResource[] eResourceArray, boolean bl) throws EnDuplicateKeyException, EnCreateException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("create resources");
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getResourceNames(eResourceArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.resourceBaseDN, 1, EData.makeNameFilter(stringArray), noAttrs, false);
            if (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string = EData.getEntryName(lDAPEntry);
                throw new EnDuplicateKeyException("Entitlement policy definition for '" + escaper.unescapeString(string) + "' already exist.");
            }
            for (int i = 0; i < eResourceArray.length; ++i) {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", RESOURCE_OBJ_CLASSES));
                lDAPAttributeSet.add(new LDAPAttribute("cn", stringArray[i]));
                EExpression eExpression = eResourceArray[i].getExpression();
                if (eExpression != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(eexprAttribute, eExpression.serialize()));
                }
                String string = "cn=" + stringArray[i] + "," + this.resourceBaseDN;
                LDAPAttribute lDAPAttribute = new LDAPAttribute(WLSCREATORINFO, bl ? "deploy" : "mbean");
                lDAPAttributeSet.add(lDAPAttribute);
                String string2 = eResourceArray[i].getCollectionName();
                if (string2 != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionName, escaper.escapeString(string2)));
                }
                LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkDuplicateException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoles(ERoleId[] eRoleIdArray) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("remove roles");
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getRoleNames(eRoleIdArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, EData.makeNameFilter(stringArray), noAttrs, true);
            if (EData.countEntries(lDAPSearchResults) != eRoleIdArray.length) {
                throw new EnFinderException("Attempt to remove unknown role");
            }
            for (int i = 0; i < eRoleIdArray.length; ++i) {
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    traceLogger.debug("role[" + i + "]=" + eRoleIdArray[i]);
                }
                String string = "cn=" + stringArray[i] + "," + this.roleBaseDN;
                lDAPConnection.delete(string);
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeResources(String[] stringArray) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("remove resources");
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = escaper.escapeString(stringArray[i]);
            }
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.resourceBaseDN, 1, EData.makeNameFilter(stringArray2), noAttrs, true);
            if (EData.countEntries(lDAPSearchResults) != stringArray.length) {
                throw new EnFinderException("Attempt to remove unknown resource.");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    traceLogger.debug("resource[" + i + "]=" + stringArray[i]);
                }
                String string = "cn=" + stringArray2[i] + "," + this.resourceBaseDN;
                lDAPConnection.delete(string);
            }
            if (lDAPConnection == null) return;
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
            return;
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
        EData.releaseConnection(lDAPConnection);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPredicate(String string) throws EnDuplicateKeyException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("create predicate: " + string);
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", PREDICATE_OBJ_CLASSES));
            lDAPAttributeSet.add(new LDAPAttribute("cn", string));
            String string2 = "cn=" + string + "," + this.predicateBaseDN;
            LDAPEntry lDAPEntry = new LDAPEntry(string2, lDAPAttributeSet);
            lDAPConnection.add(lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            EData.checkDuplicateException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePredicate(String string) throws EnFinderException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("remove predicate: " + string);
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            String string2 = "cn=" + string + "," + this.predicateBaseDN;
            lDAPConnection.delete(string2);
        }
        catch (LDAPException lDAPException) {
            EData.checkFinderException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean predicateExists(String string) {
        boolean bl = false;
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("predicate exists: " + string);
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.predicateBaseDN, 1, "cn=" + string, noAttrs, false);
            bl = lDAPSearchResults.hasMoreElements();
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
        return bl;
    }

    public Collection fetchPredicates(TextFilter textFilter) {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("fetch predicates: ");
        }
        return this.fetchNames(textFilter, this.predicateBaseDN, "cn");
    }

    public void setDataChangeListener(EnDataChangeListener enDataChangeListener) {
        EmbeddedLDAP embeddedLDAP;
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("setDataChangeListener()");
        }
        if ((embeddedLDAP = EmbeddedLDAP.getEmbeddedLDAP()) != null) {
            LDAPChangeListener lDAPChangeListener = new LDAPChangeListener(enDataChangeListener);
            embeddedLDAP.registerChangeListener(this.roleBaseDN, lDAPChangeListener);
            embeddedLDAP.registerChangeListener(this.resourceBaseDN, lDAPChangeListener);
            embeddedLDAP.registerChangeListener(this.predicateBaseDN, lDAPChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationDeletedResources(String string, int n, String string2) throws EnFinderException, EnRemoveException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("application delete resources");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.applicationDeleted((LDAPConnection)lDAPConnection, (String)this.resourceBaseDN, (String)string, (int)n, (String)string2, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAfterCollectionResources(String string, long l, List list) throws EnFinderException, EnRemoveException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("cleanup after collection resources");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.cleanupAfterCollection((LDAPConnection)lDAPConnection, (String)this.resourceBaseDN, (String)string, (long)l, (List)list, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAfterCollectionRoles(String string, long l, List list) throws EnFinderException, EnRemoveException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("cleanup after collection roles");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.cleanupAfterCollection((LDAPConnection)lDAPConnection, (String)this.roleBaseDN, (String)string, (long)l, (List)list, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAfterDeployResources(String string, int n, String string2, long l) throws EnFinderException, EnRemoveException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("cleanup after deploy resources");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.cleanupAfterAppDeploy((LDAPConnection)lDAPConnection, (String)this.resourceBaseDN, (String)string, (int)n, (String)string2, (long)l, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    public void applicationCopyResources(String string, String string2) throws EnCreateException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("application copy resources");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.applicationCopy((LDAPConnection)lDAPConnection, (String)this.resourceBaseDN, (String)string, (String)string2, (String[])nameAttributeList, (String[])ProviderUtils.EXCLUDED_ON_COPY_ATTRS, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("application copy resources exception: " + lDAPException.toString(), lDAPException);
            }
            throw new EnCreateException(lDAPException.toString());
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationDeletedRoles(String string, int n, String string2) throws EnFinderException, EnRemoveException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("application delete roles");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.applicationDeleted((LDAPConnection)lDAPConnection, (String)this.roleBaseDN, (String)string, (int)n, (String)string2, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAfterDeployRoles(String string, int n, String string2, long l) throws EnFinderException, EnRemoveException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("cleanup after deploy roles");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.cleanupAfterAppDeploy((LDAPConnection)lDAPConnection, (String)this.roleBaseDN, (String)string, (int)n, (String)string2, (long)l, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            EData.checkStorageException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    public void applicationCopyRoles(String string, String string2) throws EnCreateException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("application copy roles");
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            ProviderUtils.applicationCopy((LDAPConnection)lDAPConnection, (String)this.roleBaseDN, (String)string, (String)string2, (String[])nameAttributeList, (String[])ProviderUtils.EXCLUDED_ON_COPY_ATTRS, (LoggerWrapper)traceLogger);
        }
        catch (LDAPException lDAPException) {
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("application copy roles exception: " + lDAPException.toString(), lDAPException);
            }
            throw new EnCreateException(lDAPException.toString());
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    public static String PK2Name(ERoleId eRoleId) {
        return EData.PK2Name(escaper.escapeString(eRoleId.getResourceName()), escaper.escapeString(eRoleId.getRoleName()));
    }

    protected static String unescapeName(String string) {
        return escaper.unescapeString(string);
    }

    protected static ERoleId name2PK(String string) {
        int n = string.indexOf("::");
        String string2 = n == 0 ? null : escaper.unescapeString(string.substring(0, n));
        String string3 = escaper.unescapeString(string.substring(n + "::".length()));
        return new ERoleId(string2, string3);
    }

    protected static String getEntryName(LDAPEntry lDAPEntry) {
        String string = lDAPEntry.getDN();
        string = string.substring(string.indexOf(61) + 1, string.indexOf(44));
        return string;
    }

    private EExpression getEntryExpression(LDAPEntry lDAPEntry) {
        String[] stringArray;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(eexprAttribute);
        String string = null;
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()) != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        return string == null ? null : EExprRep.deserialize(string);
    }

    protected static String getEntryAuxiliary(LDAPEntry lDAPEntry) {
        String[] stringArray;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(auxAttribute);
        String string = null;
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()) != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        return string;
    }

    protected static boolean getEntryDeployData(LDAPEntry lDAPEntry) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(WLSCREATORINFO);
        boolean bl = false;
        if (lDAPAttribute != null) {
            String string = null;
            String[] stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            if ("deploy".equals(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private static int countEntries(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        int n = 0;
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPSearchResults.next();
            ++n;
        }
        return n;
    }

    private static String[] getRoleNames(ERoleId[] eRoleIdArray) {
        String[] stringArray = new String[eRoleIdArray.length];
        for (int i = 0; i < eRoleIdArray.length; ++i) {
            stringArray[i] = EData.PK2Name(eRoleIdArray[i]);
        }
        return stringArray;
    }

    private static String[] getRoleNames(ERole[] eRoleArray) {
        String[] stringArray = new String[eRoleArray.length];
        for (int i = 0; i < eRoleArray.length; ++i) {
            stringArray[i] = EData.PK2Name((ERoleId)eRoleArray[i].getPrimaryKey());
        }
        return stringArray;
    }

    private static String[] getResourceNames(EResource[] eResourceArray) {
        String[] stringArray = new String[eResourceArray.length];
        for (int i = 0; i < eResourceArray.length; ++i) {
            stringArray[i] = escaper.escapeString(eResourceArray[i].getName());
        }
        return stringArray;
    }

    private static String makeNameFilter(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("(|");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append("(");
            stringBuffer.append("cn").append("=").append(stringArray[i]);
            stringBuffer.append(')');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public EnResourceCursor findResources(TextFilter textFilter, int n, EnCursorResourceFilter enCursorResourceFilter) {
        String string;
        String string2 = string = textFilter == null ? "*" : textFilter.toString(escaper, "*");
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("findResources: " + string);
        }
        EResourceCursor eResourceCursor = null;
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.resourceBaseDN, 1, "cn=" + string, eexprAttrList, false);
            eResourceCursor = enCursorResourceFilter == null ? new EResourceCursor(lDAPConnection, lDAPSearchResults, n, this, traceLogger) : new EResourceCursor(enCursorResourceFilter, lDAPConnection, lDAPSearchResults, n, this, traceLogger);
        }
        catch (LDAPException lDAPException) {
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("LDAPException while trying to search for resources");
            }
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
            EData.checkStorageException(lDAPException);
        }
        return eResourceCursor;
    }

    public EnRoleCursor findRoles(TextFilter textFilter, TextFilter textFilter2, int n, EnCursorRoleFilter enCursorRoleFilter) {
        String string;
        String string2 = string = textFilter == null ? "*" : textFilter.toString(escaper, "*");
        if (textFilter2 != null) {
            string2 = EData.PK2Name(string, textFilter2.toString(escaper, "*"));
        } else if (!string2.endsWith("*")) {
            string2 = string2 + "*";
        }
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("findRoles: " + string2);
        }
        ERoleCursor eRoleCursor = null;
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleBaseDN, 1, "cn=" + string2, eexprAttrList, false);
            eRoleCursor = enCursorRoleFilter == null ? new ERoleCursor(lDAPConnection, lDAPSearchResults, n, this, traceLogger) : new ERoleCursor(enCursorRoleFilter, lDAPConnection, lDAPSearchResults, n, this, traceLogger);
        }
        catch (LDAPException lDAPException) {
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("LDAPException while trying to search for roles");
            }
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
            EData.checkStorageException(lDAPException);
        }
        return eRoleCursor;
    }

    public EResource getResourceFromEntry(LDAPEntry lDAPEntry) {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("getResourceFromEntry");
        }
        EResource eResource = null;
        if (lDAPEntry != null) {
            String string = EData.getEntryName(lDAPEntry);
            EExpression eExpression = this.getEntryExpression(lDAPEntry);
            boolean bl = EData.getEntryDeployData(lDAPEntry);
            String string2 = EData.getEntryAttribute(lDAPEntry, wlsCollectionName);
            String string3 = EData.unescapeName(string);
            if (string2 != null) {
                string2 = EData.unescapeName(string2);
            }
            eResource = new EResource(string3, eExpression, bl, string2);
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("  name: " + string3);
                traceLogger.debug(" eexpr: " + eResource.getEntitlement());
                traceLogger.debug("deploy: " + bl);
                if (string2 != null) {
                    traceLogger.debug(" cname: " + string2);
                }
            }
        }
        return eResource;
    }

    public ERole getRoleFromEntry(LDAPEntry lDAPEntry) {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("getRoleFromEntry");
        }
        ERole eRole = null;
        if (lDAPEntry != null) {
            String string = EData.getEntryName(lDAPEntry);
            EExpression eExpression = this.getEntryExpression(lDAPEntry);
            String string2 = EData.getEntryAuxiliary(lDAPEntry);
            boolean bl = EData.getEntryDeployData(lDAPEntry);
            String string3 = EData.getEntryAttribute(lDAPEntry, wlsCollectionName);
            ERoleId eRoleId = EData.name2PK(string);
            EAuxiliary eAuxiliary = null;
            if (string2 != null) {
                eAuxiliary = new EAuxiliary(string2);
            }
            eRole = new ERole(eRoleId, eExpression, eAuxiliary, bl, string3);
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("  name: " + eRoleId.toString());
                traceLogger.debug(" eexpr: " + eRole.getEntitlement());
                traceLogger.debug("deploy: " + bl);
                traceLogger.debug("   aux: " + eAuxiliary);
                if (string3 != null) {
                    traceLogger.debug(" cname: " + string3);
                }
            }
        }
        return eRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createForCollection(EResource[] eResourceArray) throws EnConflictException, EnDuplicateKeyException, EnCreateException {
        if (traceLogger != null && traceLogger.isDebugEnabled()) {
            traceLogger.debug("create resources for collection");
        }
        LDAPConnection lDAPConnection = null;
        try {
            String[] stringArray = EData.getResourceNames(eResourceArray);
            lDAPConnection = EData.getConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.resourceBaseDN, 1, EData.makeNameFilter(stringArray), conflictAttrList, false);
            if (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string = EData.getEntryName(lDAPEntry);
                boolean bl = EData.getEntryDeployData(lDAPEntry);
                String string2 = "Entitlement policy definition for '" + escaper.unescapeString(string) + "' ";
                if (bl) {
                    throw new EnDuplicateKeyException(string2 + "already exist.");
                }
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    String string3 = EData.getEntryAttribute(lDAPEntry, wlsCollectionName);
                    traceLogger.debug("conflict: " + string3 + " -- " + string);
                }
                throw new EnConflictException(string2 + "is customized.");
            }
            for (int i = 0; i < eResourceArray.length; ++i) {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", RESOURCE_OBJ_CLASSES));
                lDAPAttributeSet.add(new LDAPAttribute("cn", stringArray[i]));
                EExpression eExpression = eResourceArray[i].getExpression();
                if (eExpression != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(eexprAttribute, eExpression.serialize()));
                }
                String string = "cn=" + stringArray[i] + "," + this.resourceBaseDN;
                boolean bl = eResourceArray[i].isDeployData();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(WLSCREATORINFO, bl ? "deploy" : "mbean");
                lDAPAttributeSet.add(lDAPAttribute);
                String string4 = eResourceArray[i].getCollectionName();
                if (string4 != null) {
                    lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionName, escaper.escapeString(string4)));
                }
                LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
        }
        catch (LDAPException lDAPException) {
            EData.checkDuplicateException(lDAPException);
        }
        finally {
            if (lDAPConnection != null) {
                EData.releaseConnection(lDAPConnection);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createPolicyCollectionInfo(String string, String string2, String string3) throws EnCreateException, EnConflictException {
        LDAPConnection lDAPConnection = null;
        try {
            String string4 = escaper.escapeString(string);
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("createPolicyCollectionInfo(" + string4 + ")");
            }
            String string5 = "wlsCollectionName=" + string4 + "," + this.policyCollectionBaseDN;
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", POLICY_COL_OBJ_CLASSES));
            lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionName, string4));
            if (string2 != null) {
                lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionVersion, string2));
            }
            if (string3 != null) {
                lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionTimestamp, string3));
            }
            LDAPEntry lDAPEntry = new LDAPEntry(string5, lDAPAttributeSet);
            lDAPConnection = EData.getConnection();
            try {
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 68) {
                    throw new EnCreateException(lDAPException.toString());
                }
                try {
                    lDAPConnection.delete(lDAPEntry.getDN());
                }
                catch (LDAPException lDAPException2) {
                    if (lDAPException2.getLDAPResultCode() != 32) throw new EnCreateException(lDAPException2.toString());
                    if (traceLogger == null || !traceLogger.isDebugEnabled()) throw new EnConflictException(string4 + " conflict.");
                    traceLogger.debug("createPolicyCollectionInfo(): conflict for " + string4);
                    throw new EnConflictException(string4 + " conflict.");
                }
                lDAPConnection.add(lDAPEntry);
            }
            if (lDAPConnection == null) return;
        }
        catch (LDAPException lDAPException) {
            try {
                if (lDAPException.getLDAPResultCode() != 68) throw new EnCreateException(lDAPException.toString());
                if (traceLogger == null || !traceLogger.isDebugEnabled()) throw new EnConflictException(string + " conflict.");
                traceLogger.debug("createPolicyCollectionInfo(): conflict for " + string);
                throw new EnConflictException(string + " conflict.");
            }
            catch (Throwable throwable) {
                if (lDAPConnection == null) throw throwable;
                EData.releaseConnection(lDAPConnection);
                throw throwable;
            }
        }
        EData.releaseConnection(lDAPConnection);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createRoleCollectionInfo(String string, String string2, String string3) throws EnCreateException, EnConflictException {
        LDAPConnection lDAPConnection = null;
        try {
            String string4 = escaper.escapeString(string);
            if (traceLogger != null && traceLogger.isDebugEnabled()) {
                traceLogger.debug("createRoleCollectionInfo(" + string4 + ")");
            }
            String string5 = "wlsCollectionName=" + string4 + "," + this.roleCollectionBaseDN;
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", ROLE_COL_OBJ_CLASSES));
            lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionName, string4));
            if (string2 != null) {
                lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionVersion, string2));
            }
            if (string3 != null) {
                lDAPAttributeSet.add(new LDAPAttribute(wlsCollectionTimestamp, string3));
            }
            LDAPEntry lDAPEntry = new LDAPEntry(string5, lDAPAttributeSet);
            lDAPConnection = EData.getConnection();
            try {
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 68) {
                    throw new EnCreateException(lDAPException.toString());
                }
                try {
                    lDAPConnection.delete(lDAPEntry.getDN());
                }
                catch (LDAPException lDAPException2) {
                    if (lDAPException2.getLDAPResultCode() != 32) throw new EnCreateException(lDAPException2.toString());
                    if (traceLogger == null || !traceLogger.isDebugEnabled()) throw new EnConflictException(string4 + " conflict.");
                    traceLogger.debug("createRoleCollectionInfo(): conflict for " + string4);
                    throw new EnConflictException(string4 + " conflict.");
                }
                lDAPConnection.add(lDAPEntry);
            }
            if (lDAPConnection == null) return;
        }
        catch (LDAPException lDAPException) {
            try {
                if (lDAPException.getLDAPResultCode() != 68) throw new EnCreateException(lDAPException.toString());
                if (traceLogger == null || !traceLogger.isDebugEnabled()) throw new EnConflictException(string + " conflict.");
                traceLogger.debug("createRoleCollectionInfo(): conflict for " + string);
                throw new EnConflictException(string + " conflict.");
            }
            catch (Throwable throwable) {
                if (lDAPConnection == null) throw throwable;
                EData.releaseConnection(lDAPConnection);
                throw throwable;
            }
        }
        EData.releaseConnection(lDAPConnection);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EPolicyCollectionInfo fetchPolicyCollectionInfo(String string) {
        EPolicyCollectionInfo ePolicyCollectionInfo;
        LDAPConnection lDAPConnection;
        block8: {
            lDAPConnection = null;
            try {
                String string2 = escaper.escapeString(string);
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    traceLogger.debug("fetchPolicyCollectionInfo(" + string2 + ")");
                }
                lDAPConnection = EData.getConnection();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.policyCollectionBaseDN, 1, "wlsCollectionName=" + string2, collectionAttrList, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    if (lDAPEntry == null) continue;
                    String string3 = EData.getEntryName(lDAPEntry);
                    String string4 = EData.unescapeName(string3);
                    String string5 = EData.getEntryAttribute(lDAPEntry, wlsCollectionVersion);
                    String string6 = EData.getEntryAttribute(lDAPEntry, wlsCollectionTimestamp);
                    if (traceLogger != null && traceLogger.isDebugEnabled()) {
                        traceLogger.debug("     name: " + string4);
                        traceLogger.debug("  version: " + string5);
                        traceLogger.debug("timestamp: " + string6);
                    }
                    ePolicyCollectionInfo = new EPolicyCollectionInfo(string4, string5, string6);
                    if (lDAPConnection == null) return ePolicyCollectionInfo;
                    break block8;
                }
                if (lDAPConnection == null) return null;
            }
            catch (LDAPException lDAPException) {
                try {
                    EData.checkStorageException(lDAPException);
                    if (lDAPConnection == null) return null;
                }
                catch (Throwable throwable) {
                    if (lDAPConnection == null) throw throwable;
                    EData.releaseConnection(lDAPConnection);
                    throw throwable;
                }
                EData.releaseConnection(lDAPConnection);
                return null;
            }
            EData.releaseConnection(lDAPConnection);
            return null;
        }
        EData.releaseConnection(lDAPConnection);
        return ePolicyCollectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ERoleCollectionInfo fetchRoleCollectionInfo(String string) {
        ERoleCollectionInfo eRoleCollectionInfo;
        LDAPConnection lDAPConnection;
        block8: {
            lDAPConnection = null;
            try {
                String string2 = escaper.escapeString(string);
                if (traceLogger != null && traceLogger.isDebugEnabled()) {
                    traceLogger.debug("fetchRoleCollectionInfo(" + string2 + ")");
                }
                lDAPConnection = EData.getConnection();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.roleCollectionBaseDN, 1, "wlsCollectionName=" + string2, collectionAttrList, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    if (lDAPEntry == null) continue;
                    String string3 = EData.getEntryName(lDAPEntry);
                    String string4 = EData.unescapeName(string3);
                    String string5 = EData.getEntryAttribute(lDAPEntry, wlsCollectionVersion);
                    String string6 = EData.getEntryAttribute(lDAPEntry, wlsCollectionTimestamp);
                    if (traceLogger != null && traceLogger.isDebugEnabled()) {
                        traceLogger.debug("     name: " + string4);
                        traceLogger.debug("  version: " + string5);
                        traceLogger.debug("timestamp: " + string6);
                    }
                    eRoleCollectionInfo = new ERoleCollectionInfo(string4, string5, string6);
                    if (lDAPConnection == null) return eRoleCollectionInfo;
                    break block8;
                }
                if (lDAPConnection == null) return null;
            }
            catch (LDAPException lDAPException) {
                try {
                    EData.checkStorageException(lDAPException);
                    if (lDAPConnection == null) return null;
                }
                catch (Throwable throwable) {
                    if (lDAPConnection == null) throw throwable;
                    EData.releaseConnection(lDAPConnection);
                    throw throwable;
                }
                EData.releaseConnection(lDAPConnection);
                return null;
            }
            EData.releaseConnection(lDAPConnection);
            return null;
        }
        EData.releaseConnection(lDAPConnection);
        return eRoleCollectionInfo;
    }

    protected static String getEntryAttribute(LDAPEntry lDAPEntry, String string) {
        String[] stringArray;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        String string2 = null;
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()) != null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        return string2;
    }

    private class LDAPChangeListener
    implements EmbeddedLDAPChangeListener {
        private EnDataChangeListener listener;

        public LDAPChangeListener(EnDataChangeListener enDataChangeListener) {
            this.listener = enDataChangeListener;
        }

        public void entryChanged(EmbeddedLDAPChange embeddedLDAPChange) {
            int n;
            String string = embeddedLDAPChange.getEntryName();
            if (EnLDAP.traceLogger != null && EnLDAP.traceLogger.isDebugEnabled()) {
                EnLDAP.traceLogger.debug("entryChanged: " + string);
            }
            if (string != null && string.startsWith("cn=") && (n = string.indexOf(44, 3)) > 0) {
                String string2 = string.substring(3, n);
                if (string.endsWith(EData.this.roleBaseDN)) {
                    ERoleId eRoleId = EData.name2PK(string2);
                    this.listener.roleChanged(eRoleId);
                } else if (string.endsWith(EData.this.resourceBaseDN)) {
                    String string3 = escaper.unescapeString(string2);
                    this.listener.resourceChanged(string3);
                } else if (string.endsWith(EData.this.predicateBaseDN)) {
                    String string4 = escaper.unescapeString(string2);
                    this.listener.predicateChanged(string4);
                }
            }
        }
    }
}

