/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.data.ldap;

import java.util.Properties;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPSearchResults;
import weblogic.entitlement.data.EResource;
import weblogic.entitlement.data.EnCursorResourceFilter;
import weblogic.entitlement.data.EnResourceCursor;
import weblogic.entitlement.data.ldap.ECursorBase;
import weblogic.entitlement.data.ldap.EData;
import weblogic.security.shared.LoggerWrapper;

class EResourceCursor
extends ECursorBase
implements EnResourceCursor {
    private EnCursorResourceFilter filter = null;

    public EResourceCursor(LDAPConnection lDAPConnection, LDAPSearchResults lDAPSearchResults, int n, EData eData, LoggerWrapper loggerWrapper) {
        super("ResCur", lDAPConnection, lDAPSearchResults, n, eData, loggerWrapper);
    }

    public EResourceCursor(EnCursorResourceFilter enCursorResourceFilter, LDAPConnection lDAPConnection, LDAPSearchResults lDAPSearchResults, int n, EData eData, LoggerWrapper loggerWrapper) {
        super("ResCurFil", lDAPConnection, lDAPSearchResults, n, eData, loggerWrapper);
        this.filter = enCursorResourceFilter;
        this.getCurrentResource();
    }

    public Properties getCurrentProperties() {
        String string;
        EResource eResource;
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("getCurrentProperties EResource");
        }
        if ((eResource = this.data.getResourceFromEntry(this.getCurrentEntry())) == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("Expression", this.getEntitlement(eResource));
        properties.setProperty("ResourceId", eResource.getName());
        if (eResource.isDeployData()) {
            properties.setProperty("SourceData", "Deployment");
        }
        if ((string = eResource.getCollectionName()) != null) {
            properties.setProperty("CollectionName", string);
        }
        return properties;
    }

    public EResource getCurrentResource() {
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("getCurrentResource");
        }
        EResource eResource = this.data.getResourceFromEntry(this.getCurrentEntry());
        if (this.filter != null && eResource != null) {
            if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
                this.traceLogger.debug("getCurrentResource filter");
            }
            boolean bl = this.filter.isValidResource(eResource);
            while (!bl) {
                this.advance(false);
                eResource = this.data.getResourceFromEntry(this.getCurrentEntry());
                if (eResource == null) break;
                bl = this.filter.isValidResource(eResource);
            }
        }
        return eResource;
    }

    public EResource next() {
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("next EResource");
        }
        EResource eResource = this.getCurrentResource();
        this.advance();
        return eResource;
    }

    public void advance() {
        super.advance();
        if (this.filter != null) {
            this.getCurrentResource();
        }
    }
}

