/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.data.ldap;

import java.util.Properties;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPSearchResults;
import weblogic.entitlement.data.ERole;
import weblogic.entitlement.data.EnCursorRoleFilter;
import weblogic.entitlement.data.EnRoleCursor;
import weblogic.entitlement.data.ldap.ECursorBase;
import weblogic.entitlement.data.ldap.EData;
import weblogic.entitlement.expression.EAuxiliary;
import weblogic.security.shared.LoggerWrapper;

class ERoleCursor
extends ECursorBase
implements EnRoleCursor {
    private EnCursorRoleFilter filter = null;

    public ERoleCursor(LDAPConnection lDAPConnection, LDAPSearchResults lDAPSearchResults, int n, EData eData, LoggerWrapper loggerWrapper) {
        super("RolCur", lDAPConnection, lDAPSearchResults, n, eData, loggerWrapper);
    }

    public ERoleCursor(EnCursorRoleFilter enCursorRoleFilter, LDAPConnection lDAPConnection, LDAPSearchResults lDAPSearchResults, int n, EData eData, LoggerWrapper loggerWrapper) {
        super("RolCurFil", lDAPConnection, lDAPSearchResults, n, eData, loggerWrapper);
        this.filter = enCursorRoleFilter;
        this.getCurrentRole();
    }

    public Properties getCurrentProperties() {
        String string;
        EAuxiliary eAuxiliary;
        ERole eRole;
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("getCurrentProperties ERole");
        }
        if ((eRole = this.data.getRoleFromEntry(this.getCurrentEntry())) == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("RoleName", eRole.getName());
        properties.setProperty("Expression", this.getEntitlement(eRole));
        String string2 = eRole.getResourceName();
        if ("" != string2) {
            properties.setProperty("ResourceId", string2);
        }
        if (eRole.isDeployData()) {
            properties.setProperty("SourceData", "Deployment");
        }
        if ((eAuxiliary = eRole.getAuxiliary()) != null) {
            properties.setProperty("AuxiliaryData", eAuxiliary.toString());
        }
        if ((string = eRole.getCollectionName()) != null) {
            properties.setProperty("CollectionName", string);
        }
        return properties;
    }

    public ERole getCurrentRole() {
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("getCurrentRole");
        }
        ERole eRole = this.data.getRoleFromEntry(this.getCurrentEntry());
        if (this.filter != null && eRole != null) {
            if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
                this.traceLogger.debug("getCurrentRole filter");
            }
            boolean bl = this.filter.isValidRole(eRole);
            while (!bl) {
                this.advance(false);
                eRole = this.data.getRoleFromEntry(this.getCurrentEntry());
                if (eRole == null) break;
                bl = this.filter.isValidRole(eRole);
            }
        }
        return eRole;
    }

    public ERole next() {
        if (this.traceLogger != null && this.traceLogger.isDebugEnabled()) {
            this.traceLogger.debug("next ERole");
        }
        ERole eRole = this.getCurrentRole();
        this.advance();
        return eRole;
    }

    public void advance() {
        super.advance();
        if (this.filter != null) {
            this.getCurrentRole();
        }
    }
}

