/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.data.ldap;

import java.util.Properties;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import weblogic.entitlement.data.EnCredentialException;
import weblogic.entitlement.data.EnDomainException;
import weblogic.entitlement.data.EnStorageException;
import weblogic.ldap.EmbeddedLDAPConnection;
import weblogic.security.shared.LoggerWrapper;

public class EnLDAP {
    public static final String LDAP_DOMAIN = "weblogic.entitlement.data.ldap.domain";
    public static final String LDAP_REALM = "weblogic.entitlement.data.ldap.realm";
    public static final String LDAP_HOST = "weblogic.entitlement.data.ldap.hostname";
    public static final String LDAP_PORT = "weblogic.entitlement.data.ldap.port";
    public static final String LDAP_PASSWORD = "weblogic.entitlement.data.ldap.password";
    public static final String LDAP_USELOCAL = "weblogic.entitlement.data.ldap.uselocal";
    private static String host = "localhost";
    private static int port = 7003;
    private static String password = null;
    private static String domainName = "mydomain";
    private static boolean useLocal = false;
    protected String realmName = "myrealm";
    private static final String admin = "cn=admin";
    private static LDAPConnection[] ldPool = null;
    private static int ldPoolCount = 0;
    private static LDAPSearchConstraints constraint = null;
    protected static String domainDN = null;
    protected String realmDN = null;
    protected static final String nameAttribute = "cn";
    protected static final int LDAP_VERSION = 2;
    protected static final String[] noAttrs = new String[]{"1.1"};
    protected static final String[] nameAttributeList = new String[]{"cn"};
    protected static final String NAME_DELIMITER = "::";
    protected static LoggerWrapper traceLogger = LoggerWrapper.getInstance("SecurityEEngine");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnLDAP(Properties properties) {
        Object object;
        if (traceLogger.isDebugEnabled()) {
            traceLogger.debug("Initializing EnLDAP.");
        }
        if (properties != null) {
            object = properties.getProperty(LDAP_PORT);
            if (object != null) {
                port = Integer.valueOf((String)object);
            }
            if ((object = properties.getProperty(LDAP_HOST)) != null) {
                host = object;
            }
            if ((object = properties.getProperty(LDAP_PASSWORD)) != null) {
                password = object;
            }
            if ((object = properties.getProperty(LDAP_DOMAIN)) != null) {
                domainName = object;
            }
            if ((object = properties.getProperty(LDAP_REALM)) != null) {
                this.realmName = object;
            }
            if ((object = properties.getProperty(LDAP_USELOCAL)) != null && "true".equals(object)) {
                useLocal = true;
            }
        }
        domainDN = "dc=" + domainName;
        this.realmDN = "ou=" + this.realmName + "," + domainDN;
        if (ldPool != null) return;
        object = EnLDAP.class;
        synchronized (EnLDAP.class) {
            if (ldPool != null) return;
            ldPool = new LDAPConnection[16];
            int n = 3;
            block16: while (n != 0) {
                LDAPConnection lDAPConnection = null;
                try {
                    lDAPConnection = EnLDAP.getConnection();
                    constraint = lDAPConnection.getSearchConstraints();
                    EnLDAP.addStructuralEntry(lDAPConnection, domainDN, true, domainName);
                    EnLDAP.addStructuralEntry(lDAPConnection, this.realmDN, false, this.realmName);
                    n = 0;
                }
                catch (LDAPException lDAPException) {
                    lDAPConnection = null;
                    EnStorageException enStorageException = null;
                    if (traceLogger.isDebugEnabled()) {
                        traceLogger.debug("EnLDAP(), LDAPException while trying to initialize LDAP", lDAPException);
                    }
                    switch (lDAPException.getLDAPResultCode()) {
                        case 49: {
                            enStorageException = new EnCredentialException(lDAPException.toString());
                            break;
                        }
                        case 53: {
                            enStorageException = new EnDomainException(lDAPException.toString());
                            break;
                        }
                        case 91: {
                            if (n > 1) {
                                --n;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                continue block16;
                            }
                        }
                        default: {
                            enStorageException = new EnStorageException(lDAPException.toString());
                        }
                    }
                    ldPool = null;
                    throw enStorageException;
                }
                finally {
                    if (lDAPConnection != null) {
                        EnLDAP.releaseConnection(lDAPConnection);
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static LDAPConnection getConnection() throws LDAPException {
        EmbeddedLDAPConnection embeddedLDAPConnection = null;
        if (ldPoolCount > 0) {
            Class<LDAPConnection> clazz = LDAPConnection.class;
            // MONITORENTER : netscape.ldap.LDAPConnection.class
            if (ldPoolCount > 0) {
                embeddedLDAPConnection = ldPool[--ldPoolCount];
                EnLDAP.ldPool[EnLDAP.ldPoolCount] = null;
            }
            // MONITOREXIT : clazz
        }
        if (embeddedLDAPConnection != null) return embeddedLDAPConnection;
        embeddedLDAPConnection = useLocal ? new EmbeddedLDAPConnection(false) : new LDAPConnection();
        embeddedLDAPConnection.connect(host, port);
        embeddedLDAPConnection.bind(2, admin, password);
        return embeddedLDAPConnection;
    }

    protected static synchronized void releaseConnection(LDAPConnection lDAPConnection) {
        if (ldPoolCount == ldPool.length) {
            LDAPConnection[] lDAPConnectionArray = new LDAPConnection[ldPoolCount + 16];
            System.arraycopy(ldPool, 0, lDAPConnectionArray, 0, ldPoolCount);
            ldPool = lDAPConnectionArray;
        }
        EnLDAP.ldPool[EnLDAP.ldPoolCount++] = lDAPConnection;
    }

    protected static void addEntry(LDAPConnection lDAPConnection, String string, boolean bl, String string2) throws LDAPException {
        String[] stringArray = new String[]{"top", bl ? "domain" : "organizationalUnit"};
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
        lDAPAttributeSet.add(new LDAPAttribute(bl ? "dc" : "ou", string2));
        LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    protected static void addStructuralEntry(LDAPConnection lDAPConnection, String string, boolean bl, String string2) throws LDAPException {
        block2: {
            try {
                EnLDAP.addEntry(lDAPConnection, string, bl, string2);
            }
            catch (LDAPException lDAPException) {
                if (68 == lDAPException.getLDAPResultCode()) break block2;
                throw lDAPException;
            }
        }
    }

    protected static void checkStorageException(LDAPException lDAPException) {
        if (traceLogger.isDebugEnabled()) {
            traceLogger.debug("LDAPException: ", lDAPException);
        }
        switch (lDAPException.getLDAPResultCode()) {
            case 52: 
            case 81: 
            case 91: {
                throw new EnStorageException(lDAPException.getMessage());
            }
        }
    }

    protected static String PK2Name(String string, String string2) {
        if (string == null) {
            string = "*";
        }
        return string + NAME_DELIMITER + string2;
    }
}

