/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.engine;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import weblogic.entitlement.EntitlementLogger;
import weblogic.entitlement.data.EPolicyCollectionInfo;
import weblogic.entitlement.data.EResource;
import weblogic.entitlement.data.ERole;
import weblogic.entitlement.data.ERoleCollectionInfo;
import weblogic.entitlement.data.ERoleId;
import weblogic.entitlement.data.EnConflictException;
import weblogic.entitlement.data.EnCreateException;
import weblogic.entitlement.data.EnCursorResourceFilter;
import weblogic.entitlement.data.EnCursorRoleFilter;
import weblogic.entitlement.data.EnData;
import weblogic.entitlement.data.EnDataChangeListener;
import weblogic.entitlement.data.EnDuplicateKeyException;
import weblogic.entitlement.data.EnFinderException;
import weblogic.entitlement.data.EnRemoveException;
import weblogic.entitlement.data.EnResourceCursor;
import weblogic.entitlement.data.EnRoleCursor;
import weblogic.entitlement.engine.ESubject;
import weblogic.entitlement.engine.PredicateRegistry;
import weblogic.entitlement.engine.ResourceNode;
import weblogic.entitlement.engine.ResourceNodeImpl;
import weblogic.entitlement.engine.UnregisteredPredicateException;
import weblogic.entitlement.engine.cache.ResourceDecisionCache;
import weblogic.entitlement.expression.EAuxiliary;
import weblogic.entitlement.expression.EExpression;
import weblogic.entitlement.expression.InvalidPredicateClassException;
import weblogic.entitlement.parser.Parser;
import weblogic.entitlement.util.Cache;
import weblogic.entitlement.util.SecondChanceCache;
import weblogic.entitlement.util.TextFilter;
import weblogic.entitlement.util.Version;
import weblogic.security.SecurityLogger;
import weblogic.security.providers.authorization.AugmentedContext;
import weblogic.security.providers.authorization.Predicate;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.SecurityRole;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.spi.Resource;
import weblogic.security.utils.ESubjectImpl;
import weblogic.utils.collections.CombinedSet;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.collections.ConcurrentHashSet;

public class EEngine
implements EnDataChangeListener,
PredicateRegistry {
    private static final LoggerWrapper LOG = LoggerWrapper.getInstance("SecurityEEngine");
    private static final Version VERSION = new Version("EEngine", 1, 1, "Build $Date: 2002/01/09 16:41:30 $", "$Revision: 1.57 $");
    public static final String ENTITLEMENT_PROPERTIES = "entitlement.properties";
    public static final String EN_DATA_CLASS_PROPERTY = "weblogic.entitlement.engine.endata_class";
    public static final String ROLE_CACHE_SIZE_PROPERTY = "weblogic.entitlement.engine.cache.max_role_count";
    public static final String RSRC_CACHE_SIZE_PROPERTY = "weblogic.entitlement.engine.cache.max_resource_count";
    public static final String PRED_CACHE_SIZE_PROPERTY = "weblogic.entitlement.engine.cache.max_predicate_count";
    public static final String PRELOAD_CACHE_PROPERTY = "weblogic.entitlement.engine.cache.preload";
    public static final String EN_DATA_CLASS = "weblogic.entitlement.data.ldap.EnDataImp";
    public static final String ROLE_DECISION_CACHE_SIZE_PROPERTY = "weblogic.entitlement.engine.cache.max_role_decision_count";
    public static final String RSRC_DECISION_CACHE_SIZE_PROPERTY = "weblogic.entitlement.engine.cache.max_resource_decision_count";
    public static final String DECISION_CACHE_CLASSES_PROPERTY = "weblogic.entitlement.engine.cache.decision_classes";
    private static final EResource NO_RESOURCE = new EResource("", null);
    private static final ERole NO_ROLE = new ERole("", "", null);
    private static final EDecision ABSTAIN_DECISION = new EDecision(null);
    private static EEngine mEngine = null;
    private Cache mResourceCache;
    private long mResChangeNum;
    private ResourceDecisionCache mResourceDecisionCache;
    private Cache mRoleCache;
    private long mRoleChangeNum;
    private ResourceDecisionCache mRoleDecisionCache;
    private Set mDecisionCacheClasses;
    private Cache mPredicateCache;
    private long mPredChangeNum;
    private EnData mEnData;

    public static EEngine getInstance() {
        return mEngine != null ? mEngine : EEngine.getInstance(EEngine.readProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EEngine getInstance(Properties properties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getInstance\n");
        }
        if (mEngine != null) return mEngine;
        Class<EEngine> clazz = EEngine.class;
        synchronized (EEngine.class) {
            if (mEngine != null) return mEngine;
            mEngine = new EEngine(properties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mEngine;
        }
    }

    private EEngine(Properties properties) {
        String string = null;
        String string2 = null;
        try {
            string = ROLE_CACHE_SIZE_PROPERTY;
            string2 = properties.getProperty(string, "2000");
            int n = Integer.valueOf(string2);
            this.mRoleCache = new SecondChanceCache(n);
            string = ROLE_DECISION_CACHE_SIZE_PROPERTY;
            string2 = System.getProperty(string, "6000");
            n = Integer.valueOf(string2);
            if (n > 0) {
                this.mRoleDecisionCache = new ResourceDecisionCache(n);
            }
            string = RSRC_CACHE_SIZE_PROPERTY;
            string2 = properties.getProperty(string, "5000");
            n = Integer.valueOf(string2);
            this.mResourceCache = new SecondChanceCache(n);
            string = RSRC_DECISION_CACHE_SIZE_PROPERTY;
            string2 = System.getProperty(string, "15000");
            n = Integer.valueOf(string2);
            if (n > 0) {
                this.mResourceDecisionCache = new ResourceDecisionCache(n);
            }
            if ((this.mRoleDecisionCache != null || this.mResourceDecisionCache != null) && (string2 = System.getProperty(string = DECISION_CACHE_CLASSES_PROPERTY, "weblogic.security.service.JMSResource,weblogic.security.service.JDBCResource,weblogic.security.service.JMXResource")).length() > 0) {
                this.mDecisionCacheClasses = new HashSet();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.length() <= 0) continue;
                    try {
                        this.mDecisionCacheClasses.add(Class.forName(string3));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Failed to load decision cache resource class: " + string3);
                    }
                }
            }
            string = PRED_CACHE_SIZE_PROPERTY;
            string2 = properties.getProperty(string, "200");
            n = Integer.valueOf(string2);
            this.mPredicateCache = new SecondChanceCache(n);
        }
        catch (Exception exception) {
            EntitlementLogger.logInvalidPropertyValue((String)string, string2);
            EEngine.abort("Invalid value \"" + string2 + "\" for property \"" + string + "\"\nPositive integer is expected", exception);
        }
        this.mEnData = EEngine.makeEnData(properties);
        boolean bl = new Boolean(properties.getProperty(PRELOAD_CACHE_PROPERTY, "false"));
        if (bl) {
            this.preload();
        }
        this.mEnData.setDataChangeListener(this);
    }

    public Map getRoleMap(Subject subject, Resource resource, ContextHandler contextHandler) {
        ECacheableRoles eCacheableRoles;
        boolean bl;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getRoleMap (" + new ESubjectImpl(subject) + " , " + resource.toString() + ")\n");
        }
        boolean bl2 = bl = this.mRoleDecisionCache != null && (this.mDecisionCacheClasses == null || this.mDecisionCacheClasses.contains(resource.getClass()));
        if (bl && (eCacheableRoles = (ECacheableRoles)this.mRoleDecisionCache.lookupDecision(resource, subject)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getRoleMap returning roles from decision cache");
            }
            return new ERoleMapImpl(subject, resource, contextHandler, eCacheableRoles);
        }
        eCacheableRoles = new ECacheableRoles();
        if (bl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caching roles for getRoleMap (" + new ESubjectImpl(subject) + " , " + resource.toString() + ")\n");
            }
            this.mRoleDecisionCache.cacheDecision(resource, subject, eCacheableRoles);
        }
        return new ERoleMapImpl(subject, resource, contextHandler, eCacheableRoles);
    }

    private boolean checkCacheability(EExpression eExpression, int n) {
        if (eExpression == null) {
            return true;
        }
        return this.checkCacheability(eExpression.getDependsOn(), n);
    }

    private boolean checkCacheability(int n, int n2) {
        return (n | n2) == n2;
    }

    private boolean evaluate(ESubject eSubject, ERole eRole, ResourceNode resourceNode, ContextHandler contextHandler) {
        boolean bl;
        block6: {
            bl = false;
            EExpression eExpression = eRole.getExpression();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluating role " + eRole.getPrimaryKey() + " with expression: " + (eExpression == null ? "null" : eExpression.externalize()));
            }
            if (eExpression != null) {
                EAuxiliary eAuxiliary;
                if (contextHandler != null && (eAuxiliary = eRole.getAuxiliary()) != null) {
                    contextHandler = new AugmentedContext(contextHandler, "com.bea.contextelement.entitlement.EAuxiliaryID", (Object)eAuxiliary);
                }
                try {
                    bl = eExpression.evaluate(eSubject, resourceNode, contextHandler, this);
                }
                catch (UnregisteredPredicateException unregisteredPredicateException) {
                    EntitlementLogger.logRoleUnregisteredPredicate((String)eRole.getPrimaryKey().toString(), (String)unregisteredPredicateException.getPredicateName());
                }
                catch (Exception exception) {
                    EntitlementLogger.logPolicyEvaluationFailed((String)eRole.getEntitlement(), (String)eRole.getPrimaryKey().toString());
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Caught exception thrown while evaluating role expression", exception);
                }
            }
        }
        return bl;
    }

    private Collection getRoles(ResourceNode resourceNode) {
        String[] stringArray = resourceNode.getNamePathToRoot();
        HashMap<String, ERole> hashMap = new HashMap<String, ERole>();
        String string = "";
        for (int i = stringArray.length; i >= 0; --i) {
            if (i < stringArray.length) {
                string = stringArray[i];
            }
            ERole[] eRoleArray = this.getRoles(string);
            for (int j = 0; j < eRoleArray.length; ++j) {
                hashMap.put(eRoleArray[j].getName(), eRoleArray[j]);
            }
        }
        return hashMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ERole[] getRoles(String string) {
        RoleCacheEntry roleCacheEntry;
        if (string == null) {
            string = "";
        }
        if ((roleCacheEntry = (RoleCacheEntry)this.mRoleCache.get(string)) != null && roleCacheEntry.all) {
            Cache cache = this.mRoleCache;
            synchronized (cache) {
                if (roleCacheEntry.all) {
                    return roleCacheEntry.values().toArray(new ERole[roleCacheEntry.size()]);
                }
            }
        }
        long l = this.mRoleChangeNum;
        Collection collection = this.mEnData.fetchRoles(string);
        ERole[] eRoleArray = collection.toArray(new ERole[collection.size()]);
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            if (l == this.mRoleChangeNum) {
                this.updateRoleCache(string, eRoleArray);
            }
        }
        return eRoleArray;
    }

    private ERole getRole(ResourceNode resourceNode, String string) {
        String[] stringArray = resourceNode.getNamePathToRoot();
        ERole eRole = null;
        ArrayList<String> arrayList = null;
        for (int i = 0; i <= stringArray.length; ++i) {
            String string2 = i < stringArray.length ? stringArray[i] : "";
            eRole = this.getFromRoleCache(string2, string);
            if (eRole != null) {
                if (eRole == NO_ROLE) continue;
                break;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>(stringArray.length);
            }
            arrayList.add(string2);
        }
        if (eRole == NO_ROLE) {
            eRole = null;
        }
        if (arrayList != null) {
            ERoleId[] eRoleIdArray = new ERoleId[arrayList.size()];
            for (int i = 0; i < eRoleIdArray.length; ++i) {
                eRoleIdArray[i] = new ERoleId((String)arrayList.get(i), string);
            }
            try {
                ERole[] eRoleArray = this.getRoles(eRoleIdArray, true);
                for (int i = 0; i < eRoleArray.length; ++i) {
                    if (eRoleArray[i] == null) continue;
                    return eRoleArray[i];
                }
            }
            catch (EnFinderException enFinderException) {
                EEngine.abort("Caught EnFinderException while ignoreNotFound was set to true", enFinderException);
            }
        }
        return eRole;
    }

    public Boolean evaluate(Subject subject, Map map, Resource resource, ContextHandler contextHandler) {
        Object object;
        boolean bl;
        if (LOG.isDebugEnabled()) {
            LOG.debug("evaluate(" + new ESubjectImpl(subject, map) + ", " + resource.toString() + ")\n");
        }
        boolean bl2 = bl = this.mResourceDecisionCache != null && (this.mDecisionCacheClasses == null || this.mDecisionCacheClasses.contains(resource.getClass()));
        if (bl && (object = (EDecision)this.mResourceDecisionCache.lookupDecision(resource, subject)) != null) {
            if (((EDecision)object).isApplicable(map)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("evaluate returning value from decision cache");
                }
                return ((EDecision)object).getDecision();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("evauate decision cache hit not applicable to current roles -- remove from cache");
            }
            this.mResourceDecisionCache.uncacheDecision(resource, subject);
        }
        object = Boolean.FALSE;
        ResourceNodeImpl resourceNodeImpl = new ResourceNodeImpl(resource);
        EResource eResource = this.getPolicyResource(resourceNodeImpl);
        if (eResource == null) {
            object = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("No resource found, cannot evaluate");
            }
            if (bl) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caching abstain for evaluate (" + new ESubjectImpl(subject, map) + " , " + resource.toString() + ")\n");
                }
                this.mResourceDecisionCache.cacheDecision(resource, subject, ABSTAIN_DECISION);
            }
        } else {
            EExpression eExpression = eResource.getExpression();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluating resource " + eResource.toString() + " with expression: " + (eExpression == null ? "null" : eExpression.externalize()));
            }
            if (eExpression != null) {
                int n;
                block26: {
                    try {
                        if (eExpression.evaluate(new ESubjectImpl(subject, map), resourceNodeImpl, contextHandler, this)) {
                            object = Boolean.TRUE;
                        }
                    }
                    catch (UnregisteredPredicateException unregisteredPredicateException) {
                        EntitlementLogger.logResourceUnregisteredPredicate((String)eResource.getName(), (String)unregisteredPredicateException.getPredicateName());
                    }
                    catch (Exception exception) {
                        EntitlementLogger.logPolicyEvaluationFailed((String)eExpression.externalize(), (String)eResource.getName());
                        if (!LOG.isDebugEnabled()) break block26;
                        LOG.debug("Caught exception thrown while evaluating resource expression", exception);
                    }
                }
                if (bl && this.checkCacheability(n = eExpression.getDependsOn(), 3)) {
                    if ((n & 2) != 0) {
                        if (map == null || map instanceof ERoleMapImpl && ((ERoleMapImpl)map).isCacheableOnly()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Caching role-dependent decision for evaluate (" + new ESubjectImpl(subject, map) + " , " + resource.toString() + ")\n");
                            }
                            this.mResourceDecisionCache.cacheDecision(resource, subject, new ERoleDependentDecision((Boolean)object, map != null ? ((ERoleMapImpl)map).ecr : null));
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Caching decision for evaluate (" + new ESubjectImpl(subject, map) + " , " + resource.toString() + ")\n");
                        }
                        this.mResourceDecisionCache.cacheDecision(resource, subject, new EDecision((Boolean)object));
                    }
                }
            } else if (bl) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caching empty expression for evaluate (" + new ESubjectImpl(subject, map) + " , " + resource.toString() + ")\n");
                }
                this.mResourceDecisionCache.cacheDecision(resource, subject, ABSTAIN_DECISION);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluation result: " + object);
        }
        return object;
    }

    public EResource getPolicyResource(Resource resource) {
        return this.getPolicyResource(new ResourceNodeImpl(resource));
    }

    public EResource getPolicyResource(ResourceNode resourceNode) {
        String[] stringArray = resourceNode.getNamePathToRoot();
        EResource[] eResourceArray = null;
        try {
            eResourceArray = this.getResources(stringArray, true);
        }
        catch (EnFinderException enFinderException) {
            EEngine.abort("Caught EnFinderException while ignoreNotFound was set to true", enFinderException);
        }
        EResource eResource = null;
        for (int i = 0; i < eResourceArray.length; ++i) {
            if (eResourceArray[i] == null || (eResource = eResourceArray[i]).getExpression() == null) continue;
            return eResource;
        }
        return eResource;
    }

    public void createRoles(ERoleId[] eRoleIdArray, String[] stringArray, boolean bl) throws EnDuplicateKeyException, EnCreateException {
        this.createRoles(eRoleIdArray, stringArray, new String[0], bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRoles(ERoleId[] eRoleIdArray, String[] stringArray, String[] stringArray2, boolean bl) throws EnDuplicateKeyException, EnCreateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createRoles (");
            for (int i = 0; i < eRoleIdArray.length; ++i) {
                LOG.debug("[" + eRoleIdArray[i] + " -- " + stringArray[i] + "]");
            }
            LOG.debug(")\n");
        }
        ERole[] eRoleArray = new ERole[eRoleIdArray.length];
        int n = -1;
        try {
            for (n = 0; n < eRoleArray.length; ++n) {
                EExpression eExpression = stringArray[n] == null ? null : Parser.parseRoleExpression(stringArray[n]);
                EAuxiliary eAuxiliary = null;
                if (n < stringArray2.length && stringArray2[n] != null) {
                    eAuxiliary = new EAuxiliary(stringArray2[n]);
                }
                eRoleArray[n] = new ERole(eRoleIdArray[n], eExpression, eAuxiliary, bl);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        long l = this.mRoleChangeNum;
        this.mEnData.create(eRoleArray, bl);
        if (this.mRoleDecisionCache != null) {
            for (int i = 0; i < eRoleArray.length; ++i) {
                this.mRoleDecisionCache.uncache(eRoleArray[i].getResourceName());
            }
        }
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            long l2 = this.mRoleChangeNum++;
            if (l == l2) {
                this.updateRoleCache(eRoleArray);
            } else {
                this.discardFromRoleCache(eRoleIdArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoles(ERoleId[] eRoleIdArray) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removeRoles (" + eRoleIdArray + ")\n");
        }
        long l = this.mRoleChangeNum;
        this.mEnData.removeRoles(eRoleIdArray);
        if (this.mRoleDecisionCache != null) {
            for (int i = 0; i < eRoleIdArray.length; ++i) {
                this.mRoleDecisionCache.uncache(eRoleIdArray[i].getResourceName());
            }
        }
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            long l2 = this.mRoleChangeNum++;
            if (l == l2) {
                this.removeFromRoleCache(eRoleIdArray);
            } else {
                this.discardFromRoleCache(eRoleIdArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createResourceForCollection(String string, String[] stringArray, String[] stringArray2) throws EnConflictException, EnDuplicateKeyException, EnCreateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createResourceForCollection (" + string + " -- ");
            for (int i = 0; i < stringArray.length; ++i) {
                LOG.debug("[" + stringArray[i] + " -- " + stringArray2[i] + "]");
            }
            LOG.debug(")\n");
        }
        EResource[] eResourceArray = new EResource[stringArray.length];
        int n = -1;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                EExpression eExpression = stringArray2[n] == null ? null : Parser.parseResourceExpression(stringArray2[n]);
                eResourceArray[n] = new EResource(stringArray[n], eExpression, true, string);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        long l = this.mResChangeNum;
        this.mEnData.createForCollection(eResourceArray);
        if (this.mResourceDecisionCache != null) {
            for (int i = 0; i < eResourceArray.length; ++i) {
                this.mResourceDecisionCache.uncache(eResourceArray[i].getName());
            }
        }
        Cache cache = this.mResourceCache;
        synchronized (cache) {
            long l2 = this.mResChangeNum++;
            if (l == l2) {
                this.updateResourceCache(eResourceArray);
            } else {
                this.discardFromResourceCache(stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createResources(String[] stringArray, String[] stringArray2, boolean bl) throws EnDuplicateKeyException, EnCreateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createResources (");
            for (int i = 0; i < stringArray.length; ++i) {
                LOG.debug("[" + stringArray[i] + " -- " + stringArray2[i] + "]");
            }
            LOG.debug(")\n");
        }
        EResource[] eResourceArray = new EResource[stringArray.length];
        int n = -1;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                EExpression eExpression = stringArray2[n] == null ? null : Parser.parseResourceExpression(stringArray2[n]);
                eResourceArray[n] = new EResource(stringArray[n], eExpression, bl);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        long l = this.mResChangeNum;
        this.mEnData.create(eResourceArray, bl);
        if (this.mResourceDecisionCache != null) {
            for (int i = 0; i < eResourceArray.length; ++i) {
                this.mResourceDecisionCache.uncache(eResourceArray[i].getName());
            }
        }
        Cache cache = this.mResourceCache;
        synchronized (cache) {
            long l2 = this.mResChangeNum++;
            if (l == l2) {
                this.updateResourceCache(eResourceArray);
            } else {
                this.discardFromResourceCache(stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResources(String[] stringArray) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removeResources (" + stringArray + ")\n");
        }
        long l = this.mResChangeNum;
        this.mEnData.removeResources(stringArray);
        if (this.mResourceDecisionCache != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.mResourceDecisionCache.uncache(stringArray[i]);
            }
        }
        Cache cache = this.mResourceCache;
        synchronized (cache) {
            long l2 = this.mResChangeNum++;
            if (l == l2) {
                this.removeFromResourceCache(stringArray);
            } else {
                this.discardFromResourceCache(stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoleEntitlements(ERoleId[] eRoleIdArray, String[] stringArray, boolean bl) throws EnCreateException, EnFinderException {
        int n;
        ERole[] eRoleArray;
        if (LOG.isDebugEnabled()) {
            eRoleArray = new StringBuffer();
            eRoleArray.append("setRoleEntitlements (");
            for (n = 0; n < eRoleIdArray.length; ++n) {
                eRoleArray.append("[" + eRoleIdArray[n] + " -- " + stringArray[n] + "]");
            }
            eRoleArray.append(")\n");
            LOG.debug(eRoleArray.toString());
        }
        eRoleArray = new ERole[eRoleIdArray.length];
        n = -1;
        try {
            for (n = 0; n < eRoleArray.length; ++n) {
                EExpression eExpression = stringArray[n] == null ? null : Parser.parseRoleExpression(stringArray[n]);
                eRoleArray[n] = new ERole(eRoleIdArray[n], eExpression, bl);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        long l = this.mRoleChangeNum;
        this.mEnData.update(eRoleArray, bl);
        if (this.mRoleDecisionCache != null) {
            for (int i = 0; i < eRoleArray.length; ++i) {
                this.mRoleDecisionCache.uncache(eRoleArray[i].getResourceName());
            }
        }
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            long l2 = this.mRoleChangeNum++;
            if (l == l2) {
                this.updateRoleCache(eRoleArray);
            } else {
                this.discardFromRoleCache(eRoleIdArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRoleEntitlementsForCollection(String string, ERoleId[] eRoleIdArray, String[] stringArray) throws EnConflictException, EnDuplicateKeyException, EnCreateException {
        ERole[] eRoleArray = new ERole[eRoleIdArray.length];
        int n = -1;
        try {
            for (n = 0; n < eRoleArray.length; ++n) {
                EExpression eExpression = stringArray[n] == null ? null : Parser.parseRoleExpression(stringArray[n]);
                eRoleArray[n] = new ERole(eRoleIdArray[n], eExpression, true, string);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        long l = this.mRoleChangeNum;
        this.mEnData.createForCollection(eRoleArray);
        if (this.mRoleDecisionCache != null) {
            for (int i = 0; i < eRoleArray.length; ++i) {
                this.mRoleDecisionCache.uncache(eRoleArray[i].getResourceName());
            }
        }
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            long l2 = this.mRoleChangeNum++;
            if (l == l2) {
                this.updateRoleCache(eRoleArray);
            } else {
                this.discardFromRoleCache(eRoleIdArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoleEntitlementsForCollection(String string, ERoleId[] eRoleIdArray, String[] stringArray) throws EnCreateException, EnFinderException {
        ERole[] eRoleArray = new ERole[eRoleIdArray.length];
        int n = -1;
        try {
            for (n = 0; n < eRoleArray.length; ++n) {
                EExpression eExpression = stringArray[n] == null ? null : Parser.parseRoleExpression(stringArray[n]);
                eRoleArray[n] = new ERole(eRoleIdArray[n], eExpression, true, string);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        long l = this.mRoleChangeNum;
        this.mEnData.update(eRoleArray, true);
        if (this.mRoleDecisionCache != null) {
            for (int i = 0; i < eRoleArray.length; ++i) {
                this.mRoleDecisionCache.uncache(eRoleArray[i].getResourceName());
            }
        }
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            long l2 = this.mRoleChangeNum++;
            if (l == l2) {
                this.updateRoleCache(eRoleArray);
            } else {
                this.discardFromRoleCache(eRoleIdArray);
            }
        }
    }

    public String[] getRoleEntitlements(ERoleId[] eRoleIdArray) throws EnFinderException {
        ERole[] eRoleArray;
        if (LOG.isDebugEnabled()) {
            eRoleArray = new StringBuffer("getRoleEntitlements ([");
            for (int i = 0; i < eRoleIdArray.length; ++i) {
                eRoleArray.append(eRoleIdArray[i]);
                if (i + 1 >= eRoleIdArray.length) continue;
                eRoleArray.append(",");
            }
            eRoleArray.append("])\n");
            LOG.debug(eRoleArray.toString());
        }
        eRoleArray = this.getRoles(eRoleIdArray, false);
        String[] stringArray = new String[eRoleArray.length];
        for (int i = 0; i < eRoleArray.length; ++i) {
            stringArray[i] = eRoleArray[i].getEntitlement();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoleAuxiliary(ERoleId[] eRoleIdArray, String[] stringArray, boolean bl) throws EnCreateException, EnFinderException {
        int n;
        ERole[] eRoleArray;
        if (LOG.isDebugEnabled()) {
            eRoleArray = new StringBuffer();
            eRoleArray.append("setRoleAuxiliary (");
            for (n = 0; n < eRoleIdArray.length; ++n) {
                eRoleArray.append("[" + eRoleIdArray[n] + " -- " + stringArray[n] + "]");
            }
            eRoleArray.append(")\n");
            LOG.debug(eRoleArray.toString());
        }
        eRoleArray = new ERole[eRoleIdArray.length];
        n = -1;
        try {
            for (n = 0; n < eRoleArray.length; ++n) {
                EAuxiliary eAuxiliary = stringArray[n] == null ? null : new EAuxiliary(stringArray[n]);
                eRoleArray[n] = new ERole(eRoleIdArray[n], null, eAuxiliary, bl);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        long l = this.mRoleChangeNum;
        this.mEnData.updateAuxiliary(eRoleArray, bl);
        if (this.mRoleDecisionCache != null) {
            for (int i = 0; i < eRoleArray.length; ++i) {
                this.mRoleDecisionCache.uncache(eRoleArray[i].getResourceName());
            }
        }
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            long l2 = this.mRoleChangeNum++;
            if (l == l2) {
                this.updateRoleCache(eRoleArray);
            } else {
                this.discardFromRoleCache(eRoleIdArray);
            }
        }
    }

    public String[] getRoleAuxiliary(ERoleId[] eRoleIdArray) throws EnFinderException {
        ERole[] eRoleArray;
        if (LOG.isDebugEnabled()) {
            eRoleArray = new StringBuffer("getRoleAuxiliary ([");
            for (int i = 0; i < eRoleIdArray.length; ++i) {
                eRoleArray.append(eRoleIdArray[i]);
                if (i + 1 >= eRoleIdArray.length) continue;
                eRoleArray.append(",");
            }
            eRoleArray.append("])\n");
            LOG.debug(eRoleArray.toString());
        }
        eRoleArray = this.getRoles(eRoleIdArray, false);
        String[] stringArray = new String[eRoleArray.length];
        for (int i = 0; i < eRoleArray.length; ++i) {
            stringArray[i] = eRoleArray[i].getAuxiliary().toString();
        }
        return stringArray;
    }

    public void setResourceEntitlementsForCollection(String string, String[] stringArray, String[] stringArray2) throws EnCreateException, EnFinderException {
        int n;
        EResource[] eResourceArray;
        if (LOG.isDebugEnabled()) {
            eResourceArray = new StringBuffer();
            eResourceArray.append("setResourceEntitlementsForCollection (");
            eResourceArray.append(string + " -- ");
            for (n = 0; n < stringArray.length; ++n) {
                eResourceArray.append("[" + stringArray[n] + " -- " + stringArray2[n] + "]");
            }
            eResourceArray.append(")\n");
            LOG.debug(eResourceArray.toString());
        }
        eResourceArray = new EResource[stringArray.length];
        n = -1;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                EExpression eExpression = stringArray2[n] == null ? null : Parser.parseResourceExpression(stringArray2[n]);
                eResourceArray[n] = new EResource(stringArray[n], eExpression, true, string);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        this.setResourceEntitlements(stringArray, eResourceArray, true);
    }

    public void setResourceEntitlements(String[] stringArray, String[] stringArray2, boolean bl) throws EnCreateException, EnFinderException {
        int n;
        EResource[] eResourceArray;
        if (LOG.isDebugEnabled()) {
            eResourceArray = new StringBuffer();
            eResourceArray.append("setResourceEntitlements (");
            for (n = 0; n < stringArray.length; ++n) {
                eResourceArray.append("[" + stringArray[n] + " -- " + stringArray2[n] + "]");
            }
            eResourceArray.append(")\n");
            LOG.debug(eResourceArray.toString());
        }
        eResourceArray = new EResource[stringArray.length];
        n = -1;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                EExpression eExpression = stringArray2[n] == null ? null : Parser.parseResourceExpression(stringArray2[n]);
                eResourceArray[n] = new EResource(stringArray[n], eExpression, bl);
            }
        }
        catch (Exception exception) {
            throw new EnCreateException(exception.getMessage(), n, exception);
        }
        this.setResourceEntitlements(stringArray, eResourceArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResourceEntitlements(String[] stringArray, EResource[] eResourceArray, boolean bl) throws EnFinderException {
        long l = this.mResChangeNum;
        this.mEnData.update(eResourceArray, bl);
        if (this.mResourceDecisionCache != null) {
            for (int i = 0; i < eResourceArray.length; ++i) {
                this.mResourceDecisionCache.uncache(eResourceArray[i].getName());
            }
        }
        Cache cache = this.mResourceCache;
        synchronized (cache) {
            long l2 = this.mResChangeNum++;
            if (l == l2) {
                this.updateResourceCache(eResourceArray);
            } else {
                this.discardFromResourceCache(stringArray);
            }
        }
    }

    public String[] getResourceEntitlements(String[] stringArray) throws EnFinderException {
        EResource[] eResourceArray;
        if (LOG.isDebugEnabled()) {
            eResourceArray = new StringBuffer("getResourceEntitlements ([");
            for (int i = 0; i < stringArray.length; ++i) {
                eResourceArray.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                eResourceArray.append(",");
            }
            eResourceArray.append("])\n");
            LOG.debug(eResourceArray.toString());
        }
        eResourceArray = this.getResources(stringArray, false);
        String[] stringArray2 = new String[eResourceArray.length];
        for (int i = 0; i < eResourceArray.length; ++i) {
            stringArray2[i] = eResourceArray[i].getEntitlement();
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ERole[] getRoles(ERoleId[] eRoleIdArray, boolean bl) throws EnFinderException {
        int n;
        int n2;
        ERole[] eRoleArray = this.getFromRoleCache(eRoleIdArray);
        if (!bl) {
            for (n2 = 0; n2 < eRoleArray.length; ++n2) {
                if (eRoleArray[n2] != NO_ROLE) continue;
                throw new EnFinderException(eRoleArray[n2].toString());
            }
        }
        n2 = 0;
        for (n = 0; n < eRoleArray.length; ++n) {
            if (eRoleArray[n] != null) continue;
            ++n2;
        }
        if (n2 > 0) {
            ERoleId[] eRoleIdArray2 = new ERoleId[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if (eRoleArray[n3] == null) {
                    eRoleIdArray2[n4++] = eRoleIdArray[n3];
                }
                ++n3;
            }
            long l = this.mRoleChangeNum;
            ERole[] eRoleArray2 = this.mEnData.fetchRoles(eRoleIdArray2, bl);
            Cache cache = this.mRoleCache;
            synchronized (cache) {
                boolean bl2 = l != this.mRoleChangeNum;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n2) {
                    if (eRoleArray[n5] == null) {
                        eRoleArray[n5] = eRoleArray2[n6++];
                        if (!bl2) {
                            this.updateRoleCache(eRoleIdArray[n5], eRoleArray[n5]);
                        }
                    }
                    ++n5;
                }
            }
        }
        for (n = 0; n < eRoleArray.length; ++n) {
            if (eRoleArray[n] != NO_ROLE) continue;
            eRoleArray[n] = null;
        }
        return eRoleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EResource[] getResources(String[] stringArray, boolean bl) throws EnFinderException {
        int n;
        int n2;
        EResource[] eResourceArray = this.getFromResourceCache(stringArray);
        if (!bl) {
            for (n2 = 0; n2 < eResourceArray.length; ++n2) {
                if (eResourceArray[n2] != NO_RESOURCE) continue;
                throw new EnFinderException(stringArray[n2]);
            }
        }
        n2 = 0;
        for (n = 0; n < eResourceArray.length; ++n) {
            if (eResourceArray[n] != null) continue;
            ++n2;
        }
        if (n2 > 0) {
            String[] stringArray2 = new String[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if (eResourceArray[n3] == null) {
                    stringArray2[n4++] = stringArray[n3];
                }
                ++n3;
            }
            long l = this.mResChangeNum;
            EResource[] eResourceArray2 = this.mEnData.fetchResources(stringArray2, bl);
            Cache cache = this.mResourceCache;
            synchronized (cache) {
                boolean bl2 = l != this.mResChangeNum;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n2) {
                    if (eResourceArray[n5] == null) {
                        eResourceArray[n5] = eResourceArray2[n6++];
                        if (!bl2) {
                            this.updateResourceCache(stringArray[n5], eResourceArray[n5] == null ? NO_RESOURCE : eResourceArray[n5]);
                        }
                    }
                    ++n5;
                }
            }
        }
        if (bl) {
            for (n = 0; n < eResourceArray.length; ++n) {
                if (eResourceArray[n] != NO_RESOURCE) continue;
                eResourceArray[n] = null;
            }
        }
        return eResourceArray;
    }

    public Collection getRoleIds(String string, String string2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getRoleIds-scoped (" + string + ", " + string2 + ")\n");
        }
        TextFilter textFilter = string2 == null ? null : new TextFilter(string2);
        return this.mEnData.fetchRoleIds(string, textFilter);
    }

    public Collection getRoleIds(ResourceNode resourceNode, String string) throws EnFinderException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getRoleIds-all (" + resourceNode.getName() + " , " + string + ")\n");
        }
        TextFilter textFilter = string == null ? null : new TextFilter(string);
        String[] stringArray = resourceNode.getNamePathToRoot();
        ArrayList arrayList = new ArrayList(this.mEnData.fetchRoleIds("", textFilter));
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.addAll(this.mEnData.fetchRoleIds(stringArray[i], textFilter));
        }
        return arrayList;
    }

    public Collection getResourceNames(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResourceNames (" + string + ")\n");
        }
        TextFilter textFilter = string == null ? null : new TextFilter(string);
        return this.mEnData.fetchResourceNames(textFilter);
    }

    public Collection getResourceRoleIds(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResourceRoleIds (" + string + ")\n");
        }
        TextFilter textFilter = string == null ? null : new TextFilter(string);
        return this.mEnData.fetchResourceRoleIds(textFilter);
    }

    public static Version getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPredicates(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getPredicates (" + string + ")\n");
        }
        TextFilter textFilter = string == null ? null : new TextFilter(string);
        long l = this.mPredChangeNum;
        Collection collection = this.mEnData.fetchPredicates(textFilter);
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        Cache cache = this.mPredicateCache;
        synchronized (cache) {
            boolean bl = l != this.mPredChangeNum;
            for (String string2 : collection) {
                boolean bl2;
                block9: {
                    bl2 = true;
                    if (!this.mPredicateCache.containsKey(string2)) {
                        try {
                            EEngine.validatePredicate(string2);
                            if (!bl) {
                                this.mPredicateCache.put(string2, string2);
                            }
                        }
                        catch (InvalidPredicateClassException invalidPredicateClassException) {
                            bl2 = false;
                            EntitlementLogger.logRetrievedInvalidPredicate((String)string2);
                            if (!LOG.isDebugEnabled()) break block9;
                            LOG.debug("Retrieved invalid predicate class name\n" + invalidPredicateClassException.getMessage(), invalidPredicateClassException);
                        }
                    }
                }
                if (!bl2) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(String string) {
        boolean bl;
        block9: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("isRegistered (" + string + ")\n");
            }
            if (bl = this.mPredicateCache.containsKey(string)) {
                return true;
            }
            long l = this.mPredChangeNum;
            bl = this.mEnData.predicateExists(string);
            if (bl) {
                try {
                    EEngine.validatePredicate(string);
                    Cache cache = this.mPredicateCache;
                    synchronized (cache) {
                        boolean bl2;
                        boolean bl3 = bl2 = l != this.mPredChangeNum;
                        if (!bl2) {
                            this.mPredicateCache.put(string, string);
                        }
                    }
                }
                catch (InvalidPredicateClassException invalidPredicateClassException) {
                    bl = false;
                    EntitlementLogger.logRetrievedInvalidPredicate((String)string);
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug("Retrieved invalid predicate class name\n" + invalidPredicateClassException.getMessage(), invalidPredicateClassException);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPredicate(String string) throws InvalidPredicateClassException, EnDuplicateKeyException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerPredicate (" + string + ")\n");
        }
        EEngine.validatePredicate(string);
        long l = this.mPredChangeNum;
        this.mEnData.createPredicate(string);
        Cache cache = this.mPredicateCache;
        synchronized (cache) {
            long l2 = this.mPredChangeNum++;
            if (l == l2) {
                this.mPredicateCache.put(string, string);
            } else {
                this.mPredicateCache.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPredicate(String string) throws EnFinderException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("unregisterPredicate (" + string + ")\n");
        }
        this.mEnData.removePredicate(string);
        Cache cache = this.mPredicateCache;
        synchronized (cache) {
            ++this.mPredChangeNum;
            this.mPredicateCache.remove(string);
        }
    }

    public static Predicate validatePredicate(String string) throws InvalidPredicateClassException {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(privilegedAction);
        try {
            return (Predicate)Class.forName(string, true, classLoader).newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPredicateClassException(string + " class does not implement interface " + Predicate.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidPredicateClassException(string + " class cannot be found ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidPredicateClassException(string + " class's constructor access denied");
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidPredicateClassException("Cannot instantiate predicate class " + string + "\n" + instantiationException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(String string) {
        Cache cache = this.mResourceCache;
        synchronized (cache) {
            ++this.mResChangeNum;
            this.mResourceCache.remove(string);
        }
        if (this.mResourceDecisionCache != null) {
            this.mResourceDecisionCache.uncache(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void roleChanged(ERoleId eRoleId) {
        Cache cache = this.mRoleCache;
        synchronized (cache) {
            ++this.mRoleChangeNum;
            this.discardFromRoleCache(eRoleId);
        }
        if (this.mRoleDecisionCache != null) {
            this.mRoleDecisionCache.uncache(eRoleId.getResourceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void predicateChanged(String string) {
        Cache cache = this.mPredicateCache;
        synchronized (cache) {
            ++this.mPredChangeNum;
            this.mPredicateCache.remove(string);
        }
    }

    public void applicationDeletedResources(String string, int n, String string2) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationDeletedResources (" + string + ")");
        }
        this.mEnData.applicationDeletedResources(string, n, string2);
    }

    public void cleanupAfterCollectionResources(String string, long l, List list) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleanupAfterCollectionResources (" + string + ")");
        }
        this.mEnData.cleanupAfterCollectionResources(string, l, list);
    }

    public void cleanupAfterCollectionRoles(String string, long l, List list) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleanupAfterCollectionRoles (" + string + ")");
        }
        this.mEnData.cleanupAfterCollectionRoles(string, l, list);
    }

    public void cleanupAfterDeployResources(String string, int n, String string2, long l) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleanupAfterDeployResources (" + string + ")");
        }
        this.mEnData.cleanupAfterDeployResources(string, n, string2, l);
    }

    public void applicationCopyResources(String string, String string2) throws EnCreateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationCopyResources (" + string + "," + string2 + ")");
        }
        this.mEnData.applicationCopyResources(string, string2);
    }

    public void applicationDeletedRoles(String string, int n, String string2) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationDeletedRoles (" + string + ")");
        }
        this.mEnData.applicationDeletedRoles(string, n, string2);
    }

    public void cleanupAfterDeployRoles(String string, int n, String string2, long l) throws EnFinderException, EnRemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleanupAfterDeployRoles (" + string + ")");
        }
        this.mEnData.cleanupAfterDeployRoles(string, n, string2, l);
    }

    public void applicationCopyRoles(String string, String string2) throws EnCreateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationCopyRoles (" + string + "," + string2 + ")");
        }
        this.mEnData.applicationCopyRoles(string, string2);
    }

    private static Properties readProperties() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = EEngine.class.getClassLoader().getResourceAsStream(ENTITLEMENT_PROPERTIES);
            if (inputStream != null) {
                properties.load(inputStream);
            } else {
                LOG.severe("Cannot read properties file entitlement.properties\nMake sure the file is in the classpath and is permitted to read");
            }
        }
        catch (SecurityException securityException) {
            EEngine.abort("Cannot read file entitlement.properties\nThe file might be read protected\n" + securityException.getMessage(), securityException);
        }
        catch (IOException iOException) {
            EEngine.abort("Cannot read entitlement.properties\n" + iOException.getMessage(), iOException);
        }
        return properties;
    }

    private static EnData makeEnData(Properties properties) {
        EnData enData = null;
        String string = properties.getProperty(EN_DATA_CLASS_PROPERTY, EN_DATA_CLASS);
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(Properties.class);
            enData = (EnData)constructor.newInstance(properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            EEngine.abort("Cannot find class " + string + "\n" + "Make sure " + EN_DATA_CLASS_PROPERTY + " is set in " + ENTITLEMENT_PROPERTIES, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EEngine.abort("Class weblogic.entitlement.engine.endata_class does not have a constructor with one java.util.Properties argument", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            EEngine.abort("Cannot access information about " + string + " class\n" + securityException.getMessage(), securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            EEngine.abort("Cannot access constructor of class " + string + "\n" + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            EEngine.abort("Cannot create instance of class " + string + "\nMake sure class is not declared abstract.\n" + instantiationException.getMessage(), instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string2 = "Cannot instantiate " + string + "\n" + invocationTargetException.getMessage();
            Throwable throwable = invocationTargetException.getTargetException();
            LOG.severe(string2, throwable);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(string2);
        }
        return enData;
    }

    private static void abort(String string, Throwable throwable) {
        LOG.severe(string, throwable);
        throw new RuntimeException(string);
    }

    private void updateRoleCache(ERoleId eRoleId, ERole eRole) {
        String string = eRoleId.getResourceName();
        RoleCacheEntry roleCacheEntry = (RoleCacheEntry)this.mRoleCache.get(string);
        if (roleCacheEntry == null) {
            roleCacheEntry = new RoleCacheEntry();
            this.mRoleCache.put(string, roleCacheEntry);
        }
        if (eRole == null) {
            eRole = NO_ROLE;
        }
        if (eRole == NO_ROLE && roleCacheEntry.all) {
            roleCacheEntry.remove(eRoleId.getRoleName());
        } else {
            roleCacheEntry.put(eRoleId.getRoleName(), eRole);
        }
    }

    private void updateRoleCache(ERole[] eRoleArray) {
        for (int i = 0; i < eRoleArray.length; ++i) {
            this.updateRoleCache((ERoleId)eRoleArray[i].getPrimaryKey(), eRoleArray[i]);
        }
    }

    private void removeFromRoleCache(ERoleId[] eRoleIdArray) {
        for (int i = 0; i < eRoleIdArray.length; ++i) {
            this.updateRoleCache(eRoleIdArray[i], NO_ROLE);
        }
    }

    private void discardFromRoleCache(ERoleId eRoleId) {
        RoleCacheEntry roleCacheEntry = (RoleCacheEntry)this.mRoleCache.get(eRoleId.getResourceName());
        if (roleCacheEntry != null) {
            roleCacheEntry.all = false;
            roleCacheEntry.remove(eRoleId.getRoleName());
        }
    }

    private void discardFromRoleCache(ERoleId[] eRoleIdArray) {
        for (int i = 0; i < eRoleIdArray.length; ++i) {
            this.discardFromRoleCache(eRoleIdArray[i]);
        }
    }

    private void updateRoleCache(String string, ERole[] eRoleArray) {
        RoleCacheEntry roleCacheEntry = new RoleCacheEntry(eRoleArray.length);
        for (int i = 0; i < eRoleArray.length; ++i) {
            roleCacheEntry.put(eRoleArray[i].getName(), eRoleArray[i]);
        }
        roleCacheEntry.all = true;
        this.mRoleCache.put(string, roleCacheEntry);
    }

    private ERole[] getFromRoleCache(ERoleId[] eRoleIdArray) {
        ERole[] eRoleArray = new ERole[eRoleIdArray.length];
        for (int i = 0; i < eRoleIdArray.length; ++i) {
            eRoleArray[i] = this.getFromRoleCache(eRoleIdArray[i].getResourceName(), eRoleIdArray[i].getRoleName());
        }
        return eRoleArray;
    }

    public ERole getFromRoleCache(String string, String string2) {
        ERole eRole = null;
        RoleCacheEntry roleCacheEntry = (RoleCacheEntry)this.mRoleCache.get(string);
        if (roleCacheEntry != null && (eRole = (ERole)roleCacheEntry.get(string2)) == null && roleCacheEntry.all) {
            eRole = NO_ROLE;
        }
        return eRole;
    }

    private void updateResourceCache(String string, EResource eResource) {
        this.mResourceCache.put(string, eResource);
    }

    private void updateResourceCache(EResource[] eResourceArray) {
        for (int i = 0; i < eResourceArray.length; ++i) {
            this.updateResourceCache(eResourceArray[i].getName(), eResourceArray[i]);
        }
    }

    private void removeFromResourceCache(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.updateResourceCache(stringArray[i], NO_RESOURCE);
        }
    }

    private void discardFromResourceCache(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.updateResourceCache(stringArray[i], null);
        }
    }

    private EResource[] getFromResourceCache(String[] stringArray) {
        EResource[] eResourceArray = new EResource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            eResourceArray[i] = (EResource)this.mResourceCache.get(stringArray[i]);
        }
        return eResourceArray;
    }

    private void preload() {
        int n;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preloading resources");
        }
        String[] stringArray = this.getResourceNames(null).toArray(new String[0]);
        try {
            this.getResources(stringArray, false);
        }
        catch (EnFinderException enFinderException) {
            n = enFinderException.getTargetIndex();
            EEngine.abort("Cannot find resource " + (n < 0 ? "" : stringArray[n]), enFinderException);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preloading roles");
        }
        int n2 = Math.min(this.mRoleCache.getMaximumSize() - 1, stringArray.length);
        for (n = 0; n < n2; ++n) {
            this.getRoles(stringArray[n]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preloading global roles");
        }
        this.getRoles("");
    }

    public EnResourceCursor listResources(String string, int n, EnCursorResourceFilter enCursorResourceFilter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("listResources (" + string + " , " + n + " , " + (enCursorResourceFilter == null ? "null" : "filter") + ")\n");
        }
        TextFilter textFilter = string == null ? null : new TextFilter(string);
        return this.mEnData.findResources(textFilter, n, enCursorResourceFilter);
    }

    public EnRoleCursor listRoles(String string, String string2, int n, EnCursorRoleFilter enCursorRoleFilter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("listRoles (" + string + " , " + string2 + " , " + n + " , " + (enCursorRoleFilter == null ? "null" : "filter") + ")\n");
        }
        TextFilter textFilter = string == null ? null : new TextFilter(string);
        TextFilter textFilter2 = string2 == null ? null : new TextFilter(string2);
        return this.mEnData.findRoles(textFilter, textFilter2, n, enCursorRoleFilter);
    }

    public void createPolicyCollectionInfo(String string, String string2, String string3) throws EnCreateException, EnConflictException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPolicyCollectionInfo (" + string + " , " + string2 + " , " + string3 + ")\n");
        }
        this.mEnData.createPolicyCollectionInfo(string, string2, string3);
    }

    public void createRoleCollectionInfo(String string, String string2, String string3) throws EnCreateException, EnConflictException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createRoleCollectionInfo (" + string + " , " + string2 + " , " + string3 + ")\n");
        }
        this.mEnData.createRoleCollectionInfo(string, string2, string3);
    }

    public EPolicyCollectionInfo fetchPolicyCollectionInfo(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fetchPolicyCollectionInfo (" + string + ")\n");
        }
        return this.mEnData.fetchPolicyCollectionInfo(string);
    }

    public ERoleCollectionInfo fetchRoleCollectionInfo(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fetchRoleCollectionInfo (" + string + ")\n");
        }
        return this.mEnData.fetchRoleCollectionInfo(string);
    }

    private static class RoleCacheEntry
    extends HashMap {
        public volatile boolean all = false;

        public RoleCacheEntry() {
        }

        public RoleCacheEntry(int n) {
            super(n);
        }
    }

    private static class ERoleDependentDecision
    extends EDecision {
        private ECacheableRoles roleDependency;

        public ERoleDependentDecision(Boolean bl, ECacheableRoles eCacheableRoles) {
            super(bl);
            this.roleDependency = eCacheableRoles;
        }

        public boolean isApplicable(Map map) {
            return map == this.roleDependency || map != null && map instanceof ERoleMapImpl && ((ERoleMapImpl)map).ecr == this.roleDependency;
        }
    }

    private static class EDecision {
        private Boolean decision;

        public EDecision(Boolean bl) {
            this.decision = bl;
        }

        public Boolean getDecision() {
            return this.decision;
        }

        public boolean isApplicable(Map map) {
            return true;
        }
    }

    private class ERoleMapImpl
    implements Map {
        private ECacheableRoles ecr;
        private boolean loaded = false;
        private Map allowedRoles;
        private Set deniedRoles;
        private Subject subj;
        private Resource resource;
        private ContextHandler context;
        private ESubject eSubj;
        private ResourceNode eResource;

        public ERoleMapImpl(Subject subject, Resource resource, ContextHandler contextHandler, ECacheableRoles eCacheableRoles) {
            this.subj = subject;
            this.resource = resource;
            this.context = contextHandler;
            this.allowedRoles = null;
            this.deniedRoles = null;
            this.ecr = eCacheableRoles;
        }

        private void load() {
            if (!this.loaded) {
                if (this.eResource == null) {
                    this.eResource = new ResourceNodeImpl(this.resource);
                }
                if (LOG.isDebugEnabled()) {
                    if (this.eSubj == null) {
                        this.eSubj = new ESubjectImpl(this.subj);
                    }
                    LOG.debug("getRoles (" + this.eSubj + " , " + this.eResource.getName() + ")\n");
                }
                Collection collection = EEngine.this.getRoles(this.eResource);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.evaluateRolePermit((ERole)iterator.next());
                }
                this.loaded = true;
                this.deniedRoles = null;
                this.ecr.getDeniedRoles().clear();
            }
        }

        private void evaluateRolePermit(ERole eRole) {
            String string = eRole.getName();
            if (!(this.ecr.getDeniedRoles().contains(string) || this.deniedRoles != null && this.deniedRoles.contains(string) || this.ecr.getAllowedRoles().containsKey(string) || this.allowedRoles != null && this.allowedRoles.containsKey(string) || !this.evaluateRole(eRole))) {
                if (EEngine.this.checkCacheability(eRole.getExpression(), 1)) {
                    this.ecr.getAllowedRoles().put(string, new ESecurityRoleImpl(string));
                } else {
                    if (this.allowedRoles == null) {
                        this.allowedRoles = new HashMap();
                    }
                    this.allowedRoles.put(string, new ESecurityRoleImpl(string));
                }
            }
        }

        private boolean evaluateRoleRecord(String string) {
            ERole eRole;
            if (this.ecr.getAllowedRoles().containsKey(string) || this.allowedRoles != null && this.allowedRoles.containsKey(string)) {
                return true;
            }
            if (this.loaded || this.ecr.getDeniedRoles().contains(string) || this.deniedRoles != null && this.deniedRoles.contains(string)) {
                return false;
            }
            if (this.eResource == null) {
                this.eResource = new ResourceNodeImpl(this.resource);
            }
            if ((eRole = EEngine.this.getRole(this.eResource, string)) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No role found, cannot evaluate");
                }
                return false;
            }
            if (this.evaluateRole(eRole)) {
                if (EEngine.this.checkCacheability(eRole.getExpression(), 1)) {
                    this.ecr.getAllowedRoles().put(string, new ESecurityRoleImpl(string));
                } else {
                    if (this.allowedRoles == null) {
                        this.allowedRoles = new HashMap();
                    }
                    this.allowedRoles.put(string, new ESecurityRoleImpl(string));
                }
                return true;
            }
            if (EEngine.this.checkCacheability(eRole.getExpression(), 1)) {
                this.ecr.getDeniedRoles().add(string);
            } else {
                if (this.deniedRoles == null) {
                    this.deniedRoles = new HashSet();
                }
                this.deniedRoles.add(string);
            }
            return false;
        }

        public boolean isCacheableOnly() {
            return this.allowedRoles == null && this.deniedRoles == null;
        }

        private boolean evaluateRole(ERole eRole) {
            if (this.eSubj == null) {
                this.eSubj = new ESubjectImpl(this.subj);
            }
            if (this.eResource == null) {
                this.eResource = new ResourceNodeImpl(this.resource);
            }
            boolean bl = EEngine.this.evaluate(this.eSubj, eRole, this.eResource, this.context);
            if (LOG.isDebugEnabled()) {
                LOG.debug((bl ? "Role is permitted: " : "Role is denied: ") + eRole.getPrimaryKey());
            }
            return bl;
        }

        public Object get(Object object) {
            if (this.containsKey(object)) {
                Object v = this.ecr.getAllowedRoles().get(object);
                return v != null ? v : this.allowedRoles.get(object);
            }
            return null;
        }

        public boolean containsKey(Object object) {
            if (object == null) {
                return false;
            }
            return this.evaluateRoleRecord(object.toString());
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException(SecurityLogger.getMapCanNotBeModified());
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException(SecurityLogger.getMapCanNotBeModified());
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException(SecurityLogger.getMapCanNotBeModified());
        }

        public void clear() {
            throw new UnsupportedOperationException(SecurityLogger.getMapCanNotBeModified());
        }

        public boolean containsValue(Object object) {
            Object object2;
            Object object3 = object2 = object instanceof SecurityRole ? ((SecurityRole)object).getName() : object;
            if (this.ecr.getDeniedRoles().contains(object2) || this.deniedRoles != null && this.deniedRoles.contains(object2)) {
                return false;
            }
            this.load();
            return this.ecr.getAllowedRoles().containsValue(object) || this.allowedRoles != null && this.allowedRoles.containsValue(object);
        }

        public boolean isEmpty() {
            boolean bl;
            boolean bl2 = bl = this.ecr.getAllowedRoles().isEmpty() && (this.allowedRoles == null || this.allowedRoles.isEmpty());
            if (bl && !this.loaded) {
                this.load();
                bl = this.ecr.getAllowedRoles().isEmpty() && (this.allowedRoles == null || this.allowedRoles.isEmpty());
            }
            return bl;
        }

        public int size() {
            this.load();
            int n = this.ecr.getAllowedRoles().size();
            if (this.allowedRoles != null) {
                n += this.allowedRoles.size();
            }
            return n;
        }

        public Set entrySet() {
            this.load();
            if (this.allowedRoles == null) {
                return this.ecr.getAllowedRoles().entrySet();
            }
            if (this.ecr.getAllowedRoles().isEmpty()) {
                return this.allowedRoles.entrySet();
            }
            return new CombinedSet(new Collection[]{this.allowedRoles.entrySet(), this.ecr.getAllowedRoles().entrySet()});
        }

        public Set keySet() {
            this.load();
            if (this.allowedRoles == null) {
                return this.ecr.getAllowedRoles().keySet();
            }
            if (this.ecr.getAllowedRoles().isEmpty()) {
                return this.allowedRoles.keySet();
            }
            return new CombinedSet(new Collection[]{this.allowedRoles.keySet(), this.ecr.getAllowedRoles().keySet()});
        }

        public Collection values() {
            this.load();
            if (this.allowedRoles == null) {
                return this.ecr.getAllowedRoles().values();
            }
            if (this.ecr.getAllowedRoles().isEmpty()) {
                return this.allowedRoles.values();
            }
            return new CombinedSet(new Collection[]{this.allowedRoles.values(), this.ecr.getAllowedRoles().values()});
        }

        public String toString() {
            Iterator iterator = this.keySet().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            if (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(",").append(iterator.next());
            }
            return stringBuffer.toString();
        }
    }

    private static class ECacheableRoles {
        private Map allowedRoles = new ConcurrentHashMap();
        private Set deniedRoles = new ConcurrentHashSet();

        public Map getAllowedRoles() {
            return this.allowedRoles;
        }

        public Set getDeniedRoles() {
            return this.deniedRoles;
        }
    }

    private static class ESecurityRoleImpl
    implements SecurityRole {
        private String roleName;

        public ESecurityRoleImpl(Object object) {
            this.roleName = object.toString();
        }

        public String getName() {
            return this.roleName;
        }

        public String getDescription() {
            return this.roleName;
        }

        public String toString() {
            return this.roleName;
        }

        public int hashCode() {
            return this.roleName.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ESecurityRoleImpl)) {
                return false;
            }
            ESecurityRoleImpl eSecurityRoleImpl = (ESecurityRoleImpl)object;
            return this.roleName.equals(eSecurityRoleImpl.roleName);
        }
    }
}

