/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.engine;

import java.util.ArrayList;
import weblogic.entitlement.engine.ResourceNode;
import weblogic.security.spi.Resource;

public class ResourceNodeImpl
implements ResourceNode {
    private String name;
    private String[] namePath;
    private Resource resource;

    public ResourceNodeImpl(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("null resource");
        }
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.resource.toString();
        }
        return this.name;
    }

    public ResourceNode getParent() {
        Resource resource = this.resource.getParentResource();
        return resource == null ? null : new ResourceNodeImpl(resource);
    }

    public String[] getNamePathToRoot() {
        if (this.namePath == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getName());
            for (Resource resource = this.resource.getParentResource(); resource != null; resource = resource.getParentResource()) {
                arrayList.add(resource.toString());
            }
            this.namePath = arrayList.toArray(new String[arrayList.size()]);
        }
        return this.namePath;
    }
}

