/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.engine.cache;

import java.util.Set;
import javax.security.auth.Subject;
import weblogic.entitlement.engine.cache.Key;
import weblogic.entitlement.engine.cache.ResourceTreeMap;
import weblogic.security.spi.Resource;
import weblogic.utils.collections.SecondChanceCacheMap;

public class ResourceDecisionCache {
    private SecondChanceCacheMap cache;
    private ResourceTreeMap resourceMap;
    private ThreadLocal keys;

    public ResourceDecisionCache(int n) {
        this.cache = new SecondChanceCacheMap(n);
        this.resourceMap = new ResourceTreeMap();
        this.keys = new ThreadLocal(){

            protected Object initialValue() {
                return new Key(null, null);
            }
        };
    }

    public Object lookupDecision(Resource resource, Subject subject) {
        Key key = (Key)this.keys.get();
        key.setValues(resource, subject);
        return this.cache.get((Object)key);
    }

    public int size() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheDecision(Resource resource, Subject subject, Object object) {
        Key key = new Key(resource, subject);
        ResourceTreeMap resourceTreeMap = this.resourceMap;
        synchronized (resourceTreeMap) {
            Key key2 = (Key)this.cache.insert((Object)key, object);
            if (key2 != null) {
                this.resourceMap.removeKey(key2);
            }
            if (resource != null) {
                this.resourceMap.insertKey(resource, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncacheDecision(Resource resource, Subject subject) {
        Key key = new Key(resource, subject);
        ResourceTreeMap resourceTreeMap = this.resourceMap;
        synchronized (resourceTreeMap) {
            this.cache.remove((Object)key);
            this.resourceMap.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncache(String string) {
        Set set;
        ResourceTreeMap resourceTreeMap = this.resourceMap;
        synchronized (resourceTreeMap) {
            set = this.resourceMap.resourceChanged(string);
        }
        if (set != null) {
            for (Key key : set) {
                this.cache.remove((Object)key);
            }
        }
    }
}

