/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.engine.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.entitlement.engine.cache.Key;
import weblogic.security.spi.Resource;

public class ResourceTreeMap {
    private Map treeMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertKey(Resource resource, Key key) {
        Map map = this.treeMap;
        synchronized (map) {
            this.getNode(resource).getKeys().add(key);
        }
    }

    private TreeNode getNode(Resource resource) {
        String string = resource != null ? resource.toString() : null;
        TreeNode treeNode = (TreeNode)this.treeMap.get(string);
        if (treeNode == null) {
            if (resource != null) {
                TreeNode treeNode2 = this.getNode(resource.getParentResource());
                treeNode = new TreeNode(treeNode2, string);
                treeNode2.getChildren().add(treeNode);
            } else {
                treeNode = new TreeNode(null, string);
            }
            this.treeMap.put(string, treeNode);
        }
        return treeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(Key key) {
        if (key != null) {
            Resource resource = key.getResource();
            Map map = this.treeMap;
            synchronized (map) {
                TreeNode treeNode = (TreeNode)this.treeMap.get(resource != null ? resource.toString() : null);
                if (treeNode != null && treeNode.hasKeys()) {
                    treeNode.getKeys().remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set resourceChanged(String string) {
        HashSet hashSet = new HashSet();
        Map map = this.treeMap;
        synchronized (map) {
            TreeNode treeNode = (TreeNode)this.treeMap.remove(string);
            if (treeNode != null) {
                TreeNode treeNode2 = treeNode.getParent();
                if (treeNode2 != null) {
                    treeNode2.getChildren().remove(treeNode);
                }
                this.removeNode(treeNode, hashSet);
            }
        }
        return hashSet;
    }

    private void removeNode(TreeNode treeNode, Set set) {
        if (treeNode.hasKeys()) {
            set.addAll(treeNode.getKeys());
        }
        if (treeNode.hasChildren()) {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.treeMap.remove(treeNode2.getResource());
                this.removeNode(treeNode2, set);
            }
        }
    }

    private static class TreeNode {
        private String resource;
        private TreeNode parent;
        private Collection children;
        private Set keys;

        public TreeNode(TreeNode treeNode, String string) {
            this.parent = treeNode;
            this.resource = string;
        }

        public String getResource() {
            return this.resource;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public Collection getChildren() {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            return this.children;
        }

        public boolean hasKeys() {
            return this.keys != null && !this.keys.isEmpty();
        }

        public Set getKeys() {
            if (this.keys == null) {
                this.keys = new HashSet();
            }
            return this.keys;
        }
    }
}

