/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.expression;

import weblogic.entitlement.expression.Difference;
import weblogic.entitlement.expression.EExpression;
import weblogic.entitlement.expression.Empty;
import weblogic.entitlement.expression.GroupIdentifier;
import weblogic.entitlement.expression.GroupList;
import weblogic.entitlement.expression.Intersection;
import weblogic.entitlement.expression.Inverse;
import weblogic.entitlement.expression.PredicateOp;
import weblogic.entitlement.expression.RoleIdentifier;
import weblogic.entitlement.expression.RoleList;
import weblogic.entitlement.expression.Union;
import weblogic.entitlement.expression.UserIdentifier;
import weblogic.entitlement.expression.UserList;
import weblogic.security.shared.LoggerWrapper;

public abstract class EExprRep
implements EExpression {
    protected static int DEPENDS_ON_UNKNOWN;
    private static LoggerWrapper LOG;
    private int dependsOn = DEPENDS_ON_UNKNOWN;
    protected boolean Enclosed = false;

    public void SetEnclosed() {
        this.Enclosed = true;
    }

    public final int getDependsOn() {
        if (this.dependsOn == DEPENDS_ON_UNKNOWN) {
            this.dependsOn = this.getDependsOnInternal();
        }
        return this.dependsOn;
    }

    protected abstract int getDependsOnInternal();

    public final String externalize() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeExternalForm(stringBuffer);
        return stringBuffer.toString();
    }

    protected abstract void writeExternalForm(StringBuffer var1);

    public String serialize() {
        StringBuffer stringBuffer = new StringBuffer();
        this.outForPersist(stringBuffer);
        return stringBuffer.toString();
    }

    abstract void outForPersist(StringBuffer var1);

    abstract char getTypeId();

    protected void writeTypeId(StringBuffer stringBuffer) {
        stringBuffer.append((char)(this.getTypeId() | (this.Enclosed ? 128 : 0)));
    }

    public static EExprRep deserialize(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[]{0};
        return EExprRep.deserialize(cArray, nArray);
    }

    private static EExprRep deserialize(char[] cArray, int[] nArray) {
        int n = nArray[0];
        nArray[0] = n + 1;
        char c = cArray[n];
        char c2 = (char)(c & 0x7F);
        EExprRep eExprRep = null;
        switch (c2) {
            case 'u': {
                eExprRep = new UserIdentifier(EExprRep.getStr(cArray, nArray));
                break;
            }
            case 'g': {
                eExprRep = new GroupIdentifier(EExprRep.getStr(cArray, nArray));
                break;
            }
            case 'r': {
                eExprRep = new RoleIdentifier(EExprRep.getStr(cArray, nArray));
                break;
            }
            case 'p': {
                String string = EExprRep.getStr(cArray, nArray);
                int n2 = nArray[0];
                nArray[0] = n2 + 1;
                int n3 = cArray[n2];
                String[] stringArray = null;
                if (n3 > 0) {
                    stringArray = new String[n3];
                    for (int i = 0; i < n3; ++i) {
                        stringArray[i] = EExprRep.getStr(cArray, nArray);
                    }
                }
                try {
                    eExprRep = new PredicateOp(string, stringArray);
                }
                catch (Exception exception) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("Failed to deserialize a predicate in expression", exception);
                }
                break;
            }
            case 'e': {
                return Empty.EMPTY;
            }
            case '|': {
                eExprRep = new Union(EExprRep.getFuncArgs(cArray, nArray));
                break;
            }
            case '&': {
                eExprRep = new Intersection(EExprRep.getFuncArgs(cArray, nArray));
                break;
            }
            case '-': {
                eExprRep = new Difference(EExprRep.getFuncArgs(cArray, nArray));
                break;
            }
            case '~': {
                eExprRep = new Inverse(EExprRep.getFuncArgs(cArray, nArray)[0]);
                break;
            }
            case 'U': {
                eExprRep = new UserList(EExprRep.getFuncArgs(cArray, nArray));
                break;
            }
            case 'G': {
                eExprRep = new GroupList(EExprRep.getFuncArgs(cArray, nArray));
                break;
            }
            case 'R': {
                eExprRep = new RoleList(EExprRep.getFuncArgs(cArray, nArray));
                break;
            }
            default: {
                throw new RuntimeException("Invalid expression type id: " + c2);
            }
        }
        eExprRep.Enclosed = c > '\u0080';
        return eExprRep;
    }

    private static String getStr(char[] cArray, int[] nArray) {
        int n = nArray[0];
        while (nArray[0] < cArray.length && cArray[nArray[0]] != '\n') {
            nArray[0] = nArray[0] + 1;
        }
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        return new String(cArray, n, n2 - n);
    }

    protected static void writeStr(String string, StringBuffer stringBuffer) {
        stringBuffer.append(string).append('\n');
    }

    private static EExprRep[] getFuncArgs(char[] cArray, int[] nArray) {
        int n = nArray[0];
        nArray[0] = n + 1;
        int n2 = cArray[n];
        EExprRep[] eExprRepArray = new EExprRep[n2];
        for (int i = 0; i < n2; ++i) {
            eExprRepArray[i] = EExprRep.deserialize(cArray, nArray);
        }
        return eExprRepArray;
    }

    static {
        LOG = LoggerWrapper.getInstance("SecurityEEngine");
    }
}

