/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.expression;

import weblogic.entitlement.expression.EExprRep;

public abstract class Function
extends EExprRep {
    protected EExprRep[] mArgs;

    public Function(EExprRep eExprRep) {
        if (eExprRep == null) {
            throw new IllegalArgumentException("Null function argument");
        }
        this.mArgs = new EExprRep[1];
        this.mArgs[0] = eExprRep;
    }

    public Function(EExprRep eExprRep, EExprRep eExprRep2) {
        if (eExprRep == null || eExprRep2 == null) {
            throw new IllegalArgumentException("Null " + (eExprRep == null ? "first" : "second") + " function argument");
        }
        this.mArgs = new EExprRep[2];
        this.mArgs[0] = eExprRep;
        this.mArgs[1] = eExprRep2;
    }

    public Function(EExprRep[] eExprRepArray) {
        for (int i = 0; i < eExprRepArray.length; ++i) {
            if (eExprRepArray[i] != null) continue;
            throw new IllegalArgumentException("Null function argument " + i);
        }
        this.mArgs = new EExprRep[eExprRepArray.length];
        System.arraycopy(eExprRepArray, 0, this.mArgs, 0, eExprRepArray.length);
    }

    protected int getDependsOnInternal() {
        int n = DEPENDS_ON_UNKNOWN;
        for (int i = 0; i < this.mArgs.length; ++i) {
            n |= this.mArgs[i].getDependsOn();
        }
        return n;
    }

    protected void setArg(int n, EExprRep eExprRep) {
        if (eExprRep == null) {
            throw new IllegalArgumentException("EExprRep argument is null");
        }
        this.mArgs[n] = eExprRep;
    }

    void outForPersist(StringBuffer stringBuffer) {
        this.writeTypeId(stringBuffer);
        stringBuffer.append((char)this.mArgs.length);
        for (int i = 0; i < this.mArgs.length; ++i) {
            this.mArgs[i].outForPersist(stringBuffer);
        }
    }

    protected void writeExternalForm(StringBuffer stringBuffer) {
        if (this.Enclosed) {
            stringBuffer.append('{');
        }
        if (this.mArgs.length > 0) {
            for (int i = 0; i < this.mArgs.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(this.getTypeId());
                }
                this.mArgs[i].writeExternalForm(stringBuffer);
            }
        }
        if (this.Enclosed) {
            stringBuffer.append('}');
        }
    }
}

