/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.expression;

import weblogic.entitlement.engine.EEngine;
import weblogic.entitlement.engine.ESubject;
import weblogic.entitlement.engine.PredicateRegistry;
import weblogic.entitlement.engine.ResourceNode;
import weblogic.entitlement.engine.UnregisteredPredicateException;
import weblogic.entitlement.expression.EExprRep;
import weblogic.entitlement.expression.InvalidPredicateClassException;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.Predicate;
import weblogic.security.service.ContextHandler;

public class PredicateOp
extends EExprRep {
    private Predicate mPredicate = null;
    private String[] mArgs = null;

    public PredicateOp() {
    }

    public PredicateOp(String string) throws InvalidPredicateClassException, IllegalPredicateArgumentException {
        this(string, null);
    }

    public PredicateOp(String string, String[] stringArray) throws InvalidPredicateClassException, IllegalPredicateArgumentException {
        this.mPredicate = EEngine.validatePredicate(string);
        this.mArgs = stringArray;
        String[] stringArray2 = new String[stringArray == null ? 0 : stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i].startsWith("\"") && stringArray[i].endsWith("\"") ? stringArray[i].substring(1, stringArray[i].length() - 1) : stringArray[i];
        }
        this.mPredicate.init(stringArray2);
    }

    protected int getDependsOnInternal() {
        return 4;
    }

    public final boolean evaluate(ESubject eSubject, ResourceNode resourceNode, ContextHandler contextHandler, PredicateRegistry predicateRegistry) {
        if (!predicateRegistry.isRegistered(this.getPredicateClassName())) {
            throw new UnregisteredPredicateException(this.getPredicateClassName());
        }
        return this.mPredicate.evaluate(eSubject.getSubject(), resourceNode.getResource(), contextHandler);
    }

    public String getPredicateClassName() {
        return this.mPredicate.getClass().getName();
    }

    public String[] getPredicateArguments() {
        return this.mArgs;
    }

    char getTypeId() {
        return 'p';
    }

    void outForPersist(StringBuffer stringBuffer) {
        this.writeTypeId(stringBuffer);
        PredicateOp.writeStr(this.getPredicateClassName(), stringBuffer);
        int n = this.mArgs == null ? 0 : this.mArgs.length;
        stringBuffer.append((char)n);
        for (int i = 0; i < n; ++i) {
            PredicateOp.writeStr(this.mArgs[i], stringBuffer);
        }
    }

    protected void writeExternalForm(StringBuffer stringBuffer) {
        if (this.Enclosed) {
            stringBuffer.append('{');
        }
        stringBuffer.append('?');
        stringBuffer.append(this.getPredicateClassName());
        stringBuffer.append('(');
        String[] stringArray = this.getPredicateArguments();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        stringBuffer.append(')');
        if (this.Enclosed) {
            stringBuffer.append('}');
        }
    }
}

