/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.parser;

import weblogic.entitlement.expression.Difference;
import weblogic.entitlement.expression.EExprRep;
import weblogic.entitlement.expression.EExpression;
import weblogic.entitlement.expression.Empty;
import weblogic.entitlement.expression.GroupIdentifier;
import weblogic.entitlement.expression.GroupList;
import weblogic.entitlement.expression.Intersection;
import weblogic.entitlement.expression.InvalidPredicateClassException;
import weblogic.entitlement.expression.Inverse;
import weblogic.entitlement.expression.PredicateOp;
import weblogic.entitlement.expression.RoleIdentifier;
import weblogic.entitlement.expression.RoleList;
import weblogic.entitlement.expression.Union;
import weblogic.entitlement.expression.UserIdentifier;
import weblogic.entitlement.expression.UserList;
import weblogic.entitlement.parser.ParseException;
import weblogic.entitlement.util.Escaping;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;

public class Parser {
    public static final char UNION = '|';
    public static final char INTERSECT = '&';
    public static final char DIFFERENCE = '-';
    public static final char COMPLEMENT = '~';
    public static final char PREDICATE = '?';
    public static final String USR_LIST = "Usr";
    public static final String GROUP_LIST = "Grp";
    public static final String ROLE_LIST = "Rol";
    public static final char LIST_START = '(';
    public static final char LIST_END = ')';
    public static final char LIST_SEPARATOR = ',';
    public static final char SUB_EEXPR_OPEN = '{';
    public static final char SUB_EEXPR_CLOSE = '}';
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char NEW_LINE = '\n';
    public static final char USR_IDENTIFIER = 'u';
    public static final char GRP_IDENTIFIER = 'g';
    public static final char ROL_IDENTIFIER = 'r';
    public static final char PRE_IDENTIFIER = 'p';
    public static final char EMP_IDENTIFIER = 'e';
    public static final char USER_UNION = 'U';
    public static final char GROUP_UNION = 'G';
    public static final char ROLE_UNION = 'R';
    public static final String UNCHECKED_EXPR = "{ ?weblogic.entitlement.rules.UncheckedPolicy() }";
    public static final String EXCLUDED_EXPR = "{ ?weblogic.entitlement.rules.ExcludedPolicy() }";
    private static final Escaping escaper = new Escaping(new char[]{'#', '|', '&', '-', '~', '(', ')', ',', '{', '}', ' ', '\t', '?', '\n'});

    public static EExpression parseResourceExpression(String string) throws ParseException, IllegalPredicateArgumentException, InvalidPredicateClassException {
        char[] cArray = string.toCharArray();
        return Parser.parse(cArray, new int[]{0}, new int[]{cArray.length}, 0, true);
    }

    public static EExpression parseRoleExpression(String string) throws ParseException, IllegalPredicateArgumentException, InvalidPredicateClassException {
        char[] cArray = string.toCharArray();
        return Parser.parse(cArray, new int[]{0}, new int[]{cArray.length}, 0, false);
    }

    public static String uncheckedExpr() {
        return UNCHECKED_EXPR;
    }

    public static String excludedExpr() {
        return EXCLUDED_EXPR;
    }

    public static String roles2Expr(String[] stringArray) {
        return Parser.toExpr(stringArray, ROLE_LIST);
    }

    public static String users2Expr(String[] stringArray) {
        return Parser.toExpr(stringArray, USR_LIST);
    }

    public static String groups2Expr(String[] stringArray) {
        return Parser.toExpr(stringArray, GROUP_LIST);
    }

    public static String escape(String string) {
        return escaper.escapeString(string);
    }

    public static String unescape(String string) {
        return escaper.unescapeString(string);
    }

    private static String toExpr(String[] stringArray, String string) {
        if (stringArray.length == 0) {
            return "";
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].length();
        }
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        stringBuffer.append('{');
        stringBuffer.append(string);
        stringBuffer.append('(');
        stringBuffer.append(escaper.escapeString(stringArray[0]));
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(escaper.escapeString(stringArray[i]));
        }
        stringBuffer.append(')');
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static EExprRep parse(char[] cArray, int[] nArray, int[] nArray2, int n, boolean bl) throws ParseException, IllegalPredicateArgumentException, InvalidPredicateClassException {
        EExprRep[] eExprRepArray;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = nArray[0]; n2 < nArray2[0] && n4 >= 0; ++n2) {
            if (cArray[n2] == '{') {
                ++n4;
            } else if (cArray[n2] == '}') {
                --n4;
            }
            if (n4 != 0) continue;
            ++n3;
        }
        n2 = 2 + n3 / 2;
        String[] stringArray = new String[n2];
        EExprRep[] eExprRepArray2 = new EExprRep[n2];
        int n5 = 0;
        EExprRep eExprRep = null;
        char[] cArray2 = new char[2];
        int n6 = -1;
        boolean bl2 = false;
        Parser.skipSpace(cArray, nArray, nArray2, null);
        while (nArray[0] < nArray2[0]) {
            switch (cArray[nArray[0]]) {
                case '&': 
                case '-': 
                case '|': 
                case '~': {
                    if (eExprRep != null) {
                        eExprRepArray2[n5++] = eExprRep;
                        eExprRep = null;
                    }
                    if (n6 >= 0 && cArray2[n6] == cArray[nArray[0]]) {
                        if ('~' != cArray[nArray[0]]) break;
                        --n6;
                        break;
                    }
                    if (n6 >= 0 && '~' != cArray[nArray[0]]) {
                        eExprRepArray = new EExprRep[n5];
                        System.arraycopy(eExprRepArray2, 0, eExprRepArray, 0, n5);
                        switch (cArray2[n6--]) {
                            case '|': {
                                eExprRep = new Union(eExprRepArray);
                                break;
                            }
                            case '&': {
                                eExprRep = new Intersection(eExprRepArray);
                                break;
                            }
                            case '-': {
                                eExprRep = new Difference(eExprRepArray);
                            }
                        }
                        n5 = 0;
                        eExprRepArray2[n5++] = eExprRep;
                        eExprRep = null;
                    }
                    cArray2[++n6] = cArray[nArray[0]];
                    break;
                }
                case 'U': 
                case 'u': {
                    if (cArray[nArray[0] + 1] != 's' || cArray[nArray[0] + 2] != 'r') {
                        throw new ParseException(Parser.syntaxMsg("Unknown word", cArray, nArray[0]));
                    }
                    if (eExprRep != null) {
                        throw new ParseException(Parser.syntaxMsg("Operator missing", cArray, nArray[0]));
                    }
                    nArray[0] = nArray[0] + 3;
                    Parser.skipSpace(cArray, nArray, nArray2, "Incomplete 'Usr()' construct.");
                    int n7 = Parser.parseToCloseParam(cArray, nArray, nArray2, stringArray, false);
                    if (n7 == 0) {
                        throw new ParseException("Missing arguments for 'Usr()' construct.");
                    }
                    if (n7 == 1) {
                        eExprRep = new UserIdentifier(escaper.unescapeString(stringArray[0]));
                        break;
                    }
                    eExprRepArray = new UserIdentifier[n7];
                    for (int i = 0; i < n7; ++i) {
                        eExprRepArray[i] = new UserIdentifier(escaper.unescapeString(stringArray[i]));
                    }
                    eExprRep = new UserList(eExprRepArray);
                    break;
                }
                case 'G': 
                case 'g': {
                    if (cArray[nArray[0] + 1] != 'r' || cArray[nArray[0] + 2] != 'p') {
                        throw new ParseException(Parser.syntaxMsg("Unknown word", cArray, nArray[0]));
                    }
                    if (eExprRep != null) {
                        throw new ParseException(Parser.syntaxMsg("Operator missing", cArray, nArray[0]));
                    }
                    nArray[0] = nArray[0] + 3;
                    Parser.skipSpace(cArray, nArray, nArray2, "Incomplete 'Grp()' construct.");
                    int n7 = Parser.parseToCloseParam(cArray, nArray, nArray2, stringArray, false);
                    if (n7 == 0) {
                        throw new ParseException("Missing arguments for 'Grp()' construct.");
                    }
                    if (n7 == 1) {
                        eExprRep = new GroupIdentifier(escaper.unescapeString(stringArray[0]));
                        break;
                    }
                    eExprRepArray = new GroupIdentifier[n7];
                    for (int i = 0; i < n7; ++i) {
                        eExprRepArray[i] = new GroupIdentifier(escaper.unescapeString(stringArray[i]));
                    }
                    eExprRep = new GroupList(eExprRepArray);
                    break;
                }
                case 'R': 
                case 'r': {
                    if (cArray[nArray[0] + 1] != 'o' || cArray[nArray[0] + 2] != 'l') {
                        throw new ParseException(Parser.syntaxMsg("Unknown word", cArray, nArray[0]));
                    }
                    if (eExprRep != null) {
                        throw new ParseException(Parser.syntaxMsg("Operator missing", cArray, nArray[0]));
                    }
                    if (!bl) {
                        throw new ParseException(Parser.syntaxMsg("Role within role is not allowed", cArray, nArray[0]));
                    }
                    nArray[0] = nArray[0] + 3;
                    Parser.skipSpace(cArray, nArray, nArray2, "Incomplete 'Rol()' construct.");
                    int n7 = Parser.parseToCloseParam(cArray, nArray, nArray2, stringArray, false);
                    if (n7 == 0) {
                        throw new ParseException("Missing arguments for 'Rol()' construct.");
                    }
                    if (n7 == 1) {
                        eExprRep = new RoleIdentifier(escaper.unescapeString(stringArray[0]));
                        break;
                    }
                    eExprRepArray = new RoleIdentifier[n7];
                    for (int i = 0; i < n7; ++i) {
                        eExprRepArray[i] = new RoleIdentifier(escaper.unescapeString(stringArray[i]));
                    }
                    eExprRep = new RoleList(eExprRepArray);
                    break;
                }
                case '{': {
                    if (eExprRep != null) {
                        throw new ParseException(Parser.syntaxMsg("Operator missing", cArray, nArray[0]));
                    }
                    nArray[0] = nArray[0] + 1;
                    eExprRep = Parser.parse(cArray, nArray, nArray2, n + 1, bl);
                    break;
                }
                case '}': {
                    if (n == 0) {
                        throw new ParseException(Parser.syntaxMsg("Extra '}'.", cArray, nArray[0]));
                    }
                    if (eExprRep != null) {
                        eExprRepArray2[n5++] = eExprRep;
                        eExprRep = null;
                    }
                    if (n5 > 0) {
                        if (n6 >= 0) {
                            eExprRepArray = new EExprRep[n5];
                            System.arraycopy(eExprRepArray2, 0, eExprRepArray, 0, n5);
                            switch (cArray2[n6--]) {
                                case '|': {
                                    eExprRep = new Union(eExprRepArray);
                                    break;
                                }
                                case '&': {
                                    eExprRep = new Intersection(eExprRepArray);
                                    break;
                                }
                                case '-': {
                                    eExprRep = new Difference(eExprRepArray);
                                }
                            }
                            n5 = 0;
                        } else {
                            eExprRep = eExprRepArray2[0];
                        }
                    }
                    if (n6 >= 0) {
                        throw new ParseException(Parser.syntaxMsg("Missing operand for operator '" + cArray2[n6] + "'.", cArray, nArray[0]));
                    }
                    nArray[0] = nArray[0] + 1;
                    if (eExprRep != null && eExprRep != Empty.EMPTY) {
                        eExprRep.SetEnclosed();
                    }
                    return eExprRep == null ? Empty.EMPTY : eExprRep;
                }
                case '?': {
                    if (eExprRep != null) {
                        throw new ParseException(Parser.syntaxMsg("Operator missing", cArray, nArray[0]));
                    }
                    nArray[0] = nArray[0] + 1;
                    Parser.skipSpace(cArray, nArray, nArray2, "Predicate class name is expected");
                    int n7 = nArray[0];
                    while (nArray[0] < nArray2[0] && cArray[nArray[0]] != '(' && !Parser.isWhitespace(cArray[nArray[0]])) {
                        Parser.validateChar(cArray[nArray[0]], nArray[0]);
                        nArray[0] = nArray[0] + 1;
                    }
                    eExprRepArray = new String(cArray, n7, nArray[0] - n7);
                    Parser.skipSpace(cArray, nArray, nArray2, "Missing '('.");
                    n7 = Parser.parseToCloseParam(cArray, nArray, nArray2, stringArray, true);
                    String[] stringArray2 = new String[n7];
                    while (n7-- > 0) {
                        stringArray2[n7] = escaper.unescapeString(stringArray[n7]);
                    }
                    eExprRep = new PredicateOp((String)eExprRepArray, stringArray2);
                    break;
                }
                default: {
                    throw new ParseException(Parser.syntaxMsg("Unknown word", cArray, nArray[0]));
                }
            }
            if (eExprRep == null) {
                nArray[0] = nArray[0] + 1;
            } else if (n6 >= 0 && cArray2[n6] == '~') {
                --n6;
                eExprRep = new Inverse(eExprRep);
            }
            Parser.skipSpace(cArray, nArray, nArray2, null);
        }
        if (n6 >= 0) {
            if (eExprRep != null) {
                eExprRepArray2[n5++] = eExprRep;
                eExprRep = null;
            }
            eExprRepArray = new EExprRep[n5];
            System.arraycopy(eExprRepArray2, 0, eExprRepArray, 0, n5);
            switch (cArray2[n6--]) {
                case '|': {
                    eExprRep = new Union(eExprRepArray);
                    break;
                }
                case '&': {
                    eExprRep = new Intersection(eExprRepArray);
                    break;
                }
                case '-': {
                    eExprRep = new Difference(eExprRepArray);
                }
            }
        }
        if (n != 0) {
            throw new ParseException(Parser.syntaxMsg("Unbalanced '{'.", cArray, nArray[0]));
        }
        return eExprRep;
    }

    private static void skipSpace(char[] cArray, int[] nArray, int[] nArray2, String string) throws ParseException {
        while (nArray[0] < nArray2[0]) {
            if (!Parser.isWhitespace(cArray[nArray[0]])) {
                return;
            }
            nArray[0] = nArray[0] + 1;
        }
        if (string != null) {
            throw new ParseException(Parser.syntaxMsg(string, cArray, nArray[0]));
        }
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    private static int parseToCloseParam(char[] cArray, int[] nArray, int[] nArray2, String[] stringArray, boolean bl) throws ParseException {
        int n = nArray[0];
        nArray[0] = n + 1;
        if (cArray[n] != '(') {
            throw new ParseException(Parser.syntaxMsg("Missing '('.", cArray, nArray[0]));
        }
        Parser.skipSpace(cArray, nArray, nArray2, "Missing ')'.");
        int n2 = 0;
        int n3 = -1;
        boolean bl2 = false;
        int n4 = nArray[0];
        if (bl && cArray[nArray[0]] == '\"') {
            bl2 = true;
            nArray[0] = nArray[0] + 1;
        }
        while (true) {
            if (bl2) {
                if (nArray[0] == nArray2[0]) {
                    throw new ParseException(Parser.syntaxMsg("Unbalanced quote '\"'.", cArray, nArray[0]));
                }
                if (cArray[nArray[0]] == '\"') {
                    n3 = nArray[0] = nArray[0] + 1;
                    bl2 ^= true;
                    continue;
                }
            } else {
                if (nArray[0] == nArray2[0]) {
                    throw new ParseException(Parser.syntaxMsg("Missing ')'.", cArray, nArray[0]));
                }
                if (cArray[nArray[0]] == '(') {
                    throw new ParseException(Parser.syntaxMsg("Unexpected nested '('.", cArray, nArray[0]));
                }
                if (cArray[nArray[0]] == '{') {
                    throw new ParseException(Parser.syntaxMsg("Unexpected '{' inside '(...)'.", cArray, nArray[0]));
                }
                if (Parser.isWhitespace(cArray[nArray[0]])) {
                    if (n3 == -1) {
                        n3 = nArray[0];
                    }
                    Parser.skipSpace(cArray, nArray, nArray2, "Missing ')'.");
                }
                if (cArray[nArray[0]] == ',' || cArray[nArray[0]] == ')') {
                    if (n3 == -1) {
                        n3 = nArray[0];
                    }
                    if (n3 == n4) {
                        if (bl) {
                            int n5 = nArray[0];
                            nArray[0] = n5 + 1;
                            if (cArray[n5] == ')') {
                                Parser.skipSpace(cArray, nArray, nArray2, null);
                                return n2;
                            }
                        }
                        throw new ParseException(Parser.syntaxMsg("Missing name.", cArray, nArray[0]));
                    }
                    stringArray[n2++] = new String(cArray, n4, n3 - n4);
                    int n6 = nArray[0];
                    nArray[0] = n6 + 1;
                    if (cArray[n6] == ')') {
                        Parser.skipSpace(cArray, nArray, nArray2, null);
                        return n2;
                    }
                    Parser.skipSpace(cArray, nArray, nArray2, "Missing ')'.");
                    n4 = nArray[0];
                    n3 = -1;
                    continue;
                }
                if (n3 != -1) {
                    throw new ParseException(Parser.syntaxMsg("Missing ',' delimiter.", cArray, nArray[0]));
                }
            }
            Parser.validateChar(cArray[nArray[0]], nArray[0]);
            nArray[0] = nArray[0] + 1;
        }
    }

    private static void validateChar(char c, int n) throws ParseException {
        switch (c) {
            case '&': 
            case ')': 
            case ',': 
            case '-': 
            case '?': 
            case '{': 
            case '|': 
            case '~': {
                throw new ParseException("Character '" + c + "'not allowed.", n);
            }
        }
    }

    private static String syntaxMsg(String string, char[] cArray, int n) {
        return string + " for '" + new String(cArray) + "' at position:" + n;
    }

    public static void main(String[] stringArray) throws Exception {
        EExpression eExpression = Parser.parseResourceExpression(stringArray[0]);
        System.out.println("Expression: " + eExpression.externalize());
    }
}

